/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.ui.ridgets.swt.ColumnUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.OutputAwareValidator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableComparator;
import org.eclipse.riena.internal.ui.ridgets.swt.TableRidgetLabelProvider;
import org.eclipse.riena.ui.common.ISortableByColumn;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSelectableIndexedRidget;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.SortableComparator;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRidget
extends AbstractSelectableIndexedRidget
implements ITableRidget {
    private static final Listener ERASE_LISTENER = new EraseListener();
    private final SelectionListener selectionTypeEnforcer = new SelectionTypeEnforcer();
    private final MouseListener doubleClickForwarder = new DoubleClickForwarder();
    private final ColumnSortListener sortListener = new ColumnSortListener();
    private ListenerList<IActionListener> doubleClickListeners;
    private DataBindingContext dbc;
    private Binding viewerMSB;
    private TableViewer viewer;
    private String[] columnHeaders;
    private ColumnLayoutData[] columnWidths;
    private IObservableList modelObservables;
    private IObservableList viewerObservables;
    private Class<?> rowClass;
    private String[] renderingMethods;
    private boolean isSortedAscending = true;
    private int sortedColumn = -1;
    private final Map<Integer, Boolean> sortableColumnsMap = new HashMap<Integer, Boolean>();
    private final Map<Integer, Comparator<Object>> comparatorMap = new HashMap<Integer, Comparator<Object>>();
    private final Map<Integer, IColumnFormatter> formatterMap = new HashMap<Integer, IColumnFormatter>();
    private boolean moveableColumns;

    public TableRidget() {
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TableRidget.this.applyEraseListener();
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (TableRidget.this.isOutputOnly()) {
                    TableRidget.this.disposeMultipleSelectionBinding();
                } else {
                    TableRidget.this.createMultipleSelectionBinding();
                }
            }
        });
    }

    @Override
    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, Table.class);
    }

    @Override
    protected void bindUIControl() {
        Table control = this.getUIControl();
        if (control != null) {
            this.viewer = new TableViewer(control);
            this.configureControl(control);
            if (this.viewerObservables != null) {
                this.configureViewer(this.viewer);
            }
            this.dbc = new DataBindingContext();
            IViewerObservableValue viewerSelection = ViewersObservables.observeSingleSelection((Viewer)this.viewer);
            this.dbc.bindValue((IObservableValue)viewerSelection, this.getSingleSelectionObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)new OutputAwareValidator((IMarkableRidget)this)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
            this.viewerMSB = null;
            if (!this.isOutputOnly()) {
                this.createMultipleSelectionBinding();
            }
            TableColumn[] tableColumnArray = control.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.addSelectionListener((SelectionListener)this.sortListener);
                ++n2;
            }
            control.addSelectionListener(this.selectionTypeEnforcer);
            control.addMouseListener(this.doubleClickForwarder);
        }
    }

    @Override
    protected void unbindUIControl() {
        Table control;
        super.unbindUIControl();
        if (this.dbc != null) {
            this.disposeMultipleSelectionBinding();
            this.dbc.dispose();
            this.dbc = null;
        }
        if ((control = this.getUIControl()) != null) {
            TableColumn[] tableColumnArray = control.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.removeSelectionListener((SelectionListener)this.sortListener);
                ++n2;
            }
            control.removeSelectionListener(this.selectionTypeEnforcer);
            control.removeMouseListener(this.doubleClickForwarder);
            control.removeListener(40, ERASE_LISTENER);
        }
        this.viewer = null;
    }

    @Override
    protected List<?> getRowObservables() {
        return this.viewerObservables;
    }

    public Table getUIControl() {
        return (Table)super.getUIControl();
    }

    public void addDoubleClickListener(IActionListener listener) {
        Assert.isNotNull((Object)listener, (String)"listener is null");
        if (this.doubleClickListeners == null) {
            this.doubleClickListeners = new ListenerList(IActionListener.class);
        }
        this.doubleClickListeners.add((Object)listener);
    }

    public void bindToModel(IObservableList rowObservables, Class<? extends Object> aRowClass, String[] columnPropertyNames, String[] columnHeaders) {
        if (columnHeaders != null) {
            String msg = "Mismatch between number of columnPropertyNames and columnHeaders";
            Assert.isLegal((columnPropertyNames.length == columnHeaders.length ? 1 : 0) != 0, (String)msg);
        }
        this.unbindUIControl();
        this.rowClass = aRowClass;
        this.modelObservables = rowObservables;
        this.viewerObservables = null;
        this.renderingMethods = new String[columnPropertyNames.length];
        System.arraycopy(columnPropertyNames, 0, this.renderingMethods, 0, this.renderingMethods.length);
        if (columnHeaders != null) {
            this.columnHeaders = new String[columnHeaders.length];
            System.arraycopy(columnHeaders, 0, this.columnHeaders, 0, this.columnHeaders.length);
        } else {
            this.columnHeaders = null;
        }
        this.bindUIControl();
    }

    public void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        IObservableList rowValues = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        this.bindToModel(rowValues, rowClass, columnPropertyNames, columnHeaders);
    }

    public void updateFromModel() {
        super.updateFromModel();
        if (this.modelObservables != null) {
            ArrayList copy = new ArrayList(this.modelObservables);
            this.viewerObservables = new WritableList(copy, this.rowClass);
        }
        if (this.viewer != null) {
            if (!this.isViewerConfigured()) {
                this.configureControl(this.viewer.getTable());
                this.configureViewer(this.viewer);
            } else {
                this.refreshViewer(this.viewer);
            }
        } else {
            this.refreshSelection();
        }
    }

    public IObservableList getObservableList() {
        return this.viewerObservables;
    }

    public void removeDoubleClickListener(IActionListener listener) {
        if (this.doubleClickListeners != null) {
            this.doubleClickListeners.remove((Object)listener);
        }
    }

    public void setComparator(int columnIndex, Comparator<Object> compi) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        if (compi != null) {
            this.comparatorMap.put(key, compi);
        } else {
            this.comparatorMap.remove(key);
        }
        if (columnIndex == this.sortedColumn) {
            this.applyComparator();
        }
    }

    public int getSortedColumn() {
        boolean isSorted = this.sortedColumn != -1 && this.isColumnSortable(this.sortedColumn);
        return isSorted ? this.sortedColumn : -1;
    }

    public boolean isColumnSortable(int columnIndex) {
        this.checkColumnRange(columnIndex);
        boolean result = false;
        Integer key = columnIndex;
        Boolean sortable = this.sortableColumnsMap.get(columnIndex);
        if (sortable == null || Boolean.TRUE.equals(sortable)) {
            result = this.comparatorMap.get(key) != null;
        }
        return result;
    }

    public boolean isSortedAscending() {
        return this.getSortedColumn() != -1 && this.isSortedAscending;
    }

    public void setColumnSortable(int columnIndex, boolean sortable) {
        this.checkColumnRange(columnIndex);
        Integer key = columnIndex;
        Boolean newValue = sortable;
        Boolean oldValue = this.sortableColumnsMap.put(key, newValue);
        if (oldValue == null) {
            oldValue = Boolean.TRUE;
        }
        if (!newValue.equals(oldValue)) {
            this.firePropertyChange("columnSortability", null, columnIndex);
        }
    }

    public void setColumnWidths(Object[] widths) {
        this.columnWidths = ColumnUtils.copyWidths(widths);
        Table control = this.getUIControl();
        if (control != null) {
            this.applyColumnWidths(control);
        }
    }

    public void setSortedAscending(boolean ascending) {
        if (this.isSortedAscending != ascending) {
            boolean oldSortedAscending = this.isSortedAscending;
            this.isSortedAscending = ascending;
            this.applyComparator();
            this.firePropertyChange("sortAscending", oldSortedAscending, this.isSortedAscending);
        }
    }

    public void setSortedColumn(int columnIndex) {
        if (columnIndex != -1) {
            this.checkColumnRange(columnIndex);
        }
        if (this.sortedColumn != columnIndex) {
            int oldSortedColumn = this.sortedColumn;
            this.sortedColumn = columnIndex;
            this.applyComparator();
            this.firePropertyChange("sortedColumn", oldSortedColumn, this.sortedColumn);
        }
    }

    @Override
    public int getSelectionIndex() {
        Table control = this.getUIControl();
        return control == null ? -1 : control.getSelectionIndex();
    }

    @Override
    public int[] getSelectionIndices() {
        Table control = this.getUIControl();
        return control == null ? new int[]{} : control.getSelectionIndices();
    }

    @Override
    public int indexOfOption(Object option) {
        Table control = this.getUIControl();
        if (control != null) {
            int optionCount = control.getItemCount();
            int i = 0;
            while (i < optionCount) {
                if (this.viewer.getElementAt(i).equals(option)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean hasMoveableColumns() {
        return this.moveableColumns;
    }

    public void setMoveableColumns(boolean moveableColumns) {
        if (this.moveableColumns != moveableColumns) {
            this.moveableColumns = moveableColumns;
            Table control = this.getUIControl();
            if (control != null) {
                this.applyColumnsMoveable(control);
            }
        }
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public void setColumnFormatter(int columnIndex, IColumnFormatter formatter) {
        this.checkColumnRange(columnIndex);
        if (formatter != null) {
            Assert.isLegal((boolean)(formatter instanceof ColumnFormatter), (String)"formatter must sublass ColumnFormatter");
        }
        Integer key = columnIndex;
        this.formatterMap.put(key, formatter);
    }

    private void applyColumns(Table control) {
        int expectedCols = this.renderingMethods.length;
        if (control.getColumnCount() != expectedCols) {
            TableColumn[] tableColumnArray = control.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                column.dispose();
                ++n2;
            }
            int i = 0;
            while (i < expectedCols) {
                new TableColumn(control, 0);
                ++i;
            }
            this.applyColumnWidths(control);
        }
    }

    private void applyColumnWidths(Table control) {
        ColumnUtils.applyColumnWidths(control, this.columnWidths);
    }

    private void applyColumnsMoveable(Table control) {
        TableColumn[] tableColumnArray = control.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.setMoveable(this.moveableColumns);
            ++n2;
        }
    }

    private void applyComparator() {
        if (this.viewer != null) {
            Table table = this.viewer.getTable();
            Comparator<Object> compi = null;
            if (this.sortedColumn != -1) {
                Integer key = this.sortedColumn;
                compi = this.comparatorMap.get(key);
            }
            if (compi != null) {
                TableColumn column = table.getColumn(this.sortedColumn);
                table.setSortColumn(column);
                int direction = this.isSortedAscending ? 128 : 1024;
                table.setSortDirection(direction);
                SortableComparator sortableComparator = new SortableComparator((ISortableByColumn)this, compi);
                this.viewer.setComparator((ViewerComparator)new TableComparator(sortableComparator));
            } else {
                this.viewer.setComparator(null);
                table.setSortColumn(null);
                table.setSortDirection(0);
            }
        }
    }

    private void applyEraseListener() {
        if (this.viewer != null) {
            Control control = this.viewer.getControl();
            control.removeListener(40, ERASE_LISTENER);
            if (!this.isEnabled() && MarkerSupport.isHideDisabledRidgetContent()) {
                control.addListener(40, ERASE_LISTENER);
            }
        }
    }

    private void applyTableColumnHeaders(Table control) {
        boolean headersVisible = this.columnHeaders != null;
        control.setHeaderVisible(headersVisible);
        if (headersVisible) {
            TableColumn[] columns = control.getColumns();
            int i = 0;
            while (i < columns.length) {
                String columnHeader = "";
                if (i < this.columnHeaders.length && this.columnHeaders[i] != null) {
                    columnHeader = this.columnHeaders[i];
                }
                columns[i].setText(columnHeader);
                ++i;
            }
        }
    }

    private void checkColumnRange(int columnIndex) {
        Table table = this.getUIControl();
        if (table != null) {
            int range = table.getColumnCount();
            String msg = "columnIndex out of range (0 - " + range + " ): " + columnIndex;
            Assert.isLegal((-1 < columnIndex ? 1 : 0) != 0, (String)msg);
            Assert.isLegal((columnIndex < range ? 1 : 0) != 0, (String)msg);
        }
    }

    private void createMultipleSelectionBinding() {
        if (this.viewerMSB == null && this.dbc != null && this.viewer != null) {
            StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
            IViewerObservableList viewerSelections = ViewersObservables.observeMultiSelection((Viewer)this.viewer);
            this.viewerMSB = this.dbc.bindList((IObservableList)viewerSelections, this.getMultiSelectionObservable(), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));
            this.viewer.setSelection((ISelection)currentSelection);
        }
    }

    private void configureControl(Table control) {
        if (this.renderingMethods != null) {
            this.applyColumns(control);
        }
        this.applyColumnsMoveable(control);
        this.applyTableColumnHeaders(control);
        this.applyComparator();
        this.applyEraseListener();
    }

    private void configureViewer(TableViewer viewer) {
        ObservableListContentProvider viewerCP = new ObservableListContentProvider();
        IObservableMap[] attrMap = AbstractSWTWidgetRidget.isBean(this.rowClass) ? BeansObservables.observeMaps((IObservableSet)viewerCP.getKnownElements(), this.rowClass, (String[])this.renderingMethods) : PojoObservables.observeMaps((IObservableSet)viewerCP.getKnownElements(), this.rowClass, (String[])this.renderingMethods);
        IColumnFormatter[] formatters = this.getColumnFormatters(attrMap.length);
        viewer.setLabelProvider((IBaseLabelProvider)new TableRidgetLabelProvider(attrMap, formatters));
        viewer.setContentProvider((IContentProvider)viewerCP);
        viewer.setInput((Object)this.viewerObservables);
    }

    private void disposeMultipleSelectionBinding() {
        if (this.viewerMSB != null) {
            this.viewerMSB.dispose();
            this.dbc.removeBinding(this.viewerMSB);
            this.viewerMSB = null;
        }
    }

    private IColumnFormatter[] getColumnFormatters(int numColumns) {
        Assert.isLegal((numColumns >= 0 ? 1 : 0) != 0);
        IColumnFormatter[] result = new IColumnFormatter[numColumns];
        int i = 0;
        while (i < numColumns) {
            IColumnFormatter columnFormatter = this.formatterMap.get(i);
            if (columnFormatter != null) {
                result[i] = columnFormatter;
            }
            ++i;
        }
        return result;
    }

    private boolean isViewerConfigured() {
        return this.viewer.getLabelProvider() instanceof TableRidgetLabelProvider;
    }

    private void refreshViewer(TableViewer viewer) {
        viewer.getControl().setRedraw(false);
        StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
        try {
            TableRidgetLabelProvider labelProvider = (TableRidgetLabelProvider)viewer.getLabelProvider();
            IColumnFormatter[] formatters = this.getColumnFormatters(labelProvider.getColumnCount());
            labelProvider.setFormatters(formatters);
            viewer.setInput((Object)this.viewerObservables);
        }
        finally {
            viewer.setSelection((ISelection)currentSelection);
            viewer.getControl().setRedraw(true);
        }
    }

    private final class ColumnSortListener
    extends SelectionAdapter {
        private ColumnSortListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.widget;
            int columnIndex = column.getParent().indexOf(column);
            int direction = column.getParent().getSortDirection();
            if (columnIndex == TableRidget.this.sortedColumn) {
                if (direction == 128) {
                    TableRidget.this.setSortedAscending(false);
                } else if (direction == 1024) {
                    TableRidget.this.setSortedColumn(-1);
                }
            } else if (TableRidget.this.isColumnSortable(columnIndex)) {
                TableRidget.this.setSortedColumn(columnIndex);
                if (direction == 0) {
                    TableRidget.this.setSortedAscending(true);
                }
            }
            column.getParent().showSelection();
        }
    }

    private final class DoubleClickForwarder
    extends MouseAdapter {
        private DoubleClickForwarder() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (TableRidget.this.doubleClickListeners != null) {
                IActionListener[] iActionListenerArray = (IActionListener[])TableRidget.this.doubleClickListeners.getListeners();
                int n = iActionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IActionListener listener = iActionListenerArray[n2];
                    listener.callback();
                    ++n2;
                }
            }
        }
    }

    private static final class EraseListener
    implements Listener {
        private EraseListener() {
        }

        public void handleEvent(Event event) {
            event.detail &= 0xFFFFFFEF;
        }
    }

    private final class SelectionTypeEnforcer
    extends SelectionAdapter {
        private SelectionTypeEnforcer() {
        }

        public void widgetSelected(SelectionEvent e) {
            Table control;
            if (TableRidget.this.isOutputOnly()) {
                TableRidget.this.viewer.setSelection((ISelection)new StructuredSelection(TableRidget.this.getSelection()));
            } else if (ISelectableRidget.SelectionType.SINGLE.equals((Object)TableRidget.this.getSelectionType()) && (control = (Table)e.widget).getSelectionCount() > 1) {
                e.doit = false;
                control.setSelection(control.getSelectionIndex());
                Event event = new Event();
                event.type = 13;
                event.doit = true;
                control.notifyListeners(13, event);
            }
        }
    }
}

