/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComboRidget
extends AbstractSWTRidget
implements IComboRidget {
    private final IObservableList rowObservables = new WritableList();
    private final IObservableValue selectionObservable = new WritableValue();
    private final SelectionBindingValidator selectionValidator;
    private final IValueChangeListener valueChangeNotifier;
    private ListenerList<ISelectionListener> selectionListeners;
    private Object emptySelection;
    private IObservableList optionValues;
    private Class<? extends Object> rowClass = null;
    private IObservableValue selectionValue;
    private String renderingMethod;
    private IConverter objToStrConverter = new ObjectToStringConverter();
    private IConverter strToObjConverter = new StringToObjectConverter();
    private List<String> items;
    private Binding listBindingExternal;
    private Binding selectionBindingInternal;
    private Binding selectionBindingExternal;

    public AbstractComboRidget() {
        this.selectionValidator = new SelectionBindingValidator();
        this.valueChangeNotifier = new ValueChangeNotifier();
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                AbstractComboRidget.this.applyEnabled();
            }
        });
    }

    @Override
    protected void bindUIControl() {
        if (this.optionValues != null) {
            DataBindingContext dbc = new DataBindingContext();
            if (this.getUIControl() != null) {
                this.applyEnabled();
            }
            this.listBindingExternal = dbc.bindList(this.rowObservables, this.optionValues, new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST), new UpdateListStrategy(UpdateListStrategy.POLICY_ON_REQUEST));
            this.selectionBindingExternal = dbc.bindValue(this.selectionObservable, this.selectionValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)this.selectionValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
            this.selectionObservable.removeValueChangeListener(this.valueChangeNotifier);
            this.selectionObservable.addValueChangeListener(this.valueChangeNotifier);
        }
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        this.disposeBinding(this.listBindingExternal);
        this.listBindingExternal = null;
        this.disposeBinding(this.selectionBindingInternal);
        this.selectionBindingInternal = null;
        this.disposeBinding(this.selectionBindingExternal);
        this.selectionBindingExternal = null;
    }

    public void addSelectionListener(ISelectionListener selectionListener) {
        Assert.isNotNull((Object)selectionListener, (String)"selectionListener is null");
        if (this.selectionListeners == null) {
            this.selectionListeners = new ListenerList(ISelectionListener.class);
            this.addPropertyChangeListener("selection", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    AbstractComboRidget.this.notifySelectionListeners(evt.getOldValue(), evt.getNewValue());
                }
            });
        }
        this.selectionListeners.add((Object)selectionListener);
    }

    public void removeSelectionListener(ISelectionListener selectionListener) {
        if (this.selectionListeners != null) {
            this.selectionListeners.remove((Object)selectionListener);
        }
    }

    public void bindToModel(IObservableList optionValues, Class<? extends Object> rowClass, String renderingMethod, IObservableValue selectionValue) {
        this.unbindUIControl();
        this.optionValues = optionValues;
        this.rowClass = rowClass;
        this.renderingMethod = renderingMethod;
        this.selectionValue = selectionValue;
        this.bindUIControl();
    }

    public void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String renderingMethod, Object selectionHolder, String selectionPropertyName) {
        IObservableList listObservableValue = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        IObservableValue selectionObservableValue = PojoObservables.observeValue((Object)selectionHolder, (String)selectionPropertyName);
        this.bindToModel(listObservableValue, rowClass, renderingMethod, selectionObservableValue);
    }

    public Object getEmptySelectionItem() {
        return this.emptySelection;
    }

    public IObservableList getObservableList() {
        return this.rowObservables;
    }

    public Object getSelection() {
        Object selection = this.selectionObservable.getValue();
        return selection == this.emptySelection ? null : selection;
    }

    public int getSelectionIndex() {
        int result = -1;
        Object selection = this.selectionObservable.getValue();
        if (this.emptySelection != selection) {
            result = this.rowObservables.indexOf(selection);
        }
        return result;
    }

    public boolean isAddable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return this.hasInput();
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && !this.isOutputOnly();
    }

    public boolean isListMutable() {
        throw new UnsupportedOperationException();
    }

    public boolean isReadonly() {
        throw new UnsupportedOperationException();
    }

    public void setAddable(boolean addable) {
        throw new UnsupportedOperationException();
    }

    public void setEmptySelectionItem(Object emptySelection) {
        this.emptySelection = emptySelection;
    }

    public void setListMutable(boolean mutable) {
        throw new UnsupportedOperationException();
    }

    public void setReadonly(boolean readonly) {
        throw new UnsupportedOperationException();
    }

    public void setSelection(Object newSelection) {
        this.assertIsBoundToModel();
        Object oldSelection = this.selectionObservable.getValue();
        if (oldSelection != newSelection) {
            if (newSelection == null || !this.rowObservables.contains(newSelection)) {
                if (this.getUIControl() != null) {
                    this.clearUIControlListSelection();
                }
                this.selectionObservable.setValue(null);
            } else {
                this.selectionObservable.setValue(newSelection);
            }
        }
    }

    public void setSelection(int index) {
        if (index == -1) {
            this.setSelection(null);
        } else {
            Object newSelection = this.rowObservables.get(index);
            this.setSelection(newSelection);
        }
    }

    public void setModelToUIControlConverter(IConverter converter) {
        this.objToStrConverter = converter != null ? converter : new ObjectToStringConverter();
    }

    public void setUIControlToModelConverter(IConverter converter) {
        this.strToObjConverter = converter != null ? converter : new StringToObjectConverter();
    }

    public void updateFromModel() {
        this.assertIsBoundToModel();
        super.updateFromModel();
        this.selectionValidator.enableBinding(false);
        try {
            this.listBindingExternal.updateModelToTarget();
            this.items = new ArrayList<String>();
            this.updateValueToItem();
        }
        finally {
            this.selectionValidator.enableBinding(true);
        }
        this.selectionBindingExternal.updateModelToTarget();
        if (this.selectionBindingInternal != null) {
            this.selectionBindingInternal.updateModelToTarget();
        }
    }

    protected abstract void clearUIControlListSelection();

    protected abstract String[] getUIControlItems();

    protected abstract IObservableList getUIControlItemsObservable();

    protected abstract ISWTObservableValue getUIControlSelectionObservable();

    protected abstract void selectInUIControl(int var1);

    protected abstract int indexOfInUIControl(String var1);

    protected abstract void removeAllFromUIControl();

    protected abstract void setItemsToControl(String[] var1);

    private void applyEnabled() {
        if (super.isEnabled()) {
            this.bindControlToSelectionAndUpdate();
        } else {
            this.unbindControlFromSelectionAndClear();
        }
    }

    private void assertIsBoundToModel() {
        if (this.optionValues == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    private void bindControlToSelectionAndUpdate() {
        if (this.getUIControl() != null) {
            this.updateValueToItem();
            ISWTObservableValue controlSelection = this.getUIControlSelectionObservable();
            DataBindingContext dbc = new DataBindingContext();
            this.selectionBindingInternal = dbc.bindValue((IObservableValue)controlSelection, this.selectionObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(this.strToObjConverter).setAfterGetValidator((IValidator)this.selectionValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(this.objToStrConverter));
            this.selectionBindingInternal.updateModelToTarget();
        }
    }

    private void disposeBinding(Binding binding) {
        if (binding != null && !binding.isDisposed()) {
            binding.dispose();
        }
    }

    private String getItemFromValue(Object value) {
        Object valueObject = value;
        if (value != null && this.renderingMethod != null) {
            valueObject = ReflectionUtils.invoke((Object)value, (String)this.renderingMethod, null);
        }
        if (valueObject == null || valueObject.toString() == null) {
            throw new NullPointerException("The item value for a model element is null");
        }
        return valueObject.toString();
    }

    private Object getValueFromItem(String item) {
        String[] uiItems = this.getUIControlItems();
        int i = 0;
        while (i < uiItems.length) {
            if (uiItems[i].equals(item)) {
                return this.rowObservables.get(i);
            }
            ++i;
        }
        if (this.rowClass == String.class) {
            return "";
        }
        return null;
    }

    private boolean hasInput() {
        Object selection = this.selectionObservable.getValue();
        return selection != null && selection != this.emptySelection;
    }

    private void notifySelectionListeners(Object oldValue, Object newValue) {
        if (this.selectionListeners != null) {
            ArrayList<Object> oldSelectionList = new ArrayList<Object>();
            if (oldValue != null) {
                oldSelectionList.add(oldValue);
            }
            ArrayList<Object> newSelectionList = new ArrayList<Object>();
            if (newValue != null) {
                newSelectionList.add(newValue);
            }
            SelectionEvent event = new SelectionEvent((IRidget)this, oldSelectionList, newSelectionList);
            ISelectionListener[] iSelectionListenerArray = (ISelectionListener[])this.selectionListeners.getListeners();
            int n = iSelectionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionListener listener = iSelectionListenerArray[n2];
                listener.ridgetSelected(event);
                ++n2;
            }
        }
    }

    private void unbindControlFromSelectionAndClear() {
        if (this.getUIControl() != null && !super.isEnabled()) {
            this.disposeBinding(this.selectionBindingInternal);
            this.selectionBindingInternal = null;
            if (MarkerSupport.isHideDisabledRidgetContent()) {
                this.removeAllFromUIControl();
            }
        }
    }

    private void updateValueToItem() {
        if (this.items != null) {
            this.items.clear();
            try {
                for (Object value : this.optionValues) {
                    String item = (String)this.objToStrConverter.convert(value);
                    this.items.add(item);
                }
            }
            finally {
                if (this.getUIControl() != null) {
                    String[] arrItems = this.items.toArray(new String[this.items.size()]);
                    this.setItemsToControl(arrItems);
                }
            }
        }
    }

    private final class ObjectToStringConverter
    extends Converter {
        public ObjectToStringConverter() {
            super(Object.class, String.class);
        }

        public Object convert(Object fromObject) {
            return AbstractComboRidget.this.getItemFromValue(fromObject);
        }
    }

    private final class SelectionBindingValidator
    implements IValidator {
        private boolean isEnabled = true;

        private SelectionBindingValidator() {
        }

        public IStatus validate(Object value) {
            IStatus result = Status.OK_STATUS;
            if (!this.isEnabled) {
                result = Status.CANCEL_STATUS;
            }
            return result;
        }

        void enableBinding(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }
    }

    private final class StringToObjectConverter
    extends Converter {
        public StringToObjectConverter() {
            super(String.class, Object.class);
        }

        public Object convert(Object fromObject) {
            return AbstractComboRidget.this.getValueFromItem((String)fromObject);
        }
    }

    private final class ValueChangeNotifier
    implements IValueChangeListener {
        private ValueChangeNotifier() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            Object oldValue = event.diff.getOldValue();
            Object newValue = event.diff.getNewValue();
            AbstractComboRidget.this.firePropertyChange("selection", oldValue, newValue);
            AbstractComboRidget.this.disableMandatoryMarkers(AbstractComboRidget.this.hasInput());
        }
    }
}

