/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.swt.AbstractMasterDetailsComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMasterDetailsRidget
extends AbstractCompositeRidget
implements IMasterDetailsRidget {
    private IObservableList rowObservables;
    private IMasterDetailsDelegate delegate;
    private DataBindingContext dbc;
    private boolean isDirectWriting;
    private boolean applyRequiresNoErrors;
    private boolean applyRequiresNoMandatories;
    private boolean detailsEnabled;
    private boolean ignoreChanges;
    private Object editable;
    private IRidgetContainer detailRidgets;

    public AbstractMasterDetailsRidget() {
        this.addPropertyChangeListener(null, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (AbstractMasterDetailsRidget.this.isDirectWriting || AbstractMasterDetailsRidget.this.ignoreChanges || AbstractMasterDetailsRidget.this.delegate == null || AbstractMasterDetailsRidget.this.editable == null || !AbstractMasterDetailsRidget.this.applyRequiresNoErrors && !AbstractMasterDetailsRidget.this.applyRequiresNoMandatories && "marker".equals(propertyName) || "enabled".equals(propertyName) || "text".equals(propertyName) || "output".equals(propertyName) || "marker".equals(propertyName) && AbstractMasterDetailsRidget.this.getApplyButtonRidget() == evt.getSource()) {
                    return;
                }
                AbstractMasterDetailsRidget.this.updateApplyButton();
            }
        });
    }

    public final void bindToModel(IObservableList rowObservables, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        this.rowObservables = rowObservables;
        this.bindTableToModel(rowObservables, rowClass, columnPropertyNames, columnHeaders);
    }

    public final void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] headerNames) {
        IObservableList rowObservableList = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        this.bindToModel(rowObservableList, rowClass, columnPropertyNames, headerNames);
    }

    public void configureRidgets() {
        this.configureTableRidget();
        if (this.hasNewButton()) {
            this.getNewButtonRidget().addListener(new IActionListener(){

                public void callback() {
                    if (AbstractMasterDetailsRidget.this.canAdd()) {
                        AbstractMasterDetailsRidget.this.handleAdd();
                    }
                }
            });
        }
        if (this.hasRemoveButton()) {
            this.getRemoveButtonRidget().addListener(new IActionListener(){

                public void callback() {
                    if (AbstractMasterDetailsRidget.this.canRemove()) {
                        AbstractMasterDetailsRidget.this.handleRemove();
                    }
                }
            });
        }
        this.getApplyButtonRidget().addListener(new IActionListener(){

            public void callback() {
                if (AbstractMasterDetailsRidget.this.canApply()) {
                    AbstractMasterDetailsRidget.this.handleApply();
                }
            }
        });
        this.detailRidgets = new DetailRidgetContainer();
        this.setEnabled(false, false);
        final IObservableValue viewerSelection = this.getSelectionObservable();
        Assert.isLegal((this.dbc == null ? 1 : 0) != 0);
        if (this.hasRemoveButton()) {
            this.dbc = new DataBindingContext();
            this.bindEnablementToValue(this.dbc, (IRidget)this.getRemoveButtonRidget(), (IObservableValue)new ComputedValue(Boolean.TYPE){

                protected Object calculate() {
                    return viewerSelection.getValue() != null;
                }
            });
        }
        for (IRidget ridget : this.detailRidgets.getRidgets()) {
            ridget.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String propertyName = evt.getPropertyName();
                    if (!AbstractMasterDetailsRidget.this.isDirectWriting || AbstractMasterDetailsRidget.this.ignoreChanges || AbstractMasterDetailsRidget.this.delegate == null || AbstractMasterDetailsRidget.this.editable == null || !AbstractMasterDetailsRidget.this.applyRequiresNoErrors && !AbstractMasterDetailsRidget.this.applyRequiresNoMandatories && "marker".equals(propertyName) || "enabled".equals(propertyName) || "text".equals(propertyName) || "output".equals(propertyName)) {
                        return;
                    }
                    if (AbstractMasterDetailsRidget.this.canApplyDirectly()) {
                        AbstractMasterDetailsRidget.this.delegate.copyBean(AbstractMasterDetailsRidget.this.delegate.getWorkingCopy(), AbstractMasterDetailsRidget.this.editable);
                        AbstractMasterDetailsRidget.this.getTableRidget().updateFromModel();
                        AbstractMasterDetailsRidget.this.setTableSelection(AbstractMasterDetailsRidget.this.editable);
                    }
                }
            });
        }
    }

    public final IMasterDetailsDelegate getDelegate() {
        return this.delegate;
    }

    public final Object getSelection() {
        return this.getSelectionObservable().getValue();
    }

    public AbstractMasterDetailsComposite getUIControl() {
        return (AbstractMasterDetailsComposite)super.getUIControl();
    }

    public boolean isApplyRequiresNoErrors() {
        return this.applyRequiresNoErrors;
    }

    public boolean isApplyRequiresNoMandatories() {
        return this.applyRequiresNoMandatories;
    }

    public boolean isDirectWriting() {
        return this.isDirectWriting;
    }

    public void setApplyRequiresNoErrors(boolean requiresNoErrors) {
        if (this.applyRequiresNoErrors != requiresNoErrors) {
            this.applyRequiresNoErrors = requiresNoErrors;
            this.updateApplyButton();
        }
    }

    public void setApplyRequiresNoMandatories(boolean requiresNoMandatories) {
        if (this.applyRequiresNoMandatories != requiresNoMandatories) {
            this.applyRequiresNoMandatories = requiresNoMandatories;
            this.updateApplyButton();
        }
    }

    public void setColumnWidths(Object[] widths) {
        ((ITableRidget)this.getTableRidget()).setColumnWidths(widths);
    }

    public final void setDelegate(IMasterDetailsDelegate delegate) {
        Assert.isLegal((this.delegate == null ? 1 : 0) != 0, (String)"setDelegate can only be called once");
        Assert.isLegal((delegate != null ? 1 : 0) != 0, (String)"delegate cannot be null");
        this.delegate = delegate;
        delegate.configureRidgets(this.detailRidgets);
    }

    public void setDirectWriting(boolean directWriting) {
        if (directWriting != this.isDirectWriting) {
            this.isDirectWriting = directWriting;
            this.getApplyButtonRidget().setVisible(!directWriting);
        }
    }

    public void setSelection(Object newSelection) {
        this.setTableSelection(newSelection);
        this.handleSelectionChange(newSelection);
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            this.revealTableSelection();
        }
    }

    public void suggestNewEntry(Object entry) {
        this.ignoreChanges = true;
        try {
            this.editable = entry;
            this.delegate.prepareItemSelected(this.editable);
            this.setEnabled(true, true);
            this.updateDetails(this.editable);
            this.ignoreChanges = true;
            this.delegate.itemSelected(this.editable);
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    public final void updateApplyButton() {
        if (this.applyRequiresNoErrors || this.applyRequiresNoMandatories) {
            boolean noErrors;
            boolean bl = this.applyRequiresNoErrors ? !this.hasErrors() : (noErrors = true);
            boolean noMandatories = this.applyRequiresNoMandatories ? !this.hasMandatories() : true;
            boolean isEnabled = noErrors && noMandatories && this.areDetailsChanged();
            this.getApplyButtonRidget().setEnabled(isEnabled);
        } else {
            this.getApplyButtonRidget().setEnabled(this.areDetailsChanged());
        }
    }

    public void updateFromModel() {
        this.checkDelegate();
        super.updateFromModel();
        IRidget tableRidget = this.getTableRidget();
        if (tableRidget != null) {
            tableRidget.updateFromModel();
        }
    }

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, AbstractMasterDetailsComposite.class);
    }

    protected abstract void bindTableToModel(IObservableList var1, Class<? extends Object> var2, String[] var3, String[] var4);

    protected abstract void configureTableRidget();

    protected abstract void clearTableSelection();

    protected abstract Object getTableSelection();

    protected abstract IObservableValue getSelectionObservable();

    protected abstract void revealTableSelection();

    protected abstract void setTableSelection(Object var1);

    protected final boolean areDetailsChanged() {
        if (this.detailsEnabled) {
            return this.editable != null && this.delegate.isChanged(this.editable, this.delegate.getWorkingCopy());
        }
        return false;
    }

    protected void handleSelectionChange(Object newSelection) {
        this.ignoreChanges = true;
        try {
            this.delegate.prepareItemSelected(newSelection);
            if (newSelection != null) {
                this.editable = newSelection;
                this.setEnabled(false, true);
                this.updateDetails(this.editable);
            } else {
                this.clearSelection();
                this.setEnabled(false, false);
            }
            this.ignoreChanges = true;
            this.delegate.itemSelected(newSelection);
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    protected boolean isUIControlVisible() {
        return this.getUIControl().isVisible();
    }

    protected final void updateEnabled() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            if (!this.isEnabled()) {
                this.clearSelection();
                this.clearTableSelection();
                Collection ridgets = this.getRidgets();
                for (IRidget ridget : ridgets) {
                    ridget.setEnabled(false);
                }
            } else {
                if (this.getTableRidget() != null) {
                    this.getTableRidget().setEnabled(true);
                }
                if (this.getNewButtonRidget() != null) {
                    this.getNewButtonRidget().setEnabled(true);
                }
            }
            control.setEnabled(this.isEnabled());
        }
    }

    protected final void updateToolTipText() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.setToolTipText(this.getToolTipText());
        }
    }

    protected final void updateVisible() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.setVisible(!this.isMarkedHidden());
        }
    }

    private void assertIsBoundToModel() {
        if (this.rowObservables == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    private void bindEnablementToValue(DataBindingContext dbc, IRidget ridget, IObservableValue value) {
        Assert.isNotNull((Object)ridget);
        Assert.isNotNull((Object)value);
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }

    private boolean canAdd() {
        boolean result = true;
        if (this.areDetailsChanged()) {
            result = this.getUIControl().confirmDiscardChanges();
        }
        return result;
    }

    private boolean canApply() {
        String reason = this.delegate.isValid(this.detailRidgets);
        if (reason != null) {
            this.getUIControl().warnApplyFailed(reason);
        }
        return reason == null;
    }

    private boolean canApplyDirectly() {
        boolean noMandatories;
        boolean noErrors;
        boolean bl = this.applyRequiresNoErrors ? !this.hasErrors() : (noErrors = true);
        boolean bl2 = this.applyRequiresNoMandatories ? !this.hasMandatories() : (noMandatories = true);
        return noErrors && noMandatories && this.delegate.isValid(this.detailRidgets) == null;
    }

    private boolean canRemove() {
        Object selection = this.getSelection();
        Assert.isNotNull((Object)selection);
        return this.getUIControl().confirmRemove(selection);
    }

    private void checkDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("no delegate: call setDelegate(...)");
        }
    }

    private void clearSelection() {
        this.updateDetails(this.delegate.createWorkingCopy());
        this.editable = null;
    }

    private Control getDetailsControl() {
        Composite result = null;
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            result = control.getDetails();
        }
        return result;
    }

    private IRidget getTableRidget() {
        return this.getRidget("mdTable");
    }

    private IActionRidget getNewButtonRidget() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "mdNewButton");
    }

    private IActionRidget getRemoveButtonRidget() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "mdRemoveButton");
    }

    private IActionRidget getApplyButtonRidget() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "mdApplyButton");
    }

    private boolean hasErrors() {
        for (IRidget ridget : this.detailRidgets.getRidgets()) {
            IMarkableRidget markableRidget;
            if (!(ridget instanceof IMarkableRidget) || (markableRidget = (IMarkableRidget)ridget).getMarkersOfType(ErrorMarker.class).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean hasMandatories() {
        for (IRidget ridget : this.detailRidgets.getRidgets()) {
            if (!(ridget instanceof IMarkableRidget)) continue;
            IMarkableRidget markableRidget = (IMarkableRidget)ridget;
            for (MandatoryMarker marker : markableRidget.getMarkersOfType(MandatoryMarker.class)) {
                if (marker.isDisabled()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNewButton() {
        return this.getNewButtonRidget() != null;
    }

    private boolean hasRemoveButton() {
        return this.getRemoveButtonRidget() != null;
    }

    private void setEnabled(boolean applyEnabled, boolean detailsEnabled) {
        this.ignoreChanges = true;
        try {
            this.getApplyButtonRidget().setEnabled(applyEnabled);
            this.detailsEnabled = detailsEnabled;
            for (IRidget ridget : this.detailRidgets.getRidgets()) {
                ridget.setEnabled(detailsEnabled);
            }
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    private void setFocusToDetails() {
        final Control focusable = this.getDetailsControl();
        if (focusable != null) {
            focusable.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!focusable.isDisposed()) {
                        AbstractMasterDetailsRidget.this.clearTableSelection();
                        focusable.setFocus();
                    }
                }
            });
        }
    }

    private void setFocusToTable() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            final Control table = control.getTable();
            table.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!table.isDisposed()) {
                        table.setFocus();
                        AbstractMasterDetailsRidget.this.clearTableSelection();
                    }
                }
            });
        }
    }

    private void traceEvent(PropertyChangeEvent evt) {
        String className = evt.getSource().getClass().getSimpleName();
        System.out.println(String.format("prop: %s %s", evt.getPropertyName(), className));
    }

    private void updateDetails(Object bean) {
        Assert.isNotNull((Object)bean);
        this.ignoreChanges = true;
        try {
            this.delegate.copyBean(bean, this.delegate.getWorkingCopy());
            this.delegate.updateDetails(this.detailRidgets);
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    public void handleAdd() {
        if (!this.isDirectWriting) {
            this.editable = this.delegate.createWorkingCopy();
            this.delegate.itemCreated(this.editable);
            this.setEnabled(false, true);
            this.updateDetails(this.editable);
            this.clearTableSelection();
            this.getUIControl().getDetails().setFocus();
        } else {
            this.editable = this.delegate.createWorkingCopy();
            this.delegate.itemCreated(this.editable);
            this.rowObservables.add(this.editable);
            this.getTableRidget().updateFromModel();
            this.setSelection(this.editable);
            this.setEnabled(false, true);
            this.updateDetails(this.editable);
            this.getUIControl().getDetails().setFocus();
        }
    }

    public void handleRemove() {
        this.assertIsBoundToModel();
        Object selection = this.getSelection();
        Assert.isNotNull((Object)selection);
        this.rowObservables.remove(selection);
        this.clearSelection();
        this.clearTableSelection();
        this.getTableRidget().updateFromModel();
        this.setEnabled(false, false);
        this.delegate.itemRemoved(selection);
    }

    public void handleApply() {
        this.assertIsBoundToModel();
        Assert.isNotNull((Object)this.editable);
        this.delegate.copyBean(this.delegate.getWorkingCopy(), this.editable);
        this.delegate.itemApplied(this.editable);
        if (!this.rowObservables.contains(this.editable)) {
            this.rowObservables.add(this.editable);
            this.getTableRidget().updateFromModel();
            this.setTableSelection(this.editable);
            this.revealTableSelection();
        } else {
            this.getTableRidget().updateFromModel();
        }
        if (this.hasNewButton() && !this.isDirectWriting) {
            this.handleAdd();
            this.setFocusToDetails();
        } else {
            this.setEnabled(false, false);
            this.setFocusToTable();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DetailRidgetContainer
    implements IRidgetContainer {
        private final List<IRidget> detailRidgets = this.getDetailRidgets();

        public void addRidget(String id, IRidget ridget) {
            throw new UnsupportedOperationException("not supported");
        }

        public void configureRidgets() {
            throw new UnsupportedOperationException("not supported");
        }

        public IRidget getRidget(String id) {
            return AbstractMasterDetailsRidget.this.getRidget(id);
        }

        public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
            return (R)AbstractMasterDetailsRidget.this.getRidget(ridgetClazz, id);
        }

        public Collection<? extends IRidget> getRidgets() {
            return this.detailRidgets;
        }

        private List<IRidget> getDetailRidgets() {
            ArrayList<IRidget> result = new ArrayList<IRidget>(AbstractMasterDetailsRidget.this.getRidgets());
            result.remove(AbstractMasterDetailsRidget.this.getNewButtonRidget());
            result.remove(AbstractMasterDetailsRidget.this.getRemoveButtonRidget());
            result.remove(AbstractMasterDetailsRidget.this.getApplyButtonRidget());
            result.remove(AbstractMasterDetailsRidget.this.getTableRidget());
            return result;
        }
    }
}

