/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionObserver;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IconManagerProvider;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractValueRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractToggleButtonRidget
extends AbstractValueRidget
implements IToggleButtonRidget {
    private static final String EMPTY_STRING = "";
    private final ActionObserver actionObserver = new ActionObserver((IRidget)this);
    private Binding controlBinding;
    private String text;
    private String iconID;
    private boolean selected;
    private boolean textAlreadyInitialized = false;
    private boolean useRidgetIcon = false;

    public AbstractToggleButtonRidget() {
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean isEnabled = (Boolean)evt.getNewValue();
                AbstractToggleButtonRidget.this.updateSelection(isEnabled);
            }
        });
    }

    protected void bindUIControl() {
        DataBindingContext context = this.getValueBindingSupport().getContext();
        if (this.getUIControl() != null) {
            this.controlBinding = context.bindValue((IObservableValue)this.getUIControlSelectionObservable(), this.getRidgetObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setBeforeSetValidator((IValidator)new CancelControlUpdateWhenDisabled()));
            this.initText();
            this.updateUIText();
            this.updateSelection(this.isEnabled());
            this.updateUIIcon();
        }
    }

    protected abstract ISWTObservableValue getUIControlSelectionObservable();

    protected void unbindUIControl() {
        super.unbindUIControl();
        if (this.controlBinding != null) {
            this.controlBinding.dispose();
            this.controlBinding = null;
        }
    }

    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)"selected");
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (!this.getMarkersOfType(OutputMarker.class).isEmpty()) {
            this.unbindUIControl();
            this.setUIControlSelection(this.selected);
            this.bindUIControl();
            return;
        }
        if (this.selected != selected) {
            boolean oldValue = this.selected;
            this.selected = selected;
            this.actionObserver.widgetSelected(null);
            this.firePropertyChange("selected", oldValue, selected);
        }
    }

    public void addListener(IActionListener listener) {
        this.actionObserver.addListener(listener);
    }

    public void addListener(Object target, String action) {
        IActionListener listener = EventHandler.create(IActionListener.class, target, action);
        this.actionObserver.addListener(listener);
    }

    public void removeListener(IActionListener listener) {
        this.actionObserver.removeListener(listener);
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String newText) {
        String oldText = this.text;
        this.text = newText;
        this.updateUIText();
        this.firePropertyChange("text", oldText, this.text);
    }

    public String getIcon() {
        IIconManager manager = IconManagerProvider.getInstance().getIconManager();
        String icon = manager.getName(this.iconID);
        return icon;
    }

    public void setIcon(String icon) {
        this.setIcon(icon, IconSize.NONE);
    }

    public void setIcon(String icon, IconSize size) {
        boolean oldUseRidgetIcon = this.useRidgetIcon;
        this.useRidgetIcon = true;
        String oldIconID = this.iconID;
        IIconManager manager = IconManagerProvider.getInstance().getIconManager();
        this.iconID = manager.getIconID(icon, size);
        if (this.hasChanged(oldIconID, this.iconID) || !oldUseRidgetIcon) {
            this.updateUIIcon();
        }
    }

    protected abstract void setUIControlSelection(boolean var1);

    private void initText() {
        if (this.text == null && !this.textAlreadyInitialized && this.getUIControl() != null && !this.getUIControl().isDisposed()) {
            this.text = this.getUIControlText();
            if (this.text == null) {
                this.text = EMPTY_STRING;
            }
            this.textAlreadyInitialized = true;
        }
    }

    protected abstract String getUIControlText();

    private void updateSelection(boolean isRidgetEnabled) {
        if (this.getUIControl() != null && MarkerSupport.isHideDisabledRidgetContent()) {
            if (!isRidgetEnabled) {
                this.setUIControlSelection(false);
            } else {
                this.setUIControlSelection(this.isSelected());
            }
        }
    }

    private void updateUIText() {
        if (this.getUIControl() != null) {
            this.setUIControlText(this.text);
        }
    }

    protected abstract void setUIControlText(String var1);

    private void updateUIIcon() {
        if (this.getUIControl() != null) {
            Image image = null;
            if (this.iconID != null) {
                image = this.getManagedImage(this.iconID);
            }
            if (image != null || this.useRidgetIcon) {
                this.setUIControlImage(image);
            }
        }
    }

    protected abstract void setUIControlImage(Image var1);

    public void fireAction() {
        this.actionObserver.widgetSelected(null);
        this.setSelected(!this.isSelected());
    }

    private final class CancelControlUpdateWhenDisabled
    implements IValidator {
        private CancelControlUpdateWhenDisabled() {
        }

        public IStatus validate(Object value) {
            boolean cancel = MarkerSupport.isHideDisabledRidgetContent() && !AbstractToggleButtonRidget.this.isEnabled();
            return cancel ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }
}

