/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.storage.file;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.ComponentStorage;
import org.eclipse.equinox.internal.ds.Messages;
import org.eclipse.equinox.internal.ds.model.ServiceComponent;
import org.eclipse.equinox.internal.ds.storage.file.DBObject;
import org.eclipse.equinox.internal.util.io.ExternalizableDictionary;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class FileStorage
extends ComponentStorage {
    public static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    private static String CUSTOM_DB_NAME = "SCR";
    private File file;
    private ExternalizableDictionary data = new ExternalizableDictionary();
    private StringBuffer pathBuffer = new StringBuffer();
    private String separator;
    private boolean isDirty = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileStorage(BundleContext bc) {
        this.separator = bc.getProperty("path.separator");
        this.file = bc.getDataFile(CUSTOM_DB_NAME);
        FileInputStream fis = null;
        try {
            if (this.file.exists()) {
                fis = new FileInputStream(this.file);
                this.data.readObject(new BufferedInputStream(fis));
            }
        }
        catch (IOException e) {
            Activator.log(null, 1, NLS.bind((String)Messages.ERROR_LOADING_DATA_FILE, (Object)this.file.getAbsolutePath()), e);
            if (fis == null) return;
            try {
                fis.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
        catch (Exception e) {
            try {
                Activator.log(null, 1, NLS.bind((String)Messages.ERROR_LOADING_DATA_FILE, (Object)this.file.getAbsolutePath()), e);
                if (fis == null) return;
            }
            catch (Throwable throwable) {
                if (fis == null) throw throwable;
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fis.close();
                return;
            }
            catch (Exception exception) {}
            return;
        }
        if (fis == null) return;
        try {
            fis.close();
            return;
        }
        catch (Exception exception) {}
    }

    public Vector loadComponentDefinitions(Bundle bundle, String dsHeader) {
        try {
            Vector components = null;
            if (!Activator.DBSTORE) {
                return this.parseXMLDeclaration(bundle, dsHeader);
            }
            long lastModified = !Activator.getBoolean(PROP_CHECK_CONFIG) ? bundle.getLastModified() : this.getLastModifiedTimestamp(bundle);
            String[] dbBundlePath = new String[]{String.valueOf(bundle.getBundleId())};
            String lastModifiedValue = (String)this.data.get(this.getPath(dbBundlePath));
            if (lastModifiedValue == null) {
                components = this.parseXMLDeclaration(bundle, dsHeader);
                if (components != null && components.size() != 0) {
                    this.data.put(this.getPath(dbBundlePath), "" + lastModified);
                    this.saveComponentDefinitions(components, bundle.getBundleId());
                }
            } else {
                long dbLastModified = Long.parseLong(lastModifiedValue);
                if (lastModified != dbLastModified) {
                    components = this.parseXMLDeclaration(bundle, dsHeader);
                    if (components != null && components.size() != 0) {
                        this.data.put(this.getPath(dbBundlePath), "" + lastModified);
                        this.saveComponentDefinitions(components, bundle.getBundleId());
                    }
                } else {
                    components = this.loadComponentsFromDB(bundle);
                }
            }
            return components;
        }
        catch (Throwable e) {
            Activator.log(null, 1, NLS.bind((String)Messages.PROCESSING_BUNDLE_FAILED, (Object)Long.toString(bundle.getBundleId()), (Object)bundle), e);
            return null;
        }
    }

    private Vector loadComponentsFromDB(Bundle bundle) throws Exception {
        Vector components;
        ServiceComponent currentComponent;
        block4: {
            String[] stringArray = new String[2];
            stringArray[1] = "COMPONENTS";
            String[] dbCompPath = stringArray;
            currentComponent = null;
            long bundleId = bundle.getBundleId();
            dbCompPath[0] = String.valueOf(bundleId);
            DBObject value = new DBObject();
            byte[] byteArr = (byte[])this.data.get(this.getPath(dbCompPath));
            ByteArrayInputStream tmpIn = new ByteArrayInputStream(byteArr);
            value.readObject(tmpIn);
            components = value.components;
            if (components != null) break block4;
            return null;
        }
        try {
            int i = 0;
            while (i < components.size()) {
                currentComponent = (ServiceComponent)components.elementAt(i);
                currentComponent.bundle = bundle;
                currentComponent.bc = bundle.getBundleContext();
                ++i;
            }
            return components;
        }
        catch (Throwable t) {
            Activator.log(null, 1, Messages.ERROR_LOADING_COMPONENTS, t);
            return null;
        }
    }

    public void deleteComponentDefinitions(long bundleID) {
        String[] dbBundlePath = new String[]{String.valueOf(bundleID)};
        this.data.remove(this.getPath(dbBundlePath));
        String[] stringArray = new String[2];
        stringArray[1] = "COMPONENTS";
        String[] dbCompPath = stringArray;
        dbCompPath[0] = String.valueOf(bundleID);
        this.data.remove(this.getPath(dbCompPath));
        if (this.file.exists()) {
            this.file.delete();
        }
        this.isDirty = true;
    }

    private void saveComponentDefinitions(Vector components, long bundleID) throws Exception {
        try {
            if (components == null || components.size() == 0) {
                return;
            }
            String[] stringArray = new String[2];
            stringArray[1] = "COMPONENTS";
            String[] dbCompPath = stringArray;
            dbCompPath[0] = String.valueOf(bundleID);
            DBObject tmpObj = new DBObject(components);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            tmpObj.writeObject(buf);
            this.data.put(this.getPath(dbCompPath), buf.toByteArray());
            this.isDirty = true;
        }
        catch (Exception e) {
            Activator.log(null, 1, Messages.ERROR_SAVING_COMPONENT_DEFINITIONS, e);
        }
    }

    public void stop() {
        if (this.isDirty) {
            this.saveFile();
        }
    }

    private void saveFile() {
        block16: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(this.file);
                    try {
                        this.data.writeObject(fos);
                        this.isDirty = false;
                    }
                    catch (Exception e) {
                        Activator.log(null, 1, Messages.ERROR_WRITING_OBJECT, e);
                    }
                }
                catch (FileNotFoundException e) {
                    Activator.log(null, 1, Messages.FILE_DOESNT_EXIST_OR_DIRECTORY, e);
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPath(String[] path) {
        StringBuffer stringBuffer = this.pathBuffer;
        synchronized (stringBuffer) {
            this.pathBuffer.setLength(0);
            int i = 0;
            while (i < path.length) {
                this.pathBuffer.append(path[i]).append(this.separator);
                ++i;
            }
            return this.pathBuffer.toString();
        }
    }

    protected long getLastModifiedTimestamp(Bundle bundle) {
        if (bundle == null) {
            return 0L;
        }
        long result = 0L;
        ManifestElement[] elements = this.parseManifestHeader(bundle);
        int i = 0;
        while (i < elements.length) {
            URL componentURL = bundle.getEntry(elements[i].getValue());
            if (componentURL != null) {
                try {
                    URLConnection connection = componentURL.openConnection();
                    long lastModified = connection.getLastModified();
                    if (lastModified > result) {
                        result = lastModified;
                    }
                }
                catch (IOException iOException) {
                    return Long.MAX_VALUE;
                }
            }
            ++i;
        }
        return result;
    }

    private ManifestElement[] parseManifestHeader(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String files = (String)headers.get("Service-Component");
        if (files == null) {
            return new ManifestElement[0];
        }
        try {
            return ManifestElement.parseHeader((String)"Service-Component", (String)files);
        }
        catch (BundleException e) {
            Activator.log(bundle.getBundleContext(), 1, Messages.ERROR_PARSING_MANIFEST_HEADER, e);
            return new ManifestElement[0];
        }
    }
}

