/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.client.controller.test;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.beans.common.TypedBean;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.example.client.controllers.ControllerTestsPlaygroundSubModuleController;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.CComboRidget;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.swt.controllers.AbstractSubModuleControllerTest;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.IDateTextRidget;
import org.eclipse.riena.ui.ridgets.IDateTimeRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.IListRidget;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.ISpinnerRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.ITraverseRidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonUITestCase
public class ControllerTestsPlaygroundSubModuleControllerTest
extends AbstractSubModuleControllerTest<ControllerTestsPlaygroundSubModuleController> {
    private final List<Person> persons = PersonFactory.createPersonList();

    protected ControllerTestsPlaygroundSubModuleController createController(ISubModuleNode node) {
        ControllerTestsPlaygroundSubModuleController newInst = new ControllerTestsPlaygroundSubModuleController();
        node.setNodeId(new NavigationNodeId("org.eclipse.riena.example.marker"));
        newInst.setNavigationNode(node);
        return newInst;
    }

    public void testScaleSpinner() {
        ITraverseRidget scale = (ITraverseRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(ITraverseRidget.class, "celsiusScale");
        ISpinnerRidget fahrenheitSpinner = (ISpinnerRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(ISpinnerRidget.class, "fahrenheitSpinner");
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)0, (int)scale.getValue());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)32, (int)fahrenheitSpinner.getValue());
        scale.setValue(5);
        scale.triggerListener();
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)5, (int)scale.getValue());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)41, (int)fahrenheitSpinner.getValue());
        fahrenheitSpinner.setValue(100);
        fahrenheitSpinner.triggerListener();
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)100, (int)fahrenheitSpinner.getValue());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)38, (int)scale.getValue());
    }

    public void testCombo() {
        IComboRidget comboAge = (IComboRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IComboRidget.class, "ageCombo");
        IComboRidget cComboAge = (IComboRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(CComboRidget.class, "ageCCombo");
        ITextRidget comboText = (ITextRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(ITextRidget.class, "comboTextField");
        ILabelRidget comboLabel = (ILabelRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(ILabelRidget.class, "comboLabel");
        IActionRidget addToComboButton = (IActionRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IActionRidget.class, "addToComboButton");
        ArrayList<String> ages = new ArrayList<String>(Arrays.asList("<none>", "young", "moderate", "aged", "old"));
        ControllerTestsPlaygroundSubModuleControllerTest.assertNull((Object)comboAge.getSelection());
        ControllerTestsPlaygroundSubModuleControllerTest.assertNull((Object)cComboAge.getSelection());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)"", (String)comboText.getText());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)"<none>", (String)comboLabel.getText());
        comboAge.setSelection(ages.get(1));
        ControllerTestsPlaygroundSubModuleControllerTest.assertNull((Object)cComboAge.getSelection());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)1, (int)comboAge.getSelectionIndex());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals(ages.get(1), (Object)comboAge.getSelection());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)((String)ages.get(1)), (String)comboLabel.getText());
        comboText.setText("too old");
        addToComboButton.fireAction();
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)5, (int)comboAge.getSelectionIndex());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)5, (int)cComboAge.getSelectionIndex());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)"too old", (Object)comboAge.getSelection());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)"too old", (Object)cComboAge.getSelection());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)"too old", (String)comboLabel.getText());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)"", (String)comboText.getText());
        cComboAge.setSelection(ages.get(2));
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)5, (int)comboAge.getSelectionIndex());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((int)2, (int)cComboAge.getSelectionIndex());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals(ages.get(2), (Object)cComboAge.getSelection());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)((String)ages.get(2)), (String)comboLabel.getText());
    }

    public void testTable() {
        ITableRidget table = (ITableRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(ITableRidget.class, "multiTable");
        IActionRidget button = (IActionRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IActionRidget.class, "copySelectionButton");
        IListRidget list = (IListRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IListRidget.class, "tableList");
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals(this.persons, (Object)table.getObservableList());
        ControllerTestsPlaygroundSubModuleControllerTest.assertTrue((boolean)table.getSelection().isEmpty());
        table.setSelection(0);
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)this.persons.get(0), table.getSelection().get(0));
        button.fireAction();
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)this.persons.get(0), (Object)list.getObservableList().get(0));
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = 5;
        int[] selection = nArray;
        table.setSelection(selection);
        ArrayList<Person> selectedPersons = new ArrayList<Person>();
        selectedPersons.add(this.persons.get(selection[0]));
        selectedPersons.add(this.persons.get(selection[1]));
        selectedPersons.add(this.persons.get(selection[2]));
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals(selectedPersons, (Object)table.getSelection());
        button.fireAction();
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals(selectedPersons, (Object)list.getObservableList());
    }

    public void testMasterDetails() {
        IMasterDetailsRidget master = (IMasterDetailsRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IMasterDetailsRidget.class, "master");
        IActionRidget enableDisableButton = (IActionRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IActionRidget.class, "enableDisable");
        ControllerTestsPlaygroundSubModuleControllerTest.assertNull((Object)master.getSelection());
        ControllerTestsPlaygroundSubModuleControllerTest.assertTrue((boolean)master.isEnabled());
        enableDisableButton.fireAction();
        ControllerTestsPlaygroundSubModuleControllerTest.assertFalse((boolean)master.isEnabled());
    }

    public void testDateTime() throws Exception {
        IDateTimeRidget dtDate = (IDateTimeRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IDateTimeRidget.class, "dtDate");
        IDateTimeRidget dtTime = (IDateTimeRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IDateTimeRidget.class, "dtTime");
        IDateTimeRidget dtDateOnly = (IDateTimeRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IDateTimeRidget.class, "dtDateOnly");
        IDateTimeRidget dtTimeOnly = (IDateTimeRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IDateTimeRidget.class, "dtTimeOnly");
        IDateTimeRidget dtCal = (IDateTimeRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IDateTimeRidget.class, "dtCal");
        ITextRidget txt1 = (ITextRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(ITextRidget.class, "txt1");
        ITextRidget txt2 = (ITextRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(ITextRidget.class, "txt2");
        ITextRidget txt3 = (ITextRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(ITextRidget.class, "txt3");
        ITextRidget txt4 = (ITextRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(ITextRidget.class, "txt4");
        long now = (Long)ReflectionUtils.getHidden((Object)this.getController(), (String)"now");
        TypedBean date = new TypedBean((Object)new Date(now));
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)date.getValue(), (Object)dtDate.getDate());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)date.getValue(), (Object)dtTime.getDate());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)date.getValue(), (Object)dtDateOnly.getDate());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)date.getValue(), (Object)dtTimeOnly.getDate());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)date.getValue(), (Object)dtCal.getDate());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)((Date)date.getValue()).toString(), (String)txt1.getText());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)((Date)date.getValue()).toString(), (String)txt2.getText());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)((Date)date.getValue()).toString(), (String)txt3.getText());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)((Date)date.getValue()).toString(), (String)txt4.getText());
        Calendar cal = GregorianCalendar.getInstance();
        cal.set(2, 5);
        cal.set(1, 2011);
        dtDate.setDate(cal.getTime());
        dtTime.setDate(cal.getTime());
        dtDateOnly.setDate(cal.getTime());
        dtTimeOnly.setDate(cal.getTime());
        dtCal.setDate(cal.getTime());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)cal.getTime().toString(), (String)txt1.getText());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)cal.getTime().toString(), (String)txt2.getText());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)cal.getTime().toString(), (String)txt3.getText());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)cal.getTime().toString(), (String)txt4.getText());
        IDateTextRidget dateTextRidget = (IDateTextRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IDateTextRidget.class, "dateText");
        IActionRidget dateTimeButton = (IActionRidget)((ControllerTestsPlaygroundSubModuleController)this.getController()).getRidget(IActionRidget.class, "dateTimeButton");
        dateTextRidget.setText("31.03.1980");
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((String)"31.03.1980", (String)dateTextRidget.getText());
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        Date newDate = df.parse("31.03.1980");
        dateTimeButton.fireAction();
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)newDate, (Object)dtDate.getDate());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)newDate, (Object)dtDateOnly.getDate());
        ControllerTestsPlaygroundSubModuleControllerTest.assertEquals((Object)newDate, (Object)dtCal.getDate());
    }
}

