/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.client.controller.test;

import java.util.Comparator;
import org.easymock.EasyMock;
import org.easymock.LogicalOperator;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.example.client.controllers.NavigateSubModuleController;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.example.client.beans.PersonModificationBean;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.swt.controllers.AbstractSubModuleControllerTest;
import org.eclipse.riena.ui.ridgets.IActionRidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonUITestCase
public class NavigateSubModuleControllerTest
extends AbstractSubModuleControllerTest<NavigateSubModuleController> {
    protected NavigateSubModuleController createController(ISubModuleNode node) {
        NavigateSubModuleController newInst = new NavigateSubModuleController();
        node.setNodeId(new NavigationNodeId("org.eclipse.riena.example.navigate"));
        newInst.setNavigationNode(node);
        return newInst;
    }

    public void testNavigateCombo() {
        this.getMockNavigationProcessor().navigate((INavigationNode)EasyMock.eq((Object)((ISubModuleNode)((NavigateSubModuleController)this.getController()).getNavigationNode())), (NavigationNodeId)EasyMock.eq((Object)new NavigationNodeId("org.eclipse.riena.example.navigate.comboAndList")), (NavigationArgument)EasyMock.isNull());
        EasyMock.replay((Object[])new Object[]{this.getMockNavigationProcessor()});
        IActionRidget navigateToComboButton = (IActionRidget)((NavigateSubModuleController)this.getController()).getRidget(IActionRidget.class, "comboAndList");
        navigateToComboButton.fireAction();
        EasyMock.verify((Object[])new Object[]{this.getMockNavigationProcessor()});
    }

    public void testNavigateToRidgetWithCompare() {
        PersonModificationBean bean = new PersonModificationBean();
        bean.setPerson(new Person("Doe", "Jane"));
        this.getMockNavigationProcessor().navigate((INavigationNode)EasyMock.eq((Object)((ISubModuleNode)((NavigateSubModuleController)this.getController()).getNavigationNode())), (NavigationNodeId)EasyMock.eq((Object)new NavigationNodeId("org.eclipse.riena.example.combo")), (NavigationArgument)EasyMock.cmp((Object)new NavigationArgument((Object)bean, "textFirst"), (Comparator)new Comparator<NavigationArgument>(){

            @Override
            public int compare(NavigationArgument o1, NavigationArgument o2) {
                if (o1.getParameter() instanceof PersonModificationBean && o2.getParameter() instanceof PersonModificationBean) {
                    return NavigateSubModuleControllerTest.this.comparePersonModificationBeans((PersonModificationBean)o1.getParameter(), (PersonModificationBean)o2.getParameter());
                }
                return -1;
            }
        }, (LogicalOperator)LogicalOperator.EQUAL));
        EasyMock.replay((Object[])new Object[]{this.getMockNavigationProcessor()});
        IActionRidget navigateToNavigateRidget = (IActionRidget)((NavigateSubModuleController)this.getController()).getRidget(IActionRidget.class, "btnNavigateToRidget");
        navigateToNavigateRidget.fireAction();
        EasyMock.verify((Object[])new Object[]{this.getMockNavigationProcessor()});
    }

    public void testNavigateToRidgetWithNotNull() {
        this.getMockNavigationProcessor().navigate((INavigationNode)EasyMock.eq((Object)((ISubModuleNode)((NavigateSubModuleController)this.getController()).getNavigationNode())), (NavigationNodeId)EasyMock.eq((Object)new NavigationNodeId("org.eclipse.riena.example.combo")), new NavigationArgument(EasyMock.notNull(), "textFirst"));
        EasyMock.replay((Object[])new Object[]{this.getMockNavigationProcessor()});
        IActionRidget navigateToNavigateRidget = (IActionRidget)((NavigateSubModuleController)this.getController()).getRidget(IActionRidget.class, "btnNavigateToRidget");
        navigateToNavigateRidget.fireAction();
        EasyMock.verify((Object[])new Object[]{this.getMockNavigationProcessor()});
    }

    public void testNavigateToRidgetWithEquals() {
        PersonModificationBean bean = new PersonModificationBean();
        bean.setPerson(new Person("Doe", "Jane"));
        this.getMockNavigationProcessor().navigate((INavigationNode)EasyMock.eq((Object)((ISubModuleNode)((NavigateSubModuleController)this.getController()).getNavigationNode())), (NavigationNodeId)EasyMock.eq((Object)new NavigationNodeId("org.eclipse.riena.example.combo")), (NavigationArgument)EasyMock.eq((Object)new NavigationArgument((Object)bean, "textFirst")));
        EasyMock.replay((Object[])new Object[]{this.getMockNavigationProcessor()});
        IActionRidget navigateToNavigateRidget = (IActionRidget)((NavigateSubModuleController)this.getController()).getRidget(IActionRidget.class, "btnNavigateToRidget");
        navigateToNavigateRidget.fireAction();
        EasyMock.verify((Object[])new Object[]{this.getMockNavigationProcessor()});
    }

    public void testNavigateTableTextAndTree() {
        this.getMockNavigationProcessor().navigate((INavigationNode)EasyMock.eq((Object)((ISubModuleNode)((NavigateSubModuleController)this.getController()).getNavigationNode())), (NavigationNodeId)EasyMock.eq((Object)new NavigationNodeId("org.eclipse.riena.example.navigate.tableTextAndTree")), (NavigationArgument)EasyMock.isNull());
        EasyMock.replay((Object[])new Object[]{this.getMockNavigationProcessor()});
        IActionRidget navigateToTableTextAndTree = (IActionRidget)((NavigateSubModuleController)this.getController()).getRidget(IActionRidget.class, "tableTextAndTree");
        navigateToTableTextAndTree.fireAction();
        EasyMock.verify((Object[])new Object[]{this.getMockNavigationProcessor()});
    }

    private int comparePersonModificationBeans(PersonModificationBean p1, PersonModificationBean p2) {
        if (p1.getFirstName().equals(p2.getFirstName()) && p1.getLastName().equals(p2.getLastName())) {
            return 0;
        }
        return -1;
    }
}

