/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTableRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.TestSelectionListener;
import org.eclipse.riena.internal.ui.ridgets.swt.optional.CompositeTableRidget;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.ICompositeTableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRowRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.nebula.widgets.compositetable.AbstractNativeHeader;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.swt.nebula.widgets.compositetable.ResizableGridRowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CompositeTableRidgetTest
extends AbstractTableRidgetTest {
    protected Widget createWidget(Composite parent) {
        CompositeTable control = new CompositeTable(parent, 0);
        control.setLayoutData((Object)new RowData(300, 300));
        new Header((Composite)control, 0);
        new Row((Composite)control, 0);
        control.setRunTime(true);
        return control;
    }

    protected IRidget createRidget() {
        return new CompositeTableRidget();
    }

    protected CompositeTable getWidget() {
        return (CompositeTable)super.getWidget();
    }

    protected ICompositeTableRidget getRidget() {
        return (ICompositeTableRidget)super.getRidget();
    }

    protected void bindRidgetToModel() {
        IObservableList rowObservables = BeansObservables.observeList((Object)this.manager, (String)"persons");
        this.getRidget().bindToModel(rowObservables, Person.class, RowRidget.class);
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        CompositeTableRidgetTest.assertSame(CompositeTableRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testBindToModelWithListHolder() {
        Shell shell = new Shell(147456);
        try {
            shell.setLayout((Layout)new RowLayout(512));
            CompositeTable widget = (CompositeTable)this.createWidget((Composite)shell);
            ICompositeTableRidget ridget = (ICompositeTableRidget)this.createRidget();
            ridget.setUIControl((Object)widget);
            MyModel model = new MyModel();
            ridget.bindToModel((Object)model, "persons", Person.class, RowRidget.class);
            ridget.updateFromModel();
            shell.setSize(130, 100);
            shell.setLocation(0, 0);
            shell.open();
            UITestHelper.readAndDispatch((Widget)this.getWidget());
            CompositeTableRidgetTest.assertNotNull((Object)widget.getRowControls());
            CompositeTableRidgetTest.assertEquals((int)model.getPersons().size(), (int)widget.getRowControls().length);
        }
        finally {
            shell.dispose();
        }
    }

    public void testUpdateSingleSelectionFromRidgetOnRebind() {
        ICompositeTableRidget ridget = this.getRidget();
        CompositeTable control = this.getWidget();
        this.setUIControlRowSelectionInterval(2, 2);
        CompositeTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRow());
        ridget.setUIControl(null);
        control.setSelection(0, 1);
        UITestHelper.readAndDispatch((Widget)control);
        CompositeTableRidgetTest.assertEquals((int)1, (int)this.getUIControlSelectedRow());
        CompositeTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.singleSelectionBean.getSelection());
        CompositeTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        CompositeTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(0));
        ridget.setUIControl((Object)control);
        CompositeTableRidgetTest.assertEquals((int)2, (int)this.getUIControlSelectedRow());
        CompositeTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.singleSelectionBean.getSelection());
        CompositeTableRidgetTest.assertEquals((int)1, (int)this.multiSelectionBean.getSelectionList().size());
        CompositeTableRidgetTest.assertEquals((Object)this.getRowValue(2), (Object)this.multiSelectionBean.getSelectionList().get(0));
    }

    public void testUpdateFromModelPreservesSelection() {
        ICompositeTableRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        CompositeTableRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person1);
        ridget.updateFromModel();
        CompositeTableRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
    }

    public void testUpdateFromModelRemovesSelection() {
        ICompositeTableRidget ridget = this.getRidget();
        ridget.setSelection((Object)this.person2);
        CompositeTableRidgetTest.assertSame((Object)this.person2, ridget.getSelection().get(0));
        this.manager.getPersons().remove(this.person2);
        ridget.updateFromModel();
        CompositeTableRidgetTest.assertTrue((boolean)ridget.getSelection().isEmpty());
    }

    public void testContainsOption() {
        ICompositeTableRidget ridget = this.getRidget();
        CompositeTableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person1));
        CompositeTableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person2));
        CompositeTableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
        CompositeTableRidgetTest.assertFalse((boolean)ridget.containsOption(null));
        CompositeTableRidgetTest.assertFalse((boolean)ridget.containsOption((Object)new Person("", "")));
        this.manager.getPersons().remove(this.person1);
        this.manager.getPersons().remove(this.person2);
        CompositeTableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person1));
        CompositeTableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person2));
        CompositeTableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
        ridget.updateFromModel();
        CompositeTableRidgetTest.assertFalse((boolean)ridget.containsOption((Object)this.person1));
        CompositeTableRidgetTest.assertFalse((boolean)ridget.containsOption((Object)this.person2));
        CompositeTableRidgetTest.assertTrue((boolean)ridget.containsOption((Object)this.person3));
    }

    public void testSetComparator() throws Exception {
        ICompositeTableRidget ridget = this.getRidget();
        CompositeTable control = this.getWidget();
        FirstNameComparator comparatorFirst = new FirstNameComparator();
        LastNameComparator comparatorLast = new LastNameComparator();
        try {
            ridget.setComparator(-1, (Comparator)comparatorFirst);
            CompositeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        ridget.setSortedAscending(true);
        int lastItemIndex = control.getNumRowsInCollection() - 1;
        CompositeTableRidgetTest.assertEquals((String)"John", (String)this.getFirstNameFromRow(control, 0));
        CompositeTableRidgetTest.assertEquals((String)"Frank", (String)this.getFirstNameFromRow(control, lastItemIndex));
        ridget.setComparator(0, (Comparator)comparatorFirst);
        CompositeTableRidgetTest.assertEquals((String)"John", (String)this.getFirstNameFromRow(control, 0));
        CompositeTableRidgetTest.assertEquals((String)"Frank", (String)this.getFirstNameFromRow(control, lastItemIndex));
        ridget.setSortedColumn(0);
        CompositeTableRidgetTest.assertEquals((String)"Frank", (String)this.getFirstNameFromRow(control, 0));
        CompositeTableRidgetTest.assertEquals((String)"John", (String)this.getFirstNameFromRow(control, lastItemIndex));
        ridget.setComparator(0, null);
        CompositeTableRidgetTest.assertEquals((String)"John", (String)this.getFirstNameFromRow(control, 0));
        CompositeTableRidgetTest.assertEquals((String)"Frank", (String)this.getFirstNameFromRow(control, lastItemIndex));
        ridget.setComparator(1, (Comparator)comparatorLast);
        ridget.setSortedColumn(1);
        UITestHelper.readAndDispatch((Widget)control);
        CompositeTableRidgetTest.assertEquals((String)"Doe", (String)this.getLastNameFromRow(control, 0));
        CompositeTableRidgetTest.assertEquals((String)"Zappa", (String)this.getLastNameFromRow(control, lastItemIndex));
        ridget.setSortedAscending(false);
        CompositeTableRidgetTest.assertEquals((String)"Zappa", (String)this.getLastNameFromRow(control, 0));
        CompositeTableRidgetTest.assertEquals((String)"Doe", (String)this.getLastNameFromRow(control, lastItemIndex));
    }

    public void testGetSortedColumn() {
        ICompositeTableRidget ridget = this.getRidget();
        CompositeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(0, (Comparator)new FirstNameComparator());
        CompositeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        CompositeTableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        ridget.setComparator(0, null);
        CompositeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setComparator(1, (Comparator)new FirstNameComparator());
        ridget.setSortedColumn(1);
        CompositeTableRidgetTest.assertEquals((int)1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(-1);
        CompositeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        ridget.setSortedColumn(0);
        CompositeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
    }

    public void testIsColumnSortable() {
        ICompositeTableRidget ridget = this.getRidget();
        try {
            CompositeTableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(-1));
            CompositeTableRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        int i = 0;
        while (i < 2) {
            CompositeTableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ridget.setComparator(i, (Comparator)new TypedComparator());
            CompositeTableRidgetTest.assertTrue((boolean)ridget.isColumnSortable(i));
            ridget.setColumnSortable(i, false);
            CompositeTableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ridget.setColumnSortable(i, true);
            CompositeTableRidgetTest.assertTrue((boolean)ridget.isColumnSortable(i));
            ridget.setComparator(i, null);
            CompositeTableRidgetTest.assertFalse((boolean)ridget.isColumnSortable(i));
            ++i;
        }
    }

    public void testSetSortedAscending() {
        CompositeTable control = this.getWidget();
        ICompositeTableRidget ridget = this.getRidget();
        int lastItemIndex = control.getNumRowsInCollection() - 1;
        CompositeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        CompositeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        ridget.setComparator(0, (Comparator)new LastNameComparator());
        ridget.setSortedColumn(0);
        CompositeTableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        CompositeTableRidgetTest.assertEquals((String)"Doe", (String)this.getLastNameFromRow(control, 0));
        CompositeTableRidgetTest.assertEquals((String)"Zappa", (String)this.getLastNameFromRow(control, lastItemIndex));
        ridget.setSortedAscending(false);
        CompositeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        CompositeTableRidgetTest.assertEquals((String)"Zappa", (String)this.getLastNameFromRow(control, 0));
        CompositeTableRidgetTest.assertEquals((String)"Doe", (String)this.getLastNameFromRow(control, lastItemIndex));
        ridget.setSortedAscending(true);
        CompositeTableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        CompositeTableRidgetTest.assertEquals((String)"Doe", (String)this.getLastNameFromRow(control, 0));
        CompositeTableRidgetTest.assertEquals((String)"Zappa", (String)this.getLastNameFromRow(control, lastItemIndex));
        ridget.setComparator(0, null);
        CompositeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        CompositeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
    }

    public void testSetSortedAscendingFiresEvents() {
        ICompositeTableRidget ridget = this.getRidget();
        ridget.setSortedAscending(true);
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.TRUE, Boolean.FALSE));
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortAscending", Boolean.FALSE, Boolean.TRUE));
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedAscending(true);
        this.verifyPropertyChangeEvents();
    }

    public void testSetSortedColumnFiresEvents() {
        ICompositeTableRidget ridget = this.getRidget();
        CompositeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", -1, 0));
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSortedColumn(0);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "sortedColumn", 0, 1));
        ridget.setSortedColumn(1);
        this.verifyPropertyChangeEvents();
    }

    public void testSetColumnSortabilityFiresEvents() {
        ICompositeTableRidget ridget = this.getRidget();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "columnSortability", null, 0));
        ridget.setColumnSortable(0, false);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, false);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvents(new PropertyChangeEvent(ridget, "columnSortability", null, 0));
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setColumnSortable(0, true);
        this.verifyPropertyChangeEvents();
    }

    public void testColumnHeaderChangesSortability() {
        ICompositeTableRidget ridget = this.getRidget();
        ridget.setColumnSortable(0, true);
        ridget.setComparator(0, (Comparator)new FirstNameComparator());
        ridget.setColumnSortable(1, true);
        ridget.setComparator(1, (Comparator)new FirstNameComparator());
        ridget.setSortedColumn(-1);
        CompositeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        CompositeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        Event e = new Event();
        e.type = 13;
        e.widget = this.getColumn((CompositeTableRidget)ridget, 0);
        e.widget.notifyListeners(13, e);
        CompositeTableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        CompositeTableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        CompositeTableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        CompositeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        CompositeTableRidgetTest.assertEquals((int)-1, (int)ridget.getSortedColumn());
        CompositeTableRidgetTest.assertFalse((boolean)ridget.isSortedAscending());
        e.widget.notifyListeners(13, e);
        CompositeTableRidgetTest.assertEquals((int)0, (int)ridget.getSortedColumn());
        CompositeTableRidgetTest.assertTrue((boolean)ridget.isSortedAscending());
    }

    public void testBindsNeedsUpdateFromModel() {
        CompositeTableRidget ridget = new CompositeTableRidget();
        IObservableList rowObservables = BeansObservables.observeList((Object)this.manager, (String)"persons");
        ridget.bindToModel(rowObservables, Person.class, RowRidget.class);
        CompositeTableRidgetTest.assertEquals((int)0, (int)ridget.getOptionCount());
        ridget.updateFromModel();
        CompositeTableRidgetTest.assertEquals((int)rowObservables.size(), (int)ridget.getOptionCount());
    }

    public void testAddSelectionListener() {
        ICompositeTableRidget ridget = this.getRidget();
        try {
            ridget.addSelectionListener(null);
            CompositeTableRidgetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.ok();
        }
        TestSelectionListener selectionListener = new TestSelectionListener();
        try {
            ridget.addSelectionListener((ISelectionListener)selectionListener);
            CompositeTableRidgetTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.ok();
        }
    }

    private String getFirstNameFromRow(CompositeTable control, int rowIndex) {
        UITestHelper.readAndDispatch((Widget)control);
        control.setSelection(0, rowIndex - control.getTopRow());
        UITestHelper.readAndDispatch((Widget)control);
        Control[] rowControls = control.getRowControls();
        if (rowIndex == 0) {
            return ((Row)rowControls[0]).txtFirst.getText();
        }
        if (rowIndex == 7) {
            int index = rowControls.length - 1;
            return ((Row)rowControls[index]).txtFirst.getText();
        }
        throw new IllegalArgumentException("index= " + rowIndex);
    }

    private String getLastNameFromRow(CompositeTable control, int rowIndex) {
        UITestHelper.readAndDispatch((Widget)control);
        control.setSelection(0, rowIndex - control.getTopRow());
        UITestHelper.readAndDispatch((Widget)control);
        Control[] rowControls = control.getRowControls();
        if (rowIndex == 0) {
            return ((Row)rowControls[0]).txtLast.getText();
        }
        if (rowIndex == 7) {
            int index = rowControls.length - 1;
            return ((Row)rowControls[index]).txtLast.getText();
        }
        throw new IllegalArgumentException("index= " + rowIndex);
    }

    private TableColumn getColumn(CompositeTableRidget ridget, int columnIndex) {
        TableColumn result = null;
        Object table = ReflectionUtils.invokeHidden((Object)ridget, (String)"getHeader", null);
        if (table instanceof AbstractNativeHeader) {
            result = ((AbstractNativeHeader)table).getColumns()[columnIndex];
        }
        return result;
    }

    protected void clearUIControlRowSelection() {
        throw new UnsupportedOperationException();
    }

    protected Object getRowValue(int i) {
        List rowObservables = (List)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        return rowObservables.get(i);
    }

    protected int[] getSelectedRows() {
        List rowObservables = (List)ReflectionUtils.invokeHidden((Object)this.getRidget(), (String)"getRowObservables", (Object[])new Object[0]);
        Object[] elements = this.getRidget().getMultiSelectionObservable().toArray();
        int[] result = new int[elements.length];
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            result[i] = rowObservables.indexOf(element);
            ++i;
        }
        return result;
    }

    protected int getUIControlSelectedRow() {
        CompositeTable control = this.getWidget();
        Point selection = control.getSelection();
        return selection == null || selection.y == -1 ? -1 : selection.y + control.getTopRow();
    }

    protected int getUIControlSelectedRowCount() {
        CompositeTable control = this.getWidget();
        Point selection = null;
        if (this.getRidget().getSelectionIndex() != -1) {
            selection = control.getSelection();
        }
        return selection == null || selection.y == -1 ? 0 : 1;
    }

    protected int[] getUIControlSelectedRows() {
        int[] nArray;
        int index = this.getUIControlSelectedRow();
        if (index == -1) {
            nArray = new int[]{};
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = index;
        }
        return nArray;
    }

    protected void setUIControlRowSelection(int[] indices) {
        throw new UnsupportedOperationException("not supported");
    }

    protected void setUIControlRowSelectionInterval(int start, int end) {
        CompositeTableRidgetTest.assertTrue((String)"multiple selection is not supported", (start == end ? 1 : 0) != 0);
        CompositeTable control = this.getWidget();
        int row = start - control.getTopRow();
        control.setSelection(0, row);
        UITestHelper.readAndDispatch((Widget)control);
    }

    protected boolean supportsMulti() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FirstNameComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FirstNameComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Person p1 = (Person)o1;
            Person p2 = (Person)o2;
            return p1.getFirstname().compareTo(p2.getFirstname());
        }
    }

    public static class Header
    extends AbstractNativeHeader {
        public Header(Composite parent, int style) {
            super(parent, style);
            this.setWeights(new int[]{100, 100});
            this.setColumnText(new String[]{"First Name", "LastName"});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LastNameComparator
    implements Comparator<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private LastNameComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            Person p1 = (Person)o1;
            Person p2 = (Person)o2;
            return p1.getLastname().compareTo(p2.getLastname());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyModel {
        private List<Person> persons = PersonFactory.createPersonList();

        private MyModel() {
        }

        public List<Person> getPersons() {
            return this.persons;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Row
    extends Composite
    implements IComplexComponent {
        private Text txtFirst;
        private Text txtLast;

        public Row(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new ResizableGridRowLayout());
            this.txtFirst = UIControlsFactory.createText((Composite)this);
            this.txtFirst.setText("first");
            this.txtLast = UIControlsFactory.createText((Composite)this);
            this.txtLast.setText("last");
            SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
            locator.setBindingProperty((Object)this.txtFirst, "first");
            locator.setBindingProperty((Object)this.txtLast, "last");
        }

        public List<Object> getUIControls() {
            return Arrays.asList(this.txtFirst, this.txtLast);
        }

        public String toString() {
            return String.valueOf(this.txtFirst.getText()) + " " + this.txtLast.getText();
        }
    }

    public static class RowRidget
    extends AbstractCompositeRidget
    implements IRowRidget {
        private Person rowData;

        public void setData(Object rowData) {
            this.rowData = (Person)rowData;
        }

        public void configureRidgets() {
            ITextRidget txtFirst = (ITextRidget)this.getRidget("first");
            txtFirst.bindToModel((Object)this.rowData, "firstname");
            txtFirst.updateFromModel();
            ITextRidget txtLast = (ITextRidget)this.getRidget("last");
            txtLast.bindToModel((Object)this.rowData, "lastname");
            txtLast.updateFromModel();
        }
    }
}

