/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.ridgets.swt.MarkableRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.MultipleChoiceRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TestSelectionListener;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipleChoiceRidgetTest
extends MarkableRidgetTest {
    private OptionProvider optionProvider;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.optionProvider = new OptionProvider();
        this.getRidget().bindToModel((Object)this.optionProvider, "options", (Object)this.optionProvider, "selectedOptions");
        this.getRidget().updateFromModel();
    }

    @Override
    protected Control createWidget(Composite parent) {
        return new ChoiceComposite(parent, 0, true);
    }

    @Override
    protected IRidget createRidget() {
        return new MultipleChoiceRidget();
    }

    protected ChoiceComposite getWidget() {
        return (ChoiceComposite)super.getWidget();
    }

    protected IMultipleChoiceRidget getRidget() {
        return (IMultipleChoiceRidget)super.getRidget();
    }

    public void testRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        MultipleChoiceRidgetTest.assertSame(MultipleChoiceRidget.class, (Object)mapper.getRidgetClass((Object)this.getWidget()));
    }

    public void testGetUIControl() throws Exception {
        IMultipleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        MultipleChoiceRidgetTest.assertEquals((Object)control, (Object)ridget.getUIControl());
    }

    public void testGetObservableSelectionList() throws Exception {
        IMultipleChoiceRidget ridget = this.getRidget();
        MultipleChoiceRidgetTest.assertNotNull((Object)ridget.getObservableSelectionList());
    }

    public void testUpdateFromModel() throws Exception {
        IMultipleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        this.optionProvider.setOptions(Arrays.asList("a", "b", "c", "d"));
        this.optionProvider.setSelectedOptions(Arrays.asList("c", "d"));
        ridget.updateFromModel();
        int oldSize = this.optionProvider.getOptions().size();
        MultipleChoiceRidgetTest.assertEquals((int)oldSize, (int)ridget.getObservableList().size());
        MultipleChoiceRidgetTest.assertTrue((boolean)ridget.getObservableList().containsAll(this.optionProvider.getOptions()));
        MultipleChoiceRidgetTest.assertEquals((int)this.optionProvider.getSelectedOptions().size(), (int)ridget.getObservableSelectionList().size());
        MultipleChoiceRidgetTest.assertTrue((boolean)this.optionProvider.getSelectedOptions().containsAll((Collection<?>)ridget.getObservableSelectionList()));
        MultipleChoiceRidgetTest.assertEquals(this.optionProvider.getSelectedOptions(), this.getSelectedControlValues(control));
        this.optionProvider.remove(0);
        MultipleChoiceRidgetTest.assertEquals((int)oldSize, (int)ridget.getObservableList().size());
        ridget.updateFromModel();
        MultipleChoiceRidgetTest.assertEquals((int)(oldSize - 1), (int)ridget.getObservableList().size());
    }

    public void testUpdateFromModelFiresEvents() throws Exception {
        IMultipleChoiceRidget ridget = this.getRidget();
        String element0 = this.optionProvider.getOptions().get(0);
        String element1 = this.optionProvider.getOptions().get(1);
        List<String> selection1 = Arrays.asList(element0);
        List<String> selection2 = Arrays.asList(element0, element1);
        ridget.setSelection(selection2);
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)ridget.getSelection().size());
        List<PropertyChangeEvent> events = MultipleChoiceRidgetTest.newEventCatchingList((IRidget)ridget, "selection");
        this.optionProvider.setSelectedOptions(selection1);
        MultipleChoiceRidgetTest.assertEquals((int)0, (int)events.size());
        ridget.updateFromModel();
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)events.size());
        PropertyChangeEvent event0 = events.get(0);
        MultipleChoiceRidgetTest.assertEquals((String)"selection", (String)event0.getPropertyName());
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)((List)event0.getOldValue()).size());
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)((List)event0.getNewValue()).size());
        this.optionProvider.setSelectedOptions(selection1);
        ridget.updateFromModel();
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)events.size());
        this.optionProvider.setSelectedOptions(null);
        ridget.updateFromModel();
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)events.size());
        PropertyChangeEvent event1 = events.get(1);
        MultipleChoiceRidgetTest.assertEquals((String)"selection", (String)event0.getPropertyName());
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)((List)event1.getOldValue()).size());
        MultipleChoiceRidgetTest.assertEquals((int)0, (int)((List)event1.getNewValue()).size());
    }

    public void testSetSelection() {
        IMultipleChoiceRidget ridget = this.getRidget();
        String element0 = this.optionProvider.getOptions().get(0);
        String element1 = this.optionProvider.getOptions().get(1);
        List<String> selection1 = Arrays.asList(element0);
        List<String> selection2 = Arrays.asList(element0, element1);
        ridget.setSelection(selection1);
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        MultipleChoiceRidgetTest.assertSame((Object)element0, ridget.getSelection().get(0));
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)this.optionProvider.getSelectedOptions().size());
        MultipleChoiceRidgetTest.assertSame((Object)element0, (Object)this.optionProvider.getSelectedOptions().get(0));
        ridget.setSelection(selection2);
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)ridget.getSelection().size());
        MultipleChoiceRidgetTest.assertSame((Object)element0, ridget.getSelection().get(0));
        MultipleChoiceRidgetTest.assertSame((Object)element1, ridget.getSelection().get(1));
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)this.optionProvider.getSelectedOptions().size());
        MultipleChoiceRidgetTest.assertSame((Object)element0, (Object)this.optionProvider.getSelectedOptions().get(0));
        MultipleChoiceRidgetTest.assertSame((Object)element1, (Object)this.optionProvider.getSelectedOptions().get(1));
        ridget.setSelection(null);
        MultipleChoiceRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        MultipleChoiceRidgetTest.assertEquals((int)0, (int)this.optionProvider.getSelectedOptions().size());
        try {
            Object unknownObject = new Object();
            ridget.setSelection(Arrays.asList(unknownObject));
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testSelectionFiresEvents() {
        IMultipleChoiceRidget ridget = this.getRidget();
        String element0 = this.optionProvider.getOptions().get(0);
        String element1 = this.optionProvider.getOptions().get(1);
        List<String> selection2 = Arrays.asList(element0, element1);
        ridget.setSelection(null);
        this.expectPropertyChangeEvent("selection", Collections.EMPTY_LIST, selection2);
        ridget.setSelection(selection2);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSelection(selection2);
        this.verifyPropertyChangeEvents();
        this.expectPropertyChangeEvent("selection", selection2, Collections.EMPTY_LIST);
        ridget.setSelection(null);
        this.verifyPropertyChangeEvents();
        this.expectNoPropertyChangeEvent();
        ridget.setSelection(null);
        this.verifyPropertyChangeEvents();
    }

    public void testSelectionUpdatesControl() {
        IMultipleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        String element0 = this.optionProvider.getOptions().get(0);
        String element1 = this.optionProvider.getOptions().get(1);
        List<String> selection2 = Arrays.asList(element0, element1);
        ridget.setSelection(selection2);
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)this.getSelectionCount(control));
        MultipleChoiceRidgetTest.assertTrue((boolean)this.getSelectedControlValues(control).containsAll(selection2));
        ridget.setSelection(null);
        MultipleChoiceRidgetTest.assertEquals((int)0, (int)this.getSelectionCount(control));
    }

    public void testUpdateFromModelUpdatesControl() {
        IMultipleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        String element0 = this.optionProvider.getOptions().get(0);
        String element1 = this.optionProvider.getOptions().get(1);
        List<String> selection2 = Arrays.asList(element0, element1);
        this.optionProvider.setSelectedOptions(selection2);
        ridget.updateFromModel();
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)this.getSelectionCount(control));
        MultipleChoiceRidgetTest.assertTrue((boolean)this.getSelectedControlValues(control).containsAll(selection2));
        this.optionProvider.setSelectedOptions(null);
        ridget.updateFromModel();
        MultipleChoiceRidgetTest.assertEquals((int)0, (int)this.getSelectionCount(control));
    }

    public void testUserSetSelection() throws Exception {
        IMultipleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        this.optionProvider.setSelectedOptions(new ArrayList<String>());
        ridget.updateFromModel();
        MultipleChoiceRidgetTest.assertTrue((String)"Initially no option selected in model", (boolean)this.optionProvider.getSelectedOptions().isEmpty());
        MultipleChoiceRidgetTest.assertEquals((String)"Initially no option selected in ridget", (int)0, (int)ridget.getSelection().size());
        List<PropertyChangeEvent> events = MultipleChoiceRidgetTest.newEventCatchingList((IRidget)ridget, "selection");
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)" ");
        MultipleChoiceRidgetTest.assertEquals((String)"Option successfully selected in model", (int)1, (int)this.optionProvider.getSelectedOptions().size());
        MultipleChoiceRidgetTest.assertEquals((String)"Option successfully selected in ridget", (int)1, (int)ridget.getSelection().size());
        MultipleChoiceRidgetTest.assertEquals((String)"PropertyChangedEvent fired", (int)1, (int)events.size());
        this.assertEquals("PropertyChangedEvent fired", events.get(0), "selection", Collections.EMPTY_LIST, Arrays.asList(this.optionProvider.getOptions().get(0)));
    }

    public void testAddRemovePropertyChangeListener() throws Exception {
        IMultipleChoiceRidget ridget = this.getRidget();
        TestPropertyChangeListener l = new TestPropertyChangeListener();
        ridget.addPropertyChangeListener((PropertyChangeListener)l);
        MultipleChoiceRidgetTest.assertEquals(this.optionProvider.getSelectedOptions(), (Object)ridget.getSelection());
        ridget.setSelection(Arrays.asList(this.optionProvider.getOptions().get(1)));
        MultipleChoiceRidgetTest.assertEquals((Object)ridget.getSelection(), this.optionProvider.getSelectedOptions());
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)l.eventCounter);
        ridget.removePropertyChangeListener((PropertyChangeListener)l);
        ridget.setSelection(Arrays.asList(this.optionProvider.getOptions().get(0)));
        MultipleChoiceRidgetTest.assertEquals((Object)ridget.getSelection(), this.optionProvider.getSelectedOptions());
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)l.eventCounter);
    }

    public void testBindToModelUsingLabels() throws Exception {
        IMultipleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        this.optionProvider = new OptionProvider();
        ridget.bindToModel(this.optionProvider.getOptions(), this.optionProvider.getOptionLabels(), (Object)this.optionProvider, "selectedOptions");
        ridget.updateFromModel();
        Object[] labels = this.optionProvider.getOptionLabels().toArray();
        Control[] children = control.getChildren();
        MultipleChoiceRidgetTest.assertEquals((int)labels.length, (int)children.length);
        int i = 0;
        while (i < labels.length) {
            String label = (String)labels[i];
            String caption = ((Button)children[i]).getText();
            MultipleChoiceRidgetTest.assertEquals((String)label, (String)caption);
            ++i;
        }
    }

    public void testDisableMandatoryMarkers() throws Exception {
        IMultipleChoiceRidget ridget = this.getRidget();
        MandatoryMarker mandatoryMarker = new MandatoryMarker();
        this.optionProvider.setSelectedOptions(new ArrayList<String>());
        ridget.updateFromModel();
        ridget.addMarker((IMarker)mandatoryMarker);
        MultipleChoiceRidgetTest.assertFalse((boolean)mandatoryMarker.isDisabled());
        ridget.setSelection(Arrays.asList(this.optionProvider.getOptions().get(1)));
        MultipleChoiceRidgetTest.assertTrue((boolean)mandatoryMarker.isDisabled());
        ridget.setSelection(Collections.EMPTY_LIST);
        MultipleChoiceRidgetTest.assertFalse((boolean)mandatoryMarker.isDisabled());
        RuntimeException expectedEx = null;
        try {
            ridget.setSelection(Arrays.asList(new Object()));
        }
        catch (RuntimeException ex) {
            expectedEx = ex;
        }
        MultipleChoiceRidgetTest.assertNotNull((String)"IllegalArgumentException expected", (Object)expectedEx);
        MultipleChoiceRidgetTest.assertFalse((boolean)mandatoryMarker.isDisabled());
    }

    @Override
    public void testIsDisableMandatoryMarker() {
        IMultipleChoiceRidget ridget = this.getRidget();
        this.optionProvider.setSelectedOptions(null);
        ridget.updateFromModel();
        MultipleChoiceRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
        ArrayList<String> newSelection = new ArrayList<String>();
        newSelection.add(this.optionProvider.getOptions().get(1));
        ridget.setSelection(newSelection);
        MultipleChoiceRidgetTest.assertTrue((boolean)ridget.isDisableMandatoryMarker());
        ridget.setSelection(null);
        MultipleChoiceRidgetTest.assertFalse((boolean)ridget.isDisableMandatoryMarker());
    }

    public void testColorsAreAppliedToChildren() {
        Shell shell = this.getShell();
        ChoiceComposite control = new ChoiceComposite((Composite)shell, 0, true);
        Color colorRed = shell.getDisplay().getSystemColor(3);
        Color colorGreen = shell.getDisplay().getSystemColor(5);
        control.setForeground(colorGreen);
        control.setBackground(colorRed);
        this.getRidget().setUIControl((Object)control);
        Control[] children = control.getChildren();
        MultipleChoiceRidgetTest.assertTrue((children.length > 0 ? 1 : 0) != 0);
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            MultipleChoiceRidgetTest.assertEquals((String)("wrong foreground on " + child), (Object)colorGreen, (Object)child.getForeground());
            MultipleChoiceRidgetTest.assertEquals((String)("wrong background on " + child), (Object)colorRed, (Object)child.getBackground());
            ++n2;
        }
    }

    public void testEnablementIsAppliedToChildren() {
        Shell shell = this.getShell();
        ChoiceComposite control = new ChoiceComposite((Composite)shell, 0, true);
        MultipleChoiceRidgetTest.assertTrue((boolean)control.isEnabled());
        this.getRidget().setEnabled(false);
        this.getRidget().setUIControl((Object)control);
        MultipleChoiceRidgetTest.assertFalse((boolean)control.isEnabled());
        Control[] children = control.getChildren();
        MultipleChoiceRidgetTest.assertTrue((children.length > 0 ? 1 : 0) != 0);
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            MultipleChoiceRidgetTest.assertFalse((String)("control should be disabled: " + child), (boolean)child.isEnabled());
            ++n2;
        }
    }

    public void testBindToModelWithObservables() {
        IMultipleChoiceRidget ridget = this.getRidget();
        try {
            ridget.bindToModel(null, PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.optionProvider, (String)"selectedOptions"));
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.optionProvider, (String)"options"), null);
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testBindToModelWithBeans() {
        IMultipleChoiceRidget ridget = this.getRidget();
        try {
            ridget.bindToModel(null, "options", (Object)this.optionProvider, "selectedOptions");
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel((Object)this.optionProvider, null, (Object)this.optionProvider, "selectedOptions");
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel((Object)this.optionProvider, "options", null, "selectedOptions");
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel((Object)this.optionProvider, "options", (Object)this.optionProvider, null);
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testBindToModelWithOptionLabelList() {
        IMultipleChoiceRidget ridget = this.getRidget();
        try {
            ridget.bindToModel(null, this.optionProvider.getOptionLabels(), (Object)this.optionProvider, "selectedOptions");
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(this.optionProvider.getOptions(), null, (Object)this.optionProvider, "selectedOptions");
            this.ok();
        }
        catch (RuntimeException runtimeException) {
            MultipleChoiceRidgetTest.fail();
        }
        try {
            ridget.bindToModel(this.optionProvider.getOptions(), new ArrayList(), (Object)this.optionProvider, "selectedOptions");
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(this.optionProvider.getOptions(), this.optionProvider.getOptionLabels(), null, "selectedOptions");
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        try {
            ridget.bindToModel(this.optionProvider.getOptions(), this.optionProvider.getOptionLabels(), (Object)this.optionProvider, null);
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
    }

    public void testOutputCannotBeChangedFromUI() {
        IMultipleChoiceRidget ridget = this.getRidget();
        Button button1 = (Button)this.getWidget().getChildren()[0];
        Button button2 = (Button)this.getWidget().getChildren()[1];
        Button button3 = (Button)this.getWidget().getChildren()[2];
        MultipleChoiceRidgetTest.assertTrue((boolean)button1.getSelection());
        MultipleChoiceRidgetTest.assertTrue((boolean)button2.getSelection());
        MultipleChoiceRidgetTest.assertFalse((boolean)button3.getSelection());
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)ridget.getSelection().size());
        MultipleChoiceRidgetTest.assertTrue((boolean)ridget.getSelection().contains("Option A"));
        MultipleChoiceRidgetTest.assertTrue((boolean)ridget.getSelection().contains("Option B"));
        ridget.setOutputOnly(true);
        button1.setFocus();
        UITestHelper.sendString((Display)button1.getDisplay(), (String)" ");
        button3.setFocus();
        UITestHelper.sendString((Display)button3.getDisplay(), (String)" ");
        MultipleChoiceRidgetTest.assertTrue((boolean)button1.getSelection());
        MultipleChoiceRidgetTest.assertTrue((boolean)button2.getSelection());
        MultipleChoiceRidgetTest.assertFalse((boolean)button3.getSelection());
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)ridget.getSelection().size());
        MultipleChoiceRidgetTest.assertTrue((boolean)ridget.getSelection().contains("Option A"));
        MultipleChoiceRidgetTest.assertTrue((boolean)ridget.getSelection().contains("Option B"));
        ridget.setOutputOnly(false);
        button1.setFocus();
        UITestHelper.sendString((Display)button1.getDisplay(), (String)" ");
        button3.setFocus();
        UITestHelper.sendString((Display)button3.getDisplay(), (String)" ");
        MultipleChoiceRidgetTest.assertFalse((boolean)button1.getSelection());
        MultipleChoiceRidgetTest.assertTrue((boolean)button2.getSelection());
        MultipleChoiceRidgetTest.assertTrue((boolean)button3.getSelection());
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)ridget.getSelection().size());
        MultipleChoiceRidgetTest.assertTrue((boolean)ridget.getSelection().contains("Option B"));
        MultipleChoiceRidgetTest.assertTrue((boolean)ridget.getSelection().contains("Option C"));
    }

    public void testDisabledRidgetDoesNotCheckControlOnRidgetSelection() {
        IMultipleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        ridget.setSelection(Arrays.asList("Option A"));
        MultipleChoiceRidgetTest.assertEquals((String)"Option A", (String)this.optionProvider.getSelectedOptions().get(0));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option A", ridget.getSelection().get(0));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option A", (Object)this.getSelectedControlValues(control).get(0));
        ridget.setEnabled(false);
        MultipleChoiceRidgetTest.assertEquals((String)"Option A", (String)this.optionProvider.getSelectedOptions().get(0));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option A", ridget.getSelection().get(0));
        if (MarkerSupport.isHideDisabledRidgetContent()) {
            MultipleChoiceRidgetTest.assertEquals((int)0, (int)this.getSelectionCount(control));
        } else {
            MultipleChoiceRidgetTest.assertEquals((Object)"Option A", (Object)this.getSelectedControlValues(control).get(0));
        }
        ridget.setSelection(Arrays.asList("Option B"));
        MultipleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.optionProvider.getSelectedOptions().get(0));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option B", ridget.getSelection().get(0));
        if (MarkerSupport.isHideDisabledRidgetContent()) {
            MultipleChoiceRidgetTest.assertEquals((int)0, (int)this.getSelectionCount(control));
        } else {
            MultipleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)this.getSelectedControlValues(control).get(0));
        }
        ridget.setEnabled(true);
        MultipleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.optionProvider.getSelectedOptions().get(0));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option B", ridget.getSelection().get(0));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)this.getSelectedControlValues(control).get(0));
    }

    public void testDisabledRidgetDoesNotCheckControlOnModelSelection() {
        IMultipleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        ridget.setEnabled(false);
        this.optionProvider.setSelectedOptions(Arrays.asList("Option A"));
        ridget.updateFromModel();
        MultipleChoiceRidgetTest.assertEquals((String)"Option A", (String)this.optionProvider.getSelectedOptions().get(0));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option A", ridget.getSelection().get(0));
        if (MarkerSupport.isHideDisabledRidgetContent()) {
            MultipleChoiceRidgetTest.assertEquals((int)0, (int)this.getSelectionCount(control));
        } else {
            MultipleChoiceRidgetTest.assertEquals((Object)"Option A", (Object)this.getSelectedControlValues(control).get(0));
        }
        this.optionProvider.setSelectedOptions(Arrays.asList("Option B"));
        ridget.updateFromModel();
        MultipleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.optionProvider.getSelectedOptions().get(0));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option B", ridget.getSelection().get(0));
        if (MarkerSupport.isHideDisabledRidgetContent()) {
            MultipleChoiceRidgetTest.assertEquals((int)0, (int)this.getSelectionCount(control));
        } else {
            MultipleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)this.getSelectedControlValues(control).get(0));
        }
        ridget.setEnabled(true);
        MultipleChoiceRidgetTest.assertEquals((String)"Option B", (String)this.optionProvider.getSelectedOptions().get(0));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option B", ridget.getSelection().get(0));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)this.getSelectedControlValues(control).get(0));
    }

    public void testDisabledDoesNotFireSelected() {
        IMultipleChoiceRidget ridget = this.getRidget();
        ridget.setEnabled(true);
        ridget.setSelection(Arrays.asList("Option A", "Option B"));
        ridget.addPropertyChangeListener("selection", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MultipleChoiceRidgetTest.fail((String)("Unexpected property change event: " + evt));
            }
        });
        ridget.setEnabled(false);
        ridget.setEnabled(true);
    }

    public void testDisableAndClearOnBind() {
        IMultipleChoiceRidget ridget = this.getRidget();
        ChoiceComposite control = this.getWidget();
        ridget.setUIControl(null);
        ridget.setEnabled(false);
        ridget.setSelection(Arrays.asList("Option B"));
        ridget.setUIControl((Object)control);
        MultipleChoiceRidgetTest.assertFalse((boolean)control.isEnabled());
        if (MarkerSupport.isHideDisabledRidgetContent()) {
            MultipleChoiceRidgetTest.assertEquals((int)0, (int)this.getSelectionCount(control));
        } else {
            MultipleChoiceRidgetTest.assertEquals((int)1, (int)this.getSelectionCount(control));
            MultipleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)this.getSelectedControlValues(control).get(0));
        }
        ridget.setEnabled(true);
        MultipleChoiceRidgetTest.assertTrue((boolean)control.isEnabled());
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)this.getSelectionCount(control));
        MultipleChoiceRidgetTest.assertEquals((Object)"Option B", (Object)this.getSelectedControlValues(control).get(0));
    }

    public void testAddSelectionListener() {
        IMultipleChoiceRidget ridget = this.getRidget();
        try {
            ridget.addSelectionListener(null);
            MultipleChoiceRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        TestSelectionListener selectionListener = new TestSelectionListener();
        ridget.addSelectionListener((ISelectionListener)selectionListener);
        String element0 = this.optionProvider.getOptions().get(0);
        String element1 = this.optionProvider.getOptions().get(1);
        List<String> selection1 = Arrays.asList(element0);
        List<String> selection2 = Arrays.asList(element0, element1);
        ridget.setSelection(selection1);
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)ridget.getSelection().size());
        MultipleChoiceRidgetTest.assertSame((Object)element0, ridget.getSelection().get(0));
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)this.optionProvider.getSelectedOptions().size());
        MultipleChoiceRidgetTest.assertSame((Object)element0, (Object)this.optionProvider.getSelectedOptions().get(0));
        MultipleChoiceRidgetTest.assertEquals((int)1, (int)selectionListener.getCount());
        ridget.setSelection(selection2);
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)ridget.getSelection().size());
        MultipleChoiceRidgetTest.assertSame((Object)element0, ridget.getSelection().get(0));
        MultipleChoiceRidgetTest.assertSame((Object)element1, ridget.getSelection().get(1));
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)this.optionProvider.getSelectedOptions().size());
        MultipleChoiceRidgetTest.assertSame((Object)element0, (Object)this.optionProvider.getSelectedOptions().get(0));
        MultipleChoiceRidgetTest.assertSame((Object)element1, (Object)this.optionProvider.getSelectedOptions().get(1));
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
        ridget.removeSelectionListener((ISelectionListener)selectionListener);
        ridget.setSelection(null);
        MultipleChoiceRidgetTest.assertEquals((int)0, (int)ridget.getSelection().size());
        MultipleChoiceRidgetTest.assertEquals((int)0, (int)this.optionProvider.getSelectedOptions().size());
        MultipleChoiceRidgetTest.assertEquals((int)2, (int)selectionListener.getCount());
    }

    private static List<PropertyChangeEvent> newEventCatchingList(IRidget ridget, String eventName) {
        final ArrayList<PropertyChangeEvent> events = new ArrayList<PropertyChangeEvent>();
        ridget.addPropertyChangeListener(eventName, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                events.add(evt);
            }
        });
        return events;
    }

    private void assertEquals(String message, PropertyChangeEvent evt, String name, Object oldValue, Object newValue) {
        MultipleChoiceRidgetTest.assertEquals((String)(String.valueOf(message) + " / event name"), (String)evt.getPropertyName(), (String)name);
        MultipleChoiceRidgetTest.assertEquals((String)(String.valueOf(message) + " / event old Value"), (Object)evt.getOldValue(), (Object)oldValue);
        MultipleChoiceRidgetTest.assertEquals((String)(String.valueOf(message) + " / event new value"), (Object)evt.getNewValue(), (Object)newValue);
    }

    private List<Object> getSelectedControlValues(ChoiceComposite control) {
        ArrayList<Object> result = new ArrayList<Object>();
        Control[] controlArray = control.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            Button button = (Button)child;
            if (button.getSelection()) {
                result.add(button.getData());
            }
            ++n2;
        }
        return result;
    }

    private int getSelectionCount(ChoiceComposite control) {
        return this.getSelectedControlValues(control).size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OptionProvider {
        private List<String> options = new ArrayList<String>(Arrays.asList("Option A", "Option B", "Option C", "Option D", "Option E", "Option F"));
        private List<String> optionLabels = new ArrayList<String>(Arrays.asList("Option label A", "Option label B", "Option label C", "Option label D", "Option label E", "Option label F"));
        private List<String> selectedOptions = Arrays.asList(this.options.get(0), this.options.get(1));

        private OptionProvider() {
        }

        public List<String> getOptions() {
            return this.options;
        }

        public List<String> getSelectedOptions() {
            return this.selectedOptions;
        }

        public void setOptions(List<String> options) {
            this.options = new ArrayList<String>(options);
            this.optionLabels = null;
            this.selectedOptions = new ArrayList<String>();
        }

        public void setSelectedOptions(List<String> selectedOptions) {
            this.selectedOptions = selectedOptions;
        }

        public List<String> getOptionLabels() {
            return this.optionLabels;
        }

        public void remove(int index) {
            this.options.remove(index);
            if (this.optionLabels != null) {
                this.optionLabels.remove(index);
            }
        }
    }

    private static final class TestPropertyChangeListener
    implements PropertyChangeListener {
        private int eventCounter = 0;

        private TestPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ++this.eventCounter;
        }
    }
}

