/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.swt.BorderMarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.swt.BorderControlDecoration;
import org.eclipse.riena.ui.swt.lnf.ColorLnfResource;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class BorderMarkerSupportTest
extends TestCase {
    private Display display;
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
    }

    protected void tearDown() {
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    public void testCreateErrorDecoration() {
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        DefaultRealm realm = new DefaultRealm();
        try {
            Text text = new Text((Composite)this.shell, 0);
            TextRidget ridget = new TextRidget();
            ridget.setUIControl((Object)text);
            BorderMarkerSupport support = new BorderMarkerSupport((IBasicMarkableRidget)ridget, null);
            LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
            BorderControlDecoration deco = (BorderControlDecoration)ReflectionUtils.invokeHidden((Object)support, (String)"createErrorDecoration", (Object[])new Object[]{text});
            BorderMarkerSupportTest.assertEquals((int)3, (int)deco.getBorderWidth());
            BorderMarkerSupportTest.assertNotNull((Object)deco.getBorderColor());
            LnfManager.setLnf((RienaDefaultLnf)new MyNonsenseLnf());
            deco = (BorderControlDecoration)ReflectionUtils.invokeHidden((Object)support, (String)"createErrorDecoration", (Object[])new Object[]{text});
            BorderMarkerSupportTest.assertEquals((int)1, (int)deco.getBorderWidth());
            BorderMarkerSupportTest.assertNull((Object)deco.getBorderColor());
            support = null;
            SwtUtilities.disposeWidget((Widget)text);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
            realm.dispose();
        }
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        protected void initColorDefaults() {
            this.getResourceTable().put("errorMarker.borderColor", new ColorLnfResource(0, 250, 0));
        }

        protected void initSettingsDefaults() {
            this.getSettingTable().put("errorMarker.borderWidth", 3);
        }
    }

    private static class MyNonsenseLnf
    extends RienaDefaultLnf {
        private MyNonsenseLnf() {
        }

        protected void initSettingsDefaults() {
            this.getResourceTable().clear();
        }

        protected void initImageDefaults() {
            this.getSettingTable().clear();
        }
    }
}

