/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MarkerSupportTest
extends RienaTestCase {
    private static final String HIDE_DISABLED_RIDGET_CONTENT = "HIDE_DISABLED_RIDGET_CONTENT";
    private Display display;
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.display = Display.getDefault();
        this.shell = new Shell(this.display);
    }

    protected void tearDown() {
        SwtUtilities.disposeWidget((Widget)this.shell);
        this.display = null;
    }

    public void testHideDisabledRidgetContentSystemProperty() throws IOException {
        System.clearProperty(HIDE_DISABLED_RIDGET_CONTENT);
        MarkerSupportTest.assertFalse((boolean)MarkerSupportTest.getHideDisabledRidgetContent());
        System.setProperty(HIDE_DISABLED_RIDGET_CONTENT, Boolean.FALSE.toString());
        MarkerSupportTest.assertFalse((boolean)MarkerSupportTest.getHideDisabledRidgetContent());
        System.setProperty(HIDE_DISABLED_RIDGET_CONTENT, Boolean.TRUE.toString());
        MarkerSupportTest.assertTrue((boolean)MarkerSupportTest.getHideDisabledRidgetContent());
    }

    public void testCreateErrorDecoration() throws Exception {
        RienaDefaultLnf originalLnf = LnfManager.getLnf();
        DefaultRealm realm = new DefaultRealm();
        try {
            Text text = new Text((Composite)this.shell, 0);
            TextRidget ridget = new TextRidget();
            ridget.setUIControl((Object)text);
            MarkerSupport support = new MarkerSupport((IBasicMarkableRidget)ridget, null);
            LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
            ControlDecoration deco = (ControlDecoration)ReflectionUtils.invokeHidden((Object)support, (String)"createErrorDecoration", (Object[])new Object[]{text});
            MarkerSupportTest.assertEquals((int)100, (int)deco.getMarginWidth());
            MarkerSupportTest.assertNotNull((Object)deco.getImage());
            LnfManager.setLnf((RienaDefaultLnf)new MyNonsenseLnf());
            deco = (ControlDecoration)ReflectionUtils.invokeHidden((Object)support, (String)"createErrorDecoration", (Object[])new Object[]{text});
            MarkerSupportTest.assertEquals((int)1, (int)deco.getMarginWidth());
            MarkerSupportTest.assertNotNull((Object)deco.getImage());
            support = null;
            SwtUtilities.disposeWidget((Widget)text);
        }
        finally {
            LnfManager.setLnf((RienaDefaultLnf)originalLnf);
            realm.dispose();
        }
    }

    private static boolean getHideDisabledRidgetContent() throws IOException {
        MarkSupportClassLoader freshLoader = new MarkSupportClassLoader();
        Class<?> markerSupportClass = freshLoader.getFreshMarkSupportClass();
        return (Boolean)ReflectionUtils.getHidden(markerSupportClass, (String)HIDE_DISABLED_RIDGET_CONTENT);
    }

    public void testDisabledMarker() throws Exception {
        DefaultRealm realm = new DefaultRealm();
        try {
            Label control = new Label((Composite)this.shell, 0);
            LabelRidget ridget = new LabelRidget();
            ridget.setUIControl((Object)control);
            BasicMarkerSupport msup = (BasicMarkerSupport)ReflectionUtils.invokeHidden((Object)ridget, (String)"createMarkerSupport", (Object[])new Object[0]);
            Object visualizer = ReflectionUtils.invokeHidden((Object)msup, (String)"getDisabledMarkerVisualizer", null);
            MarkerSupportTest.assertNotNull((Object)visualizer);
            ridget.setEnabled(false);
            MarkerSupportTest.assertEquals((int)1, (int)control.getListeners(9).length);
            ridget.setEnabled(true);
            MarkerSupportTest.assertEquals((int)0, (int)control.getListeners(9).length);
        }
        finally {
            realm.dispose();
        }
    }

    public void testClearAllMarkes() {
        DefaultRealm realm = new DefaultRealm();
        try {
            Text control = new Text((Composite)this.shell, 0);
            this.shell.setVisible(true);
            Color background = control.getBackground();
            Color foreground = control.getForeground();
            TextRidget ridget = new TextRidget();
            ridget.setUIControl((Object)control);
            MyMarkerSupport markerSupport = new MyMarkerSupport();
            markerSupport.init((IBasicMarkableRidget)ridget, null);
            ridget.addMarker((IMarker)new MandatoryMarker());
            markerSupport.updateMarkers();
            MarkerSupportTest.assertFalse((boolean)background.equals((Object)control.getBackground()));
            markerSupport.clearAllMarkers((Control)control);
            MarkerSupportTest.assertEquals((Object)background, (Object)control.getBackground());
            ridget.addMarker((IMarker)new OutputMarker());
            markerSupport.updateMarkers();
            MarkerSupportTest.assertFalse((boolean)background.equals((Object)control.getBackground()));
            markerSupport.clearAllMarkers((Control)control);
            MarkerSupportTest.assertEquals((Object)background, (Object)control.getBackground());
            ridget.addMarker((IMarker)new NegativeMarker());
            markerSupport.updateMarkers();
            MarkerSupportTest.assertFalse((boolean)foreground.equals((Object)control.getForeground()));
            markerSupport.clearAllMarkers((Control)control);
            MarkerSupportTest.assertEquals((Object)foreground, (Object)control.getForeground());
            ridget.addMarker((IMarker)new ErrorMarker());
            markerSupport.updateMarkers();
            ControlDecoration errorDecoration = (ControlDecoration)ReflectionUtils.getHidden((Object)((Object)markerSupport), (String)"errorDecoration");
            MarkerSupportTest.assertNotNull((Object)errorDecoration);
            MarkerSupportTest.assertTrue((boolean)errorDecoration.isVisible());
            markerSupport.clearAllMarkers((Control)control);
            MarkerSupportTest.assertFalse((boolean)errorDecoration.isVisible());
        }
        finally {
            realm.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MarkSupportClassLoader
    extends ClassLoader {
        public MarkSupportClassLoader() {
            super(MarkSupportClassLoader.class.getClassLoader());
        }

        public Class<?> getFreshMarkSupportClass() throws IOException {
            String resource = String.valueOf(MarkerSupport.class.getName().replace('.', '/')) + ".class";
            URL classURL = MarkerSupportTest.class.getClassLoader().getResource(resource);
            InputStream is = classURL.openStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int ch = -1;
            while ((ch = is.read()) != -1) {
                baos.write(ch);
            }
            byte[] bytes = baos.toByteArray();
            Class<?> cl = super.defineClass(MarkerSupport.class.getName(), bytes, 0, bytes.length);
            this.resolveClass(cl);
            return cl;
        }
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        protected void initSettingsDefaults() {
            this.getSettingTable().put("errorMarker.margin", 100);
            this.getSettingTable().put("errorMarker.horizontalPosition", 131072);
            this.getSettingTable().put("errorMarker.verticalPosition", 1024);
        }
    }

    private static class MyMarkerSupport
    extends MarkerSupport {
        private MyMarkerSupport() {
        }

        public void clearAllMarkers(Control control) {
            super.clearAllMarkers(control);
        }
    }

    private static class MyNonsenseLnf
    extends RienaDefaultLnf {
        private MyNonsenseLnf() {
        }

        protected void initSettingsDefaults() {
            this.getSettingTable().clear();
        }

        protected void initImageDefaults() {
            this.getResourceTable().clear();
        }
    }
}

