/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt.views;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;
import org.eclipse.riena.ui.ridgets.swt.views.AbstractDialogView;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class DialogViewTest
extends RienaTestCase {
    private DialogViewStub dialogView;
    private AbstractWindowController dialogViewController;
    private Shell shell;
    private static final String BINDING_ID_FIRSTNAME = "txtFirstName";
    private static final String BINDING_ID_LASTNAME = "txtLastName";
    private static final String VALUE_FIRSTNAME = "Peter";
    private static final String VALUE_LASTNAME = "Lustig";

    protected void setUp() throws Exception {
        this.shell = new Shell();
        this.createDefaultRealm();
        this.dialogViewController = new AbstractWindowControllerStub();
        this.dialogView = new DialogViewStub((Composite)this.shell);
    }

    protected void tearDown() throws Exception {
        this.dialogView.close();
        this.shell.close();
        SwtUtilities.disposeWidget((Widget)this.shell);
    }

    private void createDefaultRealm() {
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        DialogViewTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
    }

    public void testCreateController() throws Exception {
        DialogViewTest.assertNotNull((Object)this.dialogView.getController());
        DialogViewTest.assertEquals((Object)this.dialogViewController, (Object)this.dialogView.getController());
    }

    public void testBinding() throws Exception {
        this.shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                DialogViewTest.assertNotNull((Object)DialogViewTest.this.dialogView.getTextFirstName());
                DialogViewTest.assertNotNull((Object)DialogViewTest.this.dialogView.getTextLastName());
                DialogViewTest.assertEquals((String)DialogViewTest.this.dialogView.getTextFirstName(), (String)DialogViewTest.VALUE_FIRSTNAME);
                DialogViewTest.assertEquals((String)DialogViewTest.this.dialogView.getTextLastName(), (String)DialogViewTest.VALUE_LASTNAME);
                DialogViewTest.this.dialogView.close();
            }
        });
        this.dialogView.open();
    }

    private class AbstractWindowControllerStub
    extends AbstractWindowController {
        private Person person = new Person("Lustig", "Peter");

        private AbstractWindowControllerStub() {
        }

        public void configureRidgets() {
            super.configureRidgets();
            ITextRidget txtFirstName = (ITextRidget)this.getRidget(DialogViewTest.BINDING_ID_FIRSTNAME);
            txtFirstName.bindToModel((Object)this.person, "firstname");
            txtFirstName.updateFromModel();
            ITextRidget txtLastName = (ITextRidget)this.getRidget(DialogViewTest.BINDING_ID_LASTNAME);
            txtLastName.bindToModel((Object)this.person, "lastname");
            txtLastName.updateFromModel();
        }
    }

    private class DialogViewStub
    extends AbstractDialogView {
        private Text txtFirstName;
        private Text txtLastName;

        public DialogViewStub(Composite parent) {
            super(parent.getShell());
        }

        protected Control buildView(Composite parent) {
            this.txtFirstName = UIControlsFactory.createText((Composite)parent);
            this.addUIControl(this.txtFirstName, DialogViewTest.BINDING_ID_FIRSTNAME);
            this.txtLastName = UIControlsFactory.createText((Composite)parent, (int)0, (String)DialogViewTest.BINDING_ID_LASTNAME);
            return parent;
        }

        protected AbstractWindowController createController() {
            return DialogViewTest.this.dialogViewController;
        }

        public String getTextFirstName() {
            return this.txtFirstName.getText();
        }

        public String getTextLastName() {
            return this.txtLastName.getText();
        }
    }
}

