/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.uibinding;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.LabelRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.IMappingCondition;
import org.eclipse.riena.ui.ridgets.uibinding.InjectBindingManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class InjectBindingManagerTest
extends TestCase {
    private static final String BINDING_PROPERTY = "binding_property";
    private IBindingManager manager;
    private RidgetContainer ridgetContainer;
    private Shell shell;
    private DefaultRealm realm;

    protected void setUp() throws Exception {
        super.setUp();
        this.realm = new DefaultRealm();
        this.manager = new InjectBindingManager((IBindingPropertyLocator)new BindingPropertyLocator(), (IControlRidgetMapper)new ControlRidgetMapper());
        this.ridgetContainer = new RidgetContainer();
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.manager = null;
        this.ridgetContainer = null;
        SwtUtilities.disposeWidget((Widget)this.shell);
        this.realm.dispose();
        this.realm = null;
    }

    public void testInjectRidget() throws Exception {
        Label label1 = new Label((Composite)this.shell, 0);
        IRidget ridget = (IRidget)ReflectionUtils.invokeHidden((Object)this.manager, (String)"createRidget", (Object[])new Object[]{label1});
        ReflectionUtils.invokeHidden((Object)this.manager, (String)"injectRidget", (Object[])new Object[]{this.ridgetContainer, "label1", ridget});
        InjectBindingManagerTest.assertNotNull((Object)this.ridgetContainer.getLabel1());
        InjectBindingManagerTest.assertNull((Object)this.ridgetContainer.getLabel1().getUIControl());
    }

    public void testGetRidget() throws Exception {
        Label label1 = new Label((Composite)this.shell, 0);
        IRidget ridget = (IRidget)ReflectionUtils.invokeHidden((Object)this.manager, (String)"createRidget", (Object[])new Object[]{label1});
        ReflectionUtils.invokeHidden((Object)this.manager, (String)"injectRidget", (Object[])new Object[]{this.ridgetContainer, "label1", ridget});
        IRidget ridget1 = (IRidget)ReflectionUtils.invokeHidden((Object)this.manager, (String)"getRidget", (Object[])new Object[]{"label1", this.ridgetContainer});
        InjectBindingManagerTest.assertSame((Object)ridget, (Object)ridget1);
    }

    public void testCreateMethodeNameProperty() {
        String prop = (String)ReflectionUtils.invokeHidden((Object)this.manager, (String)"createMethodeNameProperty", (Object[])new Object[]{""});
        InjectBindingManagerTest.assertEquals((String)"", (String)prop);
        prop = (String)ReflectionUtils.invokeHidden((Object)this.manager, (String)"createMethodeNameProperty", (Object[])new Object[]{"hello"});
        InjectBindingManagerTest.assertEquals((String)"hello", (String)prop);
        prop = (String)ReflectionUtils.invokeHidden((Object)this.manager, (String)"createMethodeNameProperty", (Object[])new Object[]{"hello.world"});
        InjectBindingManagerTest.assertEquals((String)"helloWorld", (String)prop);
        prop = (String)ReflectionUtils.invokeHidden((Object)this.manager, (String)"createMethodeNameProperty", (Object[])new Object[]{"ab.cd.ef."});
        InjectBindingManagerTest.assertEquals((String)"abCdEf", (String)prop);
        prop = (String)ReflectionUtils.invokeHidden((Object)this.manager, (String)"createMethodeNameProperty", (Object[])new Object[]{".ab.cd.ef."});
        InjectBindingManagerTest.assertEquals((String)"AbCdEf", (String)prop);
    }

    private static final class BindingPropertyLocator
    implements IBindingPropertyLocator {
        private BindingPropertyLocator() {
        }

        public String locateBindingProperty(Object uiControl) {
            Control control = (Control)uiControl;
            return (String)control.getData(InjectBindingManagerTest.BINDING_PROPERTY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ControlRidgetMapper
    implements IControlRidgetMapper<Object> {
        private ControlRidgetMapper() {
        }

        public void addMapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz) {
        }

        public void addMapping(Class<? extends Object> controlClazz, Class<? extends IRidget> ridgetClazz, IMappingCondition condition) {
        }

        public Class<? extends IRidget> getRidgetClass(Class<? extends Object> controlClazz) {
            return LabelRidget.class;
        }

        public Class<? extends IRidget> getRidgetClass(Object control) {
            return LabelRidget.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RidgetContainer
    implements IRidgetContainer {
        private ILabelRidget label1;
        private ILabelRidget label2;
        private Map<String, IRidget> ridgets = new HashMap<String, IRidget>();

        public void addRidget(String id, IRidget ridget) {
            this.ridgets.put(id, ridget);
        }

        public IRidget getRidget(String id) {
            return this.ridgets.get(id);
        }

        public Collection<? extends IRidget> getRidgets() {
            return this.ridgets.values();
        }

        public ILabelRidget getLabel1() {
            return this.label1;
        }

        public void setLabel1(ILabelRidget label1) {
            this.label1 = label1;
        }

        public ILabelRidget getLabel2() {
            return this.label2;
        }

        public void setLabel2(ILabelRidget label2) {
            this.label2 = label2;
        }

        public void configureRidgets() {
        }

        public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
            return (R)this.getRidget(id);
        }
    }
}

