/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import junit.framework.TestCase;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.swt.RienaWindowRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class RienaWindowRendererTest
extends TestCase {
    private RienaWindowRenderer renderer;
    private Shell shell;
    private MyDialog dialog;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.dialog = new MyDialog(this.shell);
        this.renderer = new RienaWindowRenderer((Window)this.dialog);
        LnfManager.setLnf((RienaDefaultLnf)new MyLnf());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.renderer = null;
        SwtUtilities.disposeWidget((Widget)this.shell);
        this.dialog = null;
    }

    public void testComputeShellStyle() {
        this.dialog.setShellStyle(3296);
        int ret = this.renderer.computeShellStyle();
        RienaWindowRendererTest.assertEquals((int)64, (int)(ret & 0x40));
        RienaWindowRendererTest.assertEquals((int)128, (int)(ret & 0x80));
        RienaWindowRendererTest.assertEquals((int)1024, (int)(ret & 0x400));
    }

    private class MyDialog
    extends Dialog {
        public MyDialog(Shell shell) {
            super(shell);
        }

        public void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle);
        }
    }

    private class MyLnf
    extends RienaDefaultLnf {
        private MyLnf() {
        }

        protected void initSettingsDefaults() {
            super.initSettingsDefaults();
            this.getSettingTable().put("Dialog.hideOsBorder", Boolean.TRUE);
        }
    }
}

