/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.injector.IStoppable;
import org.eclipse.riena.core.injector.InjectionFailure;
import org.eclipse.riena.core.injector.service.ServiceDescriptor;
import org.eclipse.riena.internal.core.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceInjector
implements IStoppable {
    public static final String DEFAULT_BIND_METHOD_NAME = "bind";
    public static final String DEFAULT_UNBIND_METHOD_NAME = "unbind";
    private final ServiceDescriptor serviceDesc;
    private final Object target;
    private BundleContext context;
    private final String filter;
    private String bindMethodName;
    private List<Method> bindMethodProspects;
    private String unbindMethodName;
    private List<Method> unbindMethodProspects;
    private State state = State.INITIAL;
    private ServiceListener serviceListener;
    private BundleListener bundleListener;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ServiceInjector.class);

    ServiceInjector(ServiceDescriptor serviceDesc, Object target) {
        this.serviceDesc = serviceDesc;
        this.target = target;
        StringBuilder bob = new StringBuilder().append("(").append("objectClass").append("=").append(serviceDesc.getServiceClazz()).append(")");
        if (serviceDesc.getFilter() != null) {
            bob.insert(0, "(&");
            bob.append(serviceDesc.getFilter());
            bob.append(')');
        }
        this.filter = bob.toString();
    }

    public ServiceInjector andStart(BundleContext context) {
        Assert.isNotNull((Object)context, (String)"Bundle context must be not null.");
        Assert.isTrue((this.state == State.INITIAL ? 1 : 0) != 0, (String)"ServiceInjector already started or stopped!");
        this.state = State.STARTING;
        this.context = context;
        if (this.bindMethodName == null) {
            this.bindMethodName = DEFAULT_BIND_METHOD_NAME;
        }
        this.bindMethodProspects = this.collectMethods("Bind method", this.bindMethodName);
        if (this.unbindMethodName == null) {
            this.unbindMethodName = DEFAULT_UNBIND_METHOD_NAME;
        }
        this.unbindMethodProspects = this.collectMethods("Unbind method", this.unbindMethodName);
        this.doStart();
        this.registerServiceListener();
        this.registerBundleListener();
        this.state = State.STARTED;
        return this;
    }

    protected abstract void doStart();

    @Override
    public synchronized void stop() {
        if (this.state != State.STARTED) {
            return;
        }
        this.state = State.STOPPING;
        this.unregisterBundleListener();
        this.unregisterServiceListener();
        this.doStop();
        this.bindMethodProspects = null;
        this.unbindMethodProspects = null;
        this.state = State.STOPPED;
    }

    protected abstract void doStop();

    public ServiceInjector bind(String bindMethodName) {
        Assert.isTrue((this.state == State.INITIAL ? 1 : 0) != 0, (String)"ServiceInjector already started or stopped!");
        this.bindMethodName = bindMethodName;
        return this;
    }

    public synchronized ServiceInjector unbind(String unbindMethodName) {
        Assert.isTrue((this.state == State.INITIAL ? 1 : 0) != 0, (String)"ServiceInjector already started or stopped!");
        this.unbindMethodName = unbindMethodName;
        return this;
    }

    protected void registerServiceListener() {
        if (this.serviceListener == null) {
            this.serviceListener = new InjectorServiceListener();
        }
        try {
            this.context.addServiceListener(this.serviceListener, this.filter);
        }
        catch (InvalidSyntaxException e) {
            throw new InjectionFailure("The specified filter has syntax errors.", e);
        }
    }

    private void unregisterServiceListener() {
        if (this.serviceListener == null) {
            return;
        }
        this.context.removeServiceListener(this.serviceListener);
    }

    private void registerBundleListener() {
        if (this.bundleListener == null) {
            this.bundleListener = new InjectorBundleListener();
        }
        this.context.addBundleListener(this.bundleListener);
    }

    private void unregisterBundleListener() {
        if (this.bundleListener != null) {
            this.context.removeBundleListener(this.bundleListener);
            this.bundleListener = null;
        }
    }

    private List<Method> collectMethods(String message, String methodName) {
        Method[] methods;
        ArrayList<Method> prospects = new ArrayList<Method>();
        Method[] methodArray = methods = this.target.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && method.getParameterTypes().length == 1) {
                prospects.add(method);
            }
            ++n2;
        }
        if (prospects.size() != 0) {
            return prospects;
        }
        throw new InjectionFailure(String.valueOf(message) + " '" + methodName + "' does not exist in target class '" + this.target.getClass().getName());
    }

    protected void handleEvent(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.doBind(event.getServiceReference());
                break;
            }
            case 4: {
                this.doUnbind(event.getServiceReference());
                break;
            }
        }
    }

    protected abstract void doBind(ServiceReference var1);

    protected abstract void doUnbind(ServiceReference var1);

    protected ServiceReference[] getServiceReferences() {
        try {
            return this.context.getServiceReferences(this.serviceDesc.getServiceClazz(), this.filter);
        }
        catch (InvalidSyntaxException e) {
            throw new InjectionFailure("The specified filter has syntax errors.", e);
        }
    }

    protected void invokeBindMethod(ServiceReference serviceRef) {
        if (serviceRef == null) {
            return;
        }
        Object service = this.context.getService(serviceRef);
        if (service == null) {
            return;
        }
        this.invokeMethod(this.bindMethodProspects, service);
    }

    protected void invokeUnbindMethod(ServiceReference serviceRef) {
        if (serviceRef == null) {
            return;
        }
        Object service = this.context.getService(serviceRef);
        if (service == null) {
            return;
        }
        this.invokeMethod(this.unbindMethodProspects, service);
        this.context.ungetService(serviceRef);
        this.context.ungetService(serviceRef);
    }

    private void invokeMethod(List<Method> methods, Object service) {
        assert (service != null);
        Method method = this.findMatchingMethod(methods, service);
        if (method == null) {
            return;
        }
        this.invoke(method, service);
    }

    private Method findMatchingMethod(List<Method> methods, Object service) {
        assert (methods != null);
        assert (service != null);
        Class<?> parameterType = service.getClass();
        ArrayList<Method> targetedMethods = new ArrayList<Method>(1);
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!parameterTypes[0].isAssignableFrom(parameterType)) continue;
            targetedMethods.add(method);
        }
        if (targetedMethods.size() == 1) {
            return (Method)targetedMethods.get(0);
        }
        if (targetedMethods.isEmpty()) {
            LOGGER.log(1, "Could not find a matching Bind/Unbind method from '" + methods + "' for target class '" + this.target.getClass().getName() + "'.");
            return null;
        }
        Class<?> superType = parameterType;
        while (superType != null) {
            for (Method method : targetedMethods) {
                if (method.getParameterTypes()[0].isAssignableFrom(superType)) continue;
                return method;
            }
            superType = superType.getSuperclass();
        }
        return (Method)targetedMethods.get(0);
    }

    private void invoke(Method method, Object service) {
        assert (method != null);
        assert (service != null);
        Throwable t = null;
        String cause = null;
        try {
            method.invoke(this.target, service);
        }
        catch (SecurityException e) {
            t = e;
            cause = "Security exception on invoking '";
        }
        catch (IllegalArgumentException e) {
            t = e;
            cause = "Illegal argument exception on invoking '";
        }
        catch (IllegalAccessException e) {
            t = e;
            cause = "Illegal access exception on invoking '";
        }
        catch (InvocationTargetException e) {
            t = e.getTargetException();
            cause = "Invocation target exception on invoking '";
        }
        if (t != null) {
            String message = String.valueOf(cause) + method + "' on '" + this.target.getClass().getName() + "'.";
            LOGGER.log(1, message, t);
            throw new InjectionFailure(message, t);
        }
    }

    class InjectorBundleListener
    implements SynchronousBundleListener {
        InjectorBundleListener() {
        }

        public void bundleChanged(BundleEvent event) {
            if (event.getBundle() != ServiceInjector.this.context.getBundle()) {
                return;
            }
            if (event.getType() == 256) {
                ServiceInjector.this.stop();
            }
        }
    }

    class InjectorServiceListener
    implements ServiceListener {
        InjectorServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            int eventType = event.getType();
            if (eventType == 1 || eventType == 4) {
                ServiceInjector.this.handleEvent(event);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

