/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.injector.extension;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.riena.core.injector.extension.ExtensionDescriptor;
import org.eclipse.riena.internal.core.injector.extension.InterfaceBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionMapper {
    private ExtensionMapper() {
        throw new IllegalStateException("Should never be invoked!");
    }

    public static <T> T[] map(boolean symbolReplace, ExtensionDescriptor extensionDesc, Class<T> componentType, boolean nonSpecific) {
        IExtensionRegistry extensionRegistry = RegistryFactory.getRegistry();
        ArrayList<Object> list = new ArrayList<Object>();
        boolean atLeastOneExtensionPointExists = false;
        for (String extensionPointId : extensionDesc.getExtensionPointId().compatibleIds()) {
            int n;
            int n2;
            IExtension[] iExtensionArray;
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(extensionPointId);
            if (extensionPoint == null) continue;
            atLeastOneExtensionPointExists = true;
            if (nonSpecific) {
                if (extensionDesc.isHomogeneous()) {
                    iExtensionArray = extensionPoint.getConfigurationElements();
                    n2 = iExtensionArray.length;
                    n = 0;
                    while (n < n2) {
                        IExtension element = iExtensionArray[n];
                        list.add(InterfaceBeanFactory.newInstance(symbolReplace, componentType, (IConfigurationElement)element));
                        ++n;
                    }
                    continue;
                }
                list.add(InterfaceBeanFactory.newInstance(symbolReplace, componentType, new Wrapper(extensionPoint)));
                continue;
            }
            iExtensionArray = extensionPoint.getExtensions();
            n2 = iExtensionArray.length;
            n = 0;
            while (n < n2) {
                IExtension extension = iExtensionArray[n];
                list.add(InterfaceBeanFactory.newInstance(symbolReplace, componentType, new Wrapper(extension)));
                ++n;
            }
        }
        if (!atLeastOneExtensionPointExists) {
            throw new IllegalArgumentException("Extension point " + extensionDesc.getExtensionPointId() + " does not exist");
        }
        return list.toArray((Object[])Array.newInstance(componentType, list.size()));
    }

    private static final class Wrapper
    implements IConfigurationElement {
        private final IExtensionPoint wrappedExtensionPoint;
        private final IExtension wrappedExtension;

        private Wrapper(IExtensionPoint extensionPoint) {
            Assert.isNotNull((Object)extensionPoint, (String)"wrappedExtensionPoint must not be null.");
            this.wrappedExtensionPoint = extensionPoint;
            this.wrappedExtension = null;
        }

        private Wrapper(IExtension extension) {
            Assert.isNotNull((Object)extension, (String)"extension must not be null.");
            this.wrappedExtension = extension;
            this.wrappedExtensionPoint = null;
        }

        public Object createExecutableExtension(String propertyName) throws CoreException {
            throw new UnsupportedOperationException("IExtension/Point does not support createExecutableExtension()");
        }

        public String getAttribute(String name) {
            return null;
        }

        public String getAttribute(String attrName, String locale) {
            return null;
        }

        public String getAttributeAsIs(String name) {
            return null;
        }

        public String[] getAttributeNames() {
            return new String[0];
        }

        public IConfigurationElement[] getChildren() {
            if (this.wrappedExtension != null) {
                return this.wrappedExtension.getConfigurationElements();
            }
            ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
            IExtension[] iExtensionArray = this.wrappedExtensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                elements.addAll(Arrays.asList(extension.getConfigurationElements()));
                ++n2;
            }
            return elements.toArray(new IConfigurationElement[elements.size()]);
        }

        public IConfigurationElement[] getChildren(String name) {
            IConfigurationElement[] configurationElements = this.wrappedExtension != null ? this.wrappedExtension.getConfigurationElements() : this.wrappedExtensionPoint.getConfigurationElements();
            ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>();
            IConfigurationElement[] iConfigurationElementArray = configurationElements;
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                if (configurationElement.getName().equals(name)) {
                    elements.add(configurationElement);
                }
                ++n2;
            }
            return elements.toArray(new IConfigurationElement[elements.size()]);
        }

        public IContributor getContributor() {
            return this.wrappedExtension != null ? this.wrappedExtension.getContributor() : this.wrappedExtensionPoint.getContributor();
        }

        public IExtension getDeclaringExtension() {
            throw new UnsupportedOperationException("IExtensionPoint does not support getDeclaringExtension()");
        }

        public String getName() {
            return this.wrappedExtension != null ? this.wrappedExtension.getLabel() : this.wrappedExtensionPoint.getLabel();
        }

        public String getNamespace() {
            return this.wrappedExtension != null ? this.wrappedExtension.getNamespace() : this.wrappedExtensionPoint.getNamespace();
        }

        public String getNamespaceIdentifier() {
            return this.wrappedExtension != null ? this.wrappedExtension.getNamespaceIdentifier() : this.wrappedExtensionPoint.getNamespaceIdentifier();
        }

        public Object getParent() {
            throw new UnsupportedOperationException("IExtensionPoint does not support getParent()");
        }

        public String getValue() {
            throw new UnsupportedOperationException("IExtensionPoint does not support getValue()");
        }

        public String getValue(String locale) {
            throw new UnsupportedOperationException("IExtensionPoint does not support getValue(String locale)");
        }

        public String getValueAsIs() {
            throw new UnsupportedOperationException("IExtensionPoint does not support getValueAsIs()");
        }

        public boolean isValid() {
            return this.wrappedExtension != null ? this.wrappedExtension.isValid() : this.wrappedExtensionPoint.isValid();
        }
    }
}

