/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.test;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionRegistryAnalyzer {
    private ExtensionRegistryAnalyzer() {
    }

    public static void dumpRegistry(String extensionPointPrefix) {
        ExtensionRegistryAnalyzer.dumpRegistry(extensionPointPrefix, Integer.MAX_VALUE);
    }

    public static void dumpRegistry(String extensionPointPrefix, int depth) {
        System.out.println("Registry:");
        System.out.println("=========");
        IExtensionRegistry extensionRegistry = RegistryFactory.getRegistry();
        if (extensionRegistry == null) {
            System.out.println("No extension registry available.");
            return;
        }
        IExtensionPoint[] extensionPoints = RegistryFactory.getRegistry().getExtensionPoints();
        Arrays.sort(extensionPoints, new Comparator<IExtensionPoint>(){

            @Override
            public int compare(IExtensionPoint ep1, IExtensionPoint ep2) {
                return ep1.getUniqueIdentifier().compareTo(ep2.getUniqueIdentifier());
            }
        });
        IExtensionPoint[] iExtensionPointArray = extensionPoints;
        int n = extensionPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionPoint extensionPoint = iExtensionPointArray[n2];
            if (extensionPointPrefix == null || extensionPoint.getUniqueIdentifier().startsWith(extensionPointPrefix)) {
                System.out.println(String.valueOf(extensionPoint.getUniqueIdentifier()) + ":");
                ExtensionRegistryAnalyzer.dumpExtensions(extensionPoint.getExtensions(), depth);
            }
            ++n2;
        }
    }

    private static void dumpExtensions(IExtension[] extensions, int depth) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            System.out.println(String.valueOf(ExtensionRegistryAnalyzer.indent(0)) + "uid=" + extension.getUniqueIdentifier() + " bundle=" + extension.getContributor().getName() + " ");
            ExtensionRegistryAnalyzer.dumpConfigurationElements(1, depth, extension.getConfigurationElements());
            ++n2;
        }
    }

    private static void dumpConfigurationElements(int level, int depth, IConfigurationElement[] elements) {
        if (elements.length == 0 || level == depth) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            System.out.println(String.valueOf(ExtensionRegistryAnalyzer.indent(level)) + "<" + element.getName() + " " + ExtensionRegistryAnalyzer.getAttributes(element) + "/>");
            ExtensionRegistryAnalyzer.dumpConfigurationElements(level + 1, depth, element.getChildren());
            ++n2;
        }
    }

    private static String indent(int level) {
        StringBuilder bob = new StringBuilder();
        int l = 0;
        while (l < level) {
            bob.append("   ");
            ++l;
        }
        bob.append(" - ");
        return bob.toString();
    }

    public static void print(Set<String> set) {
        for (String string : set) {
            System.out.println(string);
        }
    }

    public static Set<String> getRegistryPaths(String extensionPointPrefix) {
        HashSet<String> result = new HashSet<String>();
        IExtensionRegistry extensionRegistry = RegistryFactory.getRegistry();
        if (extensionRegistry != null) {
            IExtensionPoint[] extensionPoints;
            IExtensionPoint[] iExtensionPointArray = extensionPoints = extensionRegistry.getExtensionPoints();
            int n = extensionPoints.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionPoint extensionPoint = iExtensionPointArray[n2];
                if (extensionPointPrefix == null || extensionPoint.getUniqueIdentifier().startsWith(extensionPointPrefix)) {
                    String path = String.valueOf(extensionPoint.getUniqueIdentifier()) + ": ";
                    ExtensionRegistryAnalyzer.getExtensionsPaths(result, path, extensionPoint.getExtensions());
                }
                ++n2;
            }
        }
        return result;
    }

    private static void getExtensionsPaths(Set<String> result, String path, IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            String subPath = String.valueOf(path) + "uid=" + extension.getUniqueIdentifier() + " bundle=" + extension.getContributor().getName() + " ";
            ExtensionRegistryAnalyzer.getConfigurationElementsPaths(result, subPath, extension.getConfigurationElements());
            ++n2;
        }
    }

    private static void getConfigurationElementsPaths(Set<String> result, String path, IConfigurationElement[] elements) {
        if (elements.length == 0) {
            if (!result.add(path)) {
                System.err.println("Error while collecting registry paths. Adding " + path + " twice.");
            }
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String subPath = String.valueOf(path) + "<" + element.getName() + " " + ExtensionRegistryAnalyzer.getAttributes(element) + "/>";
            ExtensionRegistryAnalyzer.getConfigurationElementsPaths(result, subPath, element.getChildren());
            ++n2;
        }
    }

    private static String getAttributes(IConfigurationElement element) {
        StringBuilder bob = new StringBuilder();
        String[] stringArray = element.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            bob.append(attribute).append("=").append(element.getAttribute(attribute)).append(" ");
            ++n2;
        }
        bob.setLength(Math.max(0, bob.length() - 1));
        return bob.toString();
    }

    public static <T> Set<T> symmetricDiff(Set<T> set1, Set<T> set2) {
        Set<T> result = ExtensionRegistryAnalyzer.union(set1, set2);
        result.removeAll(ExtensionRegistryAnalyzer.intersect(set1, set2));
        return result;
    }

    public static <T> Set<T> union(Set<T> set1, Set<T> set2) {
        HashSet<T> union = new HashSet<T>(set1);
        union.addAll(set2);
        return union;
    }

    public static <T> Set<T> intersect(Set<T> set1, Set<T> set2) {
        HashSet<T> intersection = new HashSet<T>(set1);
        intersection.retainAll(set2);
        return intersection;
    }
}

