/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.test;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.Trace;
import org.eclipse.riena.internal.core.test.ExtensionRegistryAnalyzer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RienaTestCase
extends TestCase {
    private static final String ORG_ECLIPSE_RIENA_BUNDLE_PREFIX = null;
    private final Map<Object, ServiceReference> services = new HashMap<Object, ServiceReference>();
    private BundleContext context;
    private final boolean trace = Trace.isOn(RienaTestCase.class, ((Object)((Object)this)).getClass(), "debug");
    private Set<String> before;
    private Set<String> after;

    public RienaTestCase() {
    }

    public RienaTestCase(String name) {
        super(name);
    }

    protected void ok() {
    }

    protected void ok(String message) {
        this.ok();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.services.clear();
        this.before = ExtensionRegistryAnalyzer.getRegistryPaths(ORG_ECLIPSE_RIENA_BUNDLE_PREFIX);
    }

    protected void tearDown() throws Exception {
        for (ServiceReference reference : this.services.values()) {
            this.getContext().ungetService(reference);
        }
        this.services.clear();
        try {
            RienaTestCase.assertNotNull((String)"Obviously the super.setUp() method has not been called!", this.before);
            this.after = ExtensionRegistryAnalyzer.getRegistryPaths(ORG_ECLIPSE_RIENA_BUNDLE_PREFIX);
            if (!this.before.equals(this.after)) {
                RienaTestCase.fail((String)("ExtensionRegistry has changed while running the test " + this.getName() + ": " + ExtensionRegistryAnalyzer.symmetricDiff(this.before, this.after).toString()));
            }
        }
        finally {
            this.after = null;
            this.before = null;
            super.tearDown();
        }
    }

    protected BundleContext getContext() {
        if (this.context == null) {
            try {
                Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                this.context = bundle.getBundleContext();
            }
            catch (Throwable throwable) {
                Nop.reason("We don\u00b4t care. Maybe it is not running as a plugin test.");
            }
        }
        return this.context;
    }

    protected File getFile(String resource) {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        return new File(new File(new File("").getAbsolutePath(), "src"), url.getFile());
    }

    @Deprecated
    protected void setPrint(boolean print) {
    }

    protected boolean isTrace() {
        return this.trace;
    }

    protected void printTestName() {
        if (!this.isTrace()) {
            return;
        }
        System.out.println(this.getName());
        int i = 0;
        while (i < this.getName().length()) {
            System.out.print('-');
            ++i;
        }
        System.out.println();
    }

    protected void print(String string) {
        if (!this.isTrace()) {
            return;
        }
        System.out.print(string);
    }

    protected void println(String string) {
        if (!this.isTrace()) {
            return;
        }
        System.out.println(string);
    }

    protected void addPluginXml(Class<?> forLoad, String pluginResource) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        InputStream inputStream = forLoad.getResourceAsStream(pluginResource);
        IContributor contributor = ContributorFactoryOSGi.createContributor((Bundle)this.getContext().getBundle());
        RegistryEventListener listener = new RegistryEventListener(String.valueOf(forLoad.getName()) + " - " + pluginResource);
        registry.addListener((IRegistryEventListener)listener);
        boolean success = registry.addContribution(inputStream, contributor, false, pluginResource, null, ((ExtensionRegistry)registry).getTemporaryUserToken());
        listener.waitAdded();
        registry.removeListener((IRegistryEventListener)listener);
        RienaTestCase.assertTrue((boolean)success);
    }

    protected void removeExtension(String extensionId) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtension extension = registry.getExtension(extensionId);
        RienaTestCase.assertNotNull((Object)extension);
        RegistryEventListener listener = new RegistryEventListener(extensionId);
        registry.addListener((IRegistryEventListener)listener);
        boolean success = registry.removeExtension(extension, ((ExtensionRegistry)registry).getTemporaryUserToken());
        listener.waitExtensionRemoved();
        registry.removeListener((IRegistryEventListener)listener);
        RienaTestCase.assertTrue((boolean)success);
    }

    protected void removeExtensionPoint(String extensionPointId) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        RienaTestCase.assertNotNull((Object)extensionPoint);
        RegistryEventListener listener = new RegistryEventListener(extensionPointId);
        registry.addListener((IRegistryEventListener)listener);
        boolean success = registry.removeExtensionPoint(extensionPoint, ((ExtensionRegistry)registry).getTemporaryUserToken());
        listener.waitExtensionPointRemoved();
        registry.removeListener((IRegistryEventListener)listener);
        RienaTestCase.assertTrue((boolean)success);
    }

    protected <T> T getService(Class<T> serviceClass) {
        ServiceReference reference = this.getContext().getServiceReference(serviceClass.getName());
        if (reference == null) {
            return null;
        }
        Object service = this.getContext().getService(reference);
        if (service == null) {
            return null;
        }
        this.services.put(service, reference);
        return (T)service;
    }

    protected void ungetService(Object service) {
        ServiceReference reference = this.services.get(service);
        if (reference == null) {
            return;
        }
        this.getContext().ungetService(reference);
    }

    protected void startBundle(String bundleName) throws BundleException {
        this.startBundles(bundleName.replaceAll("\\.", "\\\\."), null);
    }

    protected void startBundles(String includePattern, String excludePattern) throws BundleException {
        this.doWithBundles(includePattern, excludePattern, new IClosure(){

            public void execute(Bundle bundle) throws BundleException {
                if (bundle.getState() == 4 || bundle.getState() == 8) {
                    bundle.start();
                } else if (bundle.getState() == 2) {
                    throw new RuntimeException("can't start required bundle because it is not RESOLVED but only INSTALLED : " + bundle.getSymbolicName());
                }
            }
        });
    }

    protected void stopBundle(String bundleName) throws BundleException {
        this.stopBundles(bundleName.replaceAll("\\.", "\\\\."), null);
    }

    protected void stopBundles(String includePattern, String excludePattern) throws BundleException {
        this.doWithBundles(includePattern, excludePattern, new IClosure(){

            public void execute(Bundle bundle) throws BundleException {
                if (bundle.getState() == 32) {
                    bundle.stop();
                } else if (bundle.getState() != 1) {
                    Nop.reason("testcase tried to stop this bundle which did not run, but we can ignore this ==> bundle is stopped already");
                }
            }
        });
    }

    protected void doWithBundles(String includePattern, String excludePattern, IClosure closure) throws BundleException {
        Bundle[] bundles;
        if (includePattern == null) {
            throw new UnsupportedOperationException("truePattern must be set");
        }
        if (excludePattern == null) {
            excludePattern = "";
        }
        Pattern include = Pattern.compile(includePattern);
        Pattern exclude = Pattern.compile(excludePattern);
        Bundle[] bundleArray = bundles = this.getContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (include.matcher(bundle.getSymbolicName()).matches() && !exclude.matcher(bundle.getSymbolicName()).matches()) {
                closure.execute(bundle);
            }
            ++n2;
        }
    }

    protected static interface IClosure {
        public void execute(Bundle var1) throws BundleException;
    }

    private final class RegistryEventListener
    implements IRegistryEventListener {
        private final CountDownLatch added = new CountDownLatch(1);
        private final CountDownLatch extensionRemoved = new CountDownLatch(1);
        private final CountDownLatch extensionPointRemoved = new CountDownLatch(1);
        private final String ident;
        private static final int SECONDS_TO_WAIT = 1;

        private RegistryEventListener(String ident) {
            this.ident = ident;
        }

        public void waitAdded() {
            String message = "Expected extension/point has not been \u00b4added\u00b4 for " + this.ident + " because ";
            try {
                this.added.await(1L, TimeUnit.SECONDS);
                if (this.added.getCount() == 1L && RienaTestCase.this.isTrace()) {
                    System.err.println(String.valueOf(message) + " time-out has been reached. Which might be ok!");
                }
            }
            catch (InterruptedException e) {
                TestCase.fail((String)(String.valueOf(message) + " the CountDownLatch failed with " + e));
            }
        }

        public void waitExtensionRemoved() {
            String message = "Expected extension id " + this.ident + " has not been \u00b4removed\u00b4 because ";
            try {
                this.extensionRemoved.await(1L, TimeUnit.SECONDS);
                if (this.extensionRemoved.getCount() == 1L && RienaTestCase.this.isTrace()) {
                    System.err.println(String.valueOf(message) + " time-out has been reached. Which might be ok!");
                }
            }
            catch (InterruptedException e) {
                TestCase.fail((String)(String.valueOf(message) + " the CountDownLatch failed with " + e));
            }
        }

        public void waitExtensionPointRemoved() {
            String message = "Expected extension point id " + this.ident + " has not been \u00b4removed\u00b4 because ";
            try {
                this.extensionPointRemoved.await(1L, TimeUnit.SECONDS);
                if (this.extensionPointRemoved.getCount() == 1L && RienaTestCase.this.isTrace()) {
                    System.err.println(String.valueOf(message) + " time-out has been reached. Which might be ok!");
                }
            }
            catch (InterruptedException e) {
                TestCase.fail((String)(String.valueOf(message) + " the CountDownLatch failed with " + e));
            }
        }

        public void added(IExtension[] extensions) {
            if (RienaTestCase.this.isTrace()) {
                System.out.println("Extensions added: ");
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    System.out.println(" - " + extension.getUniqueIdentifier() + ", " + extension.getExtensionPointUniqueIdentifier());
                    ++n2;
                }
            }
            this.added.countDown();
        }

        public void added(IExtensionPoint[] extensionPoints) {
            if (RienaTestCase.this.isTrace()) {
                System.out.println("ExtensionPoints added: ");
                IExtensionPoint[] iExtensionPointArray = extensionPoints;
                int n = extensionPoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionPoint extensionPoint = iExtensionPointArray[n2];
                    System.out.println(" - " + extensionPoint.getUniqueIdentifier());
                    ++n2;
                }
            }
            this.added.countDown();
        }

        public void removed(IExtension[] extensions) {
            if (RienaTestCase.this.isTrace()) {
                System.out.println("Extensions removed: ");
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    System.out.println(" - " + extension.getUniqueIdentifier() + ", " + extension.getExtensionPointUniqueIdentifier());
                    ++n2;
                }
            }
            this.extensionRemoved.countDown();
        }

        public void removed(IExtensionPoint[] extensionPoints) {
            if (RienaTestCase.this.isTrace()) {
                System.out.println("ExtensionPoints removed: ");
                IExtensionPoint[] iExtensionPointArray = extensionPoints;
                int n = extensionPoints.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionPoint extensionPoint = iExtensionPointArray[n2];
                    System.out.println(" - " + extensionPoint.getUniqueIdentifier());
                    ++n2;
                }
            }
            this.extensionPointRemoved.countDown();
        }
    }
}

