/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.List;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.IModuleGroupNodeListener;
import org.eclipse.riena.navigation.model.NavigationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleGroupNode
extends NavigationNode<IModuleGroupNode, IModuleNode, IModuleGroupNodeListener>
implements IModuleGroupNode {
    private boolean presentWithSingleModule = true;

    public ModuleGroupNode() {
        this(null);
    }

    @Override
    public Class<IModuleNode> getValidChildType() {
        return IModuleNode.class;
    }

    public ModuleGroupNode(NavigationNodeId nodeId) {
        super(nodeId);
    }

    @Override
    public boolean isPresentWithSingleModule() {
        return this.presentWithSingleModule;
    }

    @Override
    public void setPresentWithSingleModule(boolean pPresentWithSingleModule) {
        this.presentWithSingleModule = pPresentWithSingleModule;
        this.notifyPresentWithSingleModule();
    }

    private void notifyPresentWithSingleModule() {
        for (IModuleGroupNodeListener next : this.getListeners()) {
            next.presentWithSingleModuleChanged(this);
        }
    }

    @Override
    public boolean isPresentGroupNode() {
        return this.isPresentWithSingleModule() || this.getChildren().size() > 1;
    }

    @Override
    public final boolean isVisible() {
        boolean visible = super.isVisible();
        if (visible) {
            visible = false;
            List children = this.getChildren();
            for (IModuleNode moduleNode : children) {
                if (!moduleNode.isVisible()) continue;
                visible = true;
                break;
            }
        }
        return visible;
    }
}

