/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations.util;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.decorators.ContributingPluginDecorator;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.presentations.IPresentablePart;
import org.osgi.framework.FrameworkUtil;

public final class PartInfo {
    public String name;
    public String title;
    public String contentDescription;
    public String toolTip;
    public Image image;
    public boolean dirty;
    public String bundleId;

    public PartInfo() {
        this.name = "";
        this.title = "";
        this.contentDescription = "";
        this.toolTip = "";
        this.image = null;
    }

    public PartInfo(IPresentablePart part) {
        this.set(part);
    }

    public void set(IPresentablePart part) {
        IWorkbenchPart p;
        PresentablePart pp;
        this.name = part.getName();
        this.title = part.getTitle();
        this.contentDescription = part.getTitleStatus();
        this.image = part.getTitleImage();
        this.toolTip = part.getTitleToolTip();
        this.dirty = part.isDirty();
        this.bundleId = null;
        if (part instanceof PresentablePart && PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(ContributingPluginDecorator.ID) != null && (pp = (PresentablePart)part).getPane() != null && (p = pp.getPane().getPartReference().getPart(false)) != null) {
            this.bundleId = FrameworkUtil.getBundle(p.getClass()).getSymbolicName();
        }
    }
}

