/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.swt.Messages;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SWTControlFinder;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMasterDetailsComposite
extends Composite
implements IComplexComponent {
    public static final String BIND_ID_TABLE = "mdTable";
    public static final String BIND_ID_NEW = "mdNewButton";
    public static final String BIND_ID_REMOVE = "mdRemoveButton";
    public static final String BIND_ID_APPLY = "mdApplyButton";
    private final List<Object> controls = new ArrayList<Object>();
    private Control table;
    private Composite details;
    private Composite master;

    public AbstractMasterDetailsComposite(Composite parent, int style, int orientation) {
        super(parent, style);
        this.checkOrientation(orientation);
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 5).create());
        if (orientation == 128) {
            this.details = this.createComposite(this.getDetailsStyle());
            this.createDetails(this.details);
        }
        this.master = this.createComposite(this.getMasterStyle());
        this.createMaster(this.master);
        if (orientation == 1024) {
            this.details = this.createComposite(this.getDetailsStyle());
            this.createDetails(this.details);
        }
        this.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
    }

    public final void addUIControl(Object uiControl, String bindingId) {
        Assert.isNotNull((Object)uiControl);
        Assert.isNotNull((Object)bindingId);
        this.controls.add(uiControl);
        SWTBindingPropertyLocator.getInstance().setBindingProperty(uiControl, bindingId);
    }

    public boolean confirmDiscardChanges() {
        String title = Messages.MasterDetailsComposite_dialogMessage_confirmDiscard;
        String message = Messages.MasterDetailsComposite_dialogTitle_confirmDiscard;
        boolean result = MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message);
        return result;
    }

    public boolean confirmRemove(Object item) {
        return true;
    }

    public final Button getButtonApply() {
        return (Button)this.getUIControl(BIND_ID_APPLY);
    }

    public final Button getButtonNew() {
        return (Button)this.getUIControl(BIND_ID_NEW);
    }

    public final Button getButtonRemove() {
        return (Button)this.getUIControl(BIND_ID_REMOVE);
    }

    public final Composite getDetails() {
        return this.details;
    }

    public Point getMargins() {
        GridLayout layout = (GridLayout)this.getLayout();
        Point result = new Point(layout.marginHeight, layout.marginWidth);
        return result;
    }

    public Point getSpacing() {
        GridLayout layout = (GridLayout)this.getLayout();
        GridLayout mLayout = (GridLayout)this.master.getLayout();
        Point result = new Point(mLayout.horizontalSpacing, layout.verticalSpacing);
        return result;
    }

    public Control getTable() {
        return this.table;
    }

    public final List<Object> getUIControls() {
        SWTControlFinder finder = new SWTControlFinder(this.details){

            public boolean contains(Control control) {
                return AbstractMasterDetailsComposite.this.controls.contains(control);
            }

            public void handleBoundControl(Control control, String bindingProperty) {
                AbstractMasterDetailsComposite.this.controls.add(control);
            }
        };
        finder.run();
        return Collections.unmodifiableList(this.controls);
    }

    public void setBackground(Color color) {
        this.master.setBackground(color);
        this.details.setBackground(color);
        super.setBackground(color);
    }

    public void setMargins(int marginHeight, int marginWidth) {
        GridLayout layout = (GridLayout)this.getLayout();
        layout.marginHeight = marginHeight;
        layout.marginWidth = marginWidth;
        this.layout(false);
    }

    public void setSpacing(int hSpacing, int vSpacing) {
        GridLayout layout = (GridLayout)this.getLayout();
        layout.verticalSpacing = vSpacing;
        GridLayout mLayout = (GridLayout)this.master.getLayout();
        mLayout.horizontalSpacing = hSpacing;
        this.layout(false);
    }

    public void warnApplyFailed(String reason) {
        Assert.isNotNull((Object)reason);
        String title = Messages.MasterDetailsComposite_dialogTitle_applyFailed;
        MessageDialog.openWarning((Shell)this.getShell(), (String)title, (String)reason);
    }

    protected Button createButtonApply(Composite compButton) {
        return UIControlsFactory.createButton(compButton, Messages.MasterDetailsComposite_buttonApply);
    }

    protected Button createButtonNew(Composite compButton) {
        return UIControlsFactory.createButton(compButton, Messages.MasterDetailsComposite_buttonNew);
    }

    protected Button createButtonRemove(Composite compButton) {
        return UIControlsFactory.createButton(compButton, Messages.MasterDetailsComposite_buttonRemove);
    }

    protected Composite createButtons(Composite parent) {
        Button btnApply;
        Button btnRemove;
        Composite result = UIControlsFactory.createComposite(parent);
        RowLayout buttonLayout = new RowLayout(512);
        buttonLayout.marginTop = 0;
        buttonLayout.marginLeft = 3;
        buttonLayout.marginRight = 2;
        buttonLayout.fill = true;
        result.setLayout((Layout)buttonLayout);
        Button btnNew = this.createButtonNew(result);
        if (btnNew != null) {
            this.addUIControl(btnNew, BIND_ID_NEW);
        }
        if ((btnRemove = this.createButtonRemove(result)) != null) {
            this.addUIControl(btnRemove, BIND_ID_REMOVE);
        }
        if ((btnApply = this.createButtonApply(result)) != null) {
            this.addUIControl(btnApply, BIND_ID_APPLY);
        }
        return result;
    }

    protected void createDetails(Composite details) {
    }

    protected abstract Control createTable(Composite var1, TableColumnLayout var2);

    protected int getDetailsStyle() {
        return 0;
    }

    protected int getMasterStyle() {
        return 2048;
    }

    private void checkOrientation(int orientation) {
        int[] allowedValues;
        int[] nArray = allowedValues = new int[]{128, 1024};
        int n = allowedValues.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            if (orientation == value) {
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException("unsupported orientation: " + orientation);
    }

    private Composite createComposite(int style) {
        Composite result = UIControlsFactory.createComposite(this, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)result);
        return result;
    }

    private void createMaster(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(0, 0).applyTo(parent);
        Composite compTable = this.createTableComposite(parent);
        Composite compButton = this.createButtons(parent);
        if (compButton != null) {
            if (compButton.getLayoutData() == null) {
                GridDataFactory.fillDefaults().applyTo((Control)compButton);
            }
            if ((compButton.getStyle() & 0x800) == 0) {
                compButton.addPaintListener((PaintListener)new LinePaintListener());
            }
        } else {
            ((GridData)compTable.getLayoutData()).horizontalSpan = 2;
        }
    }

    private Composite createTableComposite(Composite parent) {
        Composite result = UIControlsFactory.createComposite(parent);
        TableColumnLayout layout = new TableColumnLayout();
        this.table = this.createTable(result, layout);
        if (this.table instanceof Table && result.getLayout() == null) {
            result.setLayout((Layout)layout);
            int wHint = 200;
            int hHint = ((Table)this.table).getItemHeight() * 8 + ((Table)this.table).getHeaderHeight();
            GridDataFactory.fillDefaults().grab(true, false).hint(wHint, hHint).applyTo((Control)result);
        }
        this.addUIControl(this.table, BIND_ID_TABLE);
        return result;
    }

    private Control getUIControl(String id) {
        Control result = null;
        SWTBindingPropertyLocator bpLocator = SWTBindingPropertyLocator.getInstance();
        Iterator<Object> iter = this.controls.iterator();
        while (result == null && iter.hasNext()) {
            Control control = (Control)iter.next();
            if (!id.equals(bpLocator.locateBindingProperty(control))) continue;
            result = control;
        }
        Assert.isNotNull(result);
        return result;
    }

    private static final class LinePaintListener
    implements PaintListener {
        private Color fgColor;

        private LinePaintListener() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Color oldFg = gc.getForeground();
            if (this.fgColor == null) {
                this.fgColor = LnfManager.getLnf().getColor("MDW.separatorForeground");
            }
            gc.setForeground(this.fgColor);
            Rectangle bounds = ((Control)e.widget).getBounds();
            gc.drawLine(0, 0, 0, bounds.height);
            gc.setForeground(oldFg);
        }
    }
}

