/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.swt.DatePickerComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class BorderControlDecoration {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), BorderControlDecoration.class);
    private static final Rectangle ZERO_RECTANGLE = new Rectangle(0, 0, 0, 0);
    private static final int DEFAULT_BORDER_WIDTH = 1;
    private Control control;
    private DisposeListener disposeListener;
    private PaintListener paintListener;
    private ControlListener controlListener;
    private boolean visible;
    private Color borderColor;
    private int borderWidth = 1;

    public BorderControlDecoration(Control control) {
        this(control, 1);
    }

    public BorderControlDecoration(Control control, int borderWidth) {
        this(control, borderWidth, null);
    }

    public BorderControlDecoration(Control control, int borderWidth, Color borderColor) {
        this.control = control;
        if (this.control.getParent() instanceof DatePickerComposite) {
            this.control = this.control.getParent();
        }
        this.borderWidth = borderWidth;
        if (this.borderWidth < 0) {
            borderWidth = 0;
            LOGGER.log(2, "BorderWidth is lower eqauls 0!");
        }
        this.borderColor = borderColor;
        this.visible = false;
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BorderControlDecoration.this.dispose();
            }
        };
        this.control.addDisposeListener(this.disposeListener);
        this.controlListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                this.redrawControl(e);
            }

            public void controlResized(ControlEvent e) {
                this.redrawControl(e);
            }

            private void redrawControl(ControlEvent e) {
                if (e.widget instanceof Control) {
                    Control ctrl = (Control)e.widget;
                    ctrl.setRedraw(false);
                    ctrl.setRedraw(true);
                }
            }
        };
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (BorderControlDecoration.this.shouldShowDecoration()) {
                    Control uiControl = (Control)event.widget;
                    Rectangle rect = BorderControlDecoration.this.getDecorationRectangle(uiControl);
                    BorderControlDecoration.this.onPaint(event.gc, rect);
                }
            }
        };
        Object c = this.control.getParent();
        Rectangle controlBounds = this.control.getBounds();
        while (c != null) {
            this.installCompositeListeners((Composite)c);
            if (c instanceof Shell) {
                c = null;
                continue;
            }
            Rectangle decoRect = this.getDecorationRectangle((Control)c);
            c = decoRect.x >= 0 && decoRect.y >= 0 && controlBounds.width + this.getBorderWidth() <= decoRect.width && controlBounds.height + this.getBorderWidth() <= decoRect.height ? null : c.getParent();
        }
    }

    public void dispose() {
        if (this.control == null) {
            return;
        }
        this.removeControlListeners();
        this.control = null;
    }

    private void removeControlListeners() {
        if (this.control == null) {
            return;
        }
        this.control.removeDisposeListener(this.disposeListener);
        this.control.removeControlListener(this.controlListener);
        Object c = this.control.getParent();
        while (c != null) {
            this.removeCompositeListeners((Composite)c);
            c = c instanceof Shell ? null : c.getParent();
        }
        this.paintListener = null;
        this.controlListener = null;
        this.disposeListener = null;
    }

    private void installCompositeListeners(Composite c) {
        if (!c.isDisposed()) {
            c.addPaintListener(this.paintListener);
            c.addControlListener(this.controlListener);
        }
    }

    private void removeCompositeListeners(Composite c) {
        if (!c.isDisposed()) {
            c.removeControlListener(this.controlListener);
            c.removePaintListener(this.paintListener);
        }
    }

    private void onPaint(GC gc, Rectangle rect) {
        Color previousForeground = gc.getForeground();
        if (this.getBorderColor() != null) {
            gc.setForeground(this.getBorderColor());
        } else {
            LOGGER.log(2, "BorderColor is null!");
        }
        int i = 0;
        while (i < this.getBorderWidth()) {
            gc.drawRectangle(rect.x + i, rect.y + i, rect.width - i * 2, rect.height - i * 2);
            ++i;
        }
        gc.setForeground(previousForeground);
    }

    private boolean shouldShowDecoration() {
        if (!this.visible) {
            return false;
        }
        if (this.control == null || this.control.isDisposed()) {
            return false;
        }
        if (!this.control.isVisible()) {
            return false;
        }
        return this.getBorderWidth() > 0;
    }

    public void show() {
        if (!this.visible) {
            this.visible = true;
            this.update();
        }
    }

    public void hide() {
        if (this.visible) {
            this.visible = false;
            this.update();
        }
    }

    private void update() {
        if (this.control == null || this.control.isDisposed() || this.getBorderWidth() <= 0) {
            return;
        }
        Rectangle rect = this.getDecorationRectangle((Control)this.control.getShell());
        this.control.getShell().redraw(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2, true);
        this.control.getShell().update();
    }

    private Rectangle getDecorationRectangle(Control targetControl) {
        if (this.control == null) {
            return ZERO_RECTANGLE;
        }
        Rectangle controlBounds = this.control.getBounds();
        int x = controlBounds.x - this.getBorderWidth();
        int y = controlBounds.y - this.getBorderWidth();
        Point globalPoint = this.control.getParent().toDisplay(x, y);
        Point targetPoint = targetControl == null ? globalPoint : targetControl.toControl(globalPoint);
        int width = controlBounds.width + this.getBorderWidth() * 2 - 1;
        int height = controlBounds.height + this.getBorderWidth() * 2 - 1;
        return new Rectangle(targetPoint.x, targetPoint.y, width, height);
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.update();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }
}

