/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.rienadefault;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.lnf.ColorLnfResource;
import org.eclipse.riena.ui.swt.lnf.FontDescriptor;
import org.eclipse.riena.ui.swt.lnf.ILnfMarkerSupportExtension;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.ILnfRendererExtension;
import org.eclipse.riena.ui.swt.lnf.ILnfResource;
import org.eclipse.riena.ui.swt.lnf.ILnfTheme;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultTheme;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RienaDefaultLnf {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), RienaDefaultLnf.class);
    private static final String DEFAULT_THEME_CLASSNAME = RienaDefaultTheme.class.getName();
    private static final String SYSTEM_PROPERTY_LNF_SETTING_PREFIX = "riena.lnf.setting.";
    private final Map<String, ILnfResource> resourceTable = new Hashtable<String, ILnfResource>();
    private final Map<String, Object> settingTable = new Hashtable<String, Object>();
    private final Map<String, ILnfRenderer> rendererTable = new Hashtable<String, ILnfRenderer>();
    private final List<ILnfMarkerSupportExtension> markerSupportList = new ArrayList<ILnfMarkerSupportExtension>();
    private ILnfTheme theme;
    private boolean initialized;
    private boolean defaultColorsInitialized = false;

    public Map<String, ILnfResource> getResourceTable() {
        return this.resourceTable;
    }

    protected Map<String, ILnfRenderer> getRendererTable() {
        return this.rendererTable;
    }

    protected Map<String, Object> getSettingTable() {
        return this.settingTable;
    }

    public void initialize() {
        if (!this.isInitialized()) {
            this.uninitialize();
            this.setInitialized(true);
            this.initWidgetRendererDefaults();
            this.initResourceDefaults();
            this.readSystemProperties();
        }
    }

    private void readSystemProperties() {
        Properties sysProps = System.getProperties();
        Set<Object> sysPropKeys = sysProps.keySet();
        for (Object propKey : sysPropKeys) {
            String propKeyName = propKey.toString();
            if (!propKeyName.startsWith(SYSTEM_PROPERTY_LNF_SETTING_PREFIX)) continue;
            String lnfKey = propKeyName.substring(SYSTEM_PROPERTY_LNF_SETTING_PREFIX.length());
            Object lnfValue = sysProps.get(propKeyName);
            this.getSettingTable().put(lnfKey, lnfValue);
        }
    }

    public void uninitialize() {
        this.disposeAllResources();
        this.getResourceTable().clear();
        this.getRendererTable().clear();
        this.getSettingTable().clear();
        this.setInitialized(false);
        this.defaultColorsInitialized = false;
    }

    protected void initWidgetRendererDefaults() {
        if (Activator.getDefault() != null) {
            Wire.instance((Object)this).andStart(Activator.getDefault().getContext());
        }
    }

    @InjectExtension
    public void update(ILnfRendererExtension[] rendererExtensions) {
        if (rendererExtensions == null) {
            return;
        }
        ILnfRendererExtension[] iLnfRendererExtensionArray = rendererExtensions;
        int n = rendererExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            ILnfRendererExtension rendererExtension = iLnfRendererExtensionArray[n2];
            String id = rendererExtension.getLnfId();
            if (!(!StringUtils.isEmpty((CharSequence)id) && !id.equals(this.getLnfId()) || StringUtils.isEmpty((CharSequence)id) && this.getRendererTable().get(rendererExtension.getLnfKey()) != null)) {
                this.getRendererTable().put(rendererExtension.getLnfKey(), rendererExtension.createRenderer());
            }
            ++n2;
        }
    }

    @InjectExtension
    public void update(ILnfMarkerSupportExtension[] markerSupportExtensions) {
        if (markerSupportExtensions == null) {
            return;
        }
        this.markerSupportList.clear();
        this.markerSupportList.addAll(Arrays.asList(markerSupportExtensions));
    }

    public AbstractMarkerSupport getMarkerSupport(Class<? extends IRidget> ridgetClass) {
        String markerSupportID = this.getStringSetting("markerSupport.id");
        for (ILnfMarkerSupportExtension lnfMarkerSupportExtension : this.markerSupportList) {
            if (StringUtils.isEmpty((CharSequence)lnfMarkerSupportExtension.getId()) || !lnfMarkerSupportExtension.getId().equals(markerSupportID)) continue;
            return lnfMarkerSupportExtension.createMarkerSupport();
        }
        LOGGER.log(3, "No MarkerSupport with the ID \"" + markerSupportID + "\" exists.");
        return null;
    }

    protected void initResourceDefaults() {
        this.initColorDefaults();
        this.initFontDefaults();
        this.initImageDefaults();
        this.initSettingsDefaults();
    }

    protected void initColorDefaults() {
        if (this.defaultColorsInitialized) {
            return;
        }
        this.getResourceTable().put("black", new ColorLnfResource(0, 0, 0));
        this.getResourceTable().put("white", new ColorLnfResource(255, 255, 255));
        if (this.getTheme() != null) {
            this.getTheme().addCustomColors(this.getResourceTable());
        }
        this.defaultColorsInitialized = true;
    }

    protected void initFontDefaults() {
        if (this.getTheme() != null) {
            this.getTheme().addCustomFonts(this.getResourceTable());
        }
    }

    protected void initImageDefaults() {
        if (this.getTheme() != null) {
            this.getTheme().addCustomImages(this.getResourceTable());
        }
    }

    protected void initSettingsDefaults() {
        if (this.getTheme() != null) {
            this.getTheme().addCustomSettings(this.getSettingTable());
        }
    }

    private void disposeAllResources() {
        Set<String> keys = this.getResourceTable().keySet();
        for (String key : keys) {
            ILnfResource value = this.getResourceTable().get(key);
            if (value == null) continue;
            value.dispose();
        }
    }

    public Resource getResource(String key) {
        ILnfResource value = this.getResourceTable().get(key);
        if (value != null) {
            return value.getResource();
        }
        return null;
    }

    public Color getColor(String key) {
        this.initColorDefaults();
        Resource value = this.getResource(key);
        if (value instanceof Color) {
            return (Color)value;
        }
        return null;
    }

    public Font getFont(String key) {
        Resource value = this.getResource(key);
        if (value instanceof Font) {
            return (Font)value;
        }
        return null;
    }

    public Font getFont(String key, int height, int style) {
        FontDescriptor fontDescriptor = new FontDescriptor(key, height, style, this);
        return fontDescriptor.getFont();
    }

    public Image getImage(String key) {
        Resource value = this.getResource(key);
        if (value instanceof Image) {
            return (Image)value;
        }
        return null;
    }

    public ILnfRenderer getRenderer(String key) {
        return this.getRendererTable().get(key);
    }

    public Object getSetting(String key) {
        return this.getSettingTable().get(key);
    }

    public Integer getIntegerSetting(String key) {
        Object value = this.getSetting(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        String strgValue = value.toString();
        try {
            return new Integer(strgValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Integer getIntegerSetting(String key, Integer defaultValue) {
        Integer value = this.getIntegerSetting(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Boolean getBooleanSetting(String key) {
        Object value = this.getSetting(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String strgValue = value.toString();
        try {
            return new Boolean(strgValue);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Boolean getBooleanSetting(String key, boolean defaultValue) {
        Boolean value = this.getBooleanSetting(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getStringSetting(String key) {
        Object value = this.getSetting(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    private static ILnfTheme createTheme(String themeClassName) {
        try {
            ClassLoader classLoader = LnfManager.class.getClassLoader();
            Class<?> themeClass = classLoader.loadClass(themeClassName);
            return (ILnfTheme)themeClass.newInstance();
        }
        catch (Exception e) {
            throw new Error("can't load theme " + themeClassName, e);
        }
    }

    public ILnfTheme getTheme() {
        if (this.theme == null) {
            this.theme = RienaDefaultLnf.createTheme(DEFAULT_THEME_CLASSNAME);
        }
        if (!this.isInitialized()) {
            this.initialize();
        }
        return this.theme;
    }

    public void setTheme(ILnfTheme newTheme) {
        if (this.theme != newTheme) {
            this.theme = newTheme;
            this.setInitialized(false);
            this.defaultColorsInitialized = false;
        }
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    protected String getLnfId() {
        return "";
    }
}

