/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class SWTControlFinder {
    private Composite start;

    public SWTControlFinder(Composite composite) {
        Assert.isNotNull((Object)composite);
        this.start = composite;
    }

    public void run() {
        if (this.start == null) {
            throw new IllegalStateException("cannot run more than once!");
        }
        this.addUIControls(this.start);
        this.start = null;
    }

    public boolean contains(Control control) {
        return false;
    }

    public void handleControl(Control control) {
        if (control instanceof Composite && !(control instanceof IComplexComponent)) {
            this.addUIControls((Composite)control);
        }
    }

    public abstract void handleBoundControl(Control var1, String var2);

    protected final void addUIControls(Composite composite) {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            String bindingProperty = locator.locateBindingProperty(control);
            if (StringUtils.isGiven((CharSequence)bindingProperty) && !this.contains(control)) {
                this.handleBoundControl(control, bindingProperty);
            }
            this.handleControl(control);
            ++n2;
        }
    }
}

