/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;

public class Activator
implements BundleActivator {
    public static final String ID = "org.eclipse.equinox.p2.transformer";
    private static BundleContext bundleContext;

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public void start(BundleContext context) throws Exception {
        bundleContext = context;
        Bundle bundle = Activator.getBundle("org.eclipse.equinox.p2.exemplarysetup");
        if (bundle == null) {
            throw new ProvisionException(Messages.unable_to_start_exemplarysetup);
        }
        bundle.start(1);
    }

    public void stop(BundleContext context) throws Exception {
        bundleContext = null;
    }

    public static URI getURI(String spec) {
        if (spec == null) {
            return null;
        }
        try {
            return URIUtil.fromString((String)spec);
        }
        catch (URISyntaxException e) {
            LogHelper.log((IStatus)new Status(2, ID, NLS.bind((String)Messages.unable_to_process_uri, (Object)spec), (Throwable)e));
            return null;
        }
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager() throws ProvisionException {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)Activator.getBundleContext(), (String)IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new ProvisionException(Messages.no_artifactRepo_manager);
        }
        return manager;
    }

    static IProfileRegistry getProfileRegistry() throws ProvisionException {
        IProfileRegistry registry = (IProfileRegistry)ServiceHelper.getService((BundleContext)Activator.getBundleContext(), (String)IProfileRegistry.SERVICE_NAME);
        if (registry == null) {
            throw new ProvisionException(Messages.no_profile_registry);
        }
        return registry;
    }

    public static synchronized Bundle getBundle(String symbolicName) throws ProvisionException {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        PackageAdmin packageAdmin = (PackageAdmin)ServiceHelper.getService((BundleContext)Activator.getBundleContext(), (String)clazz.getName());
        if (packageAdmin == null) {
            throw new ProvisionException(Messages.no_package_admin);
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public static IMetadataRepositoryManager getMetadataRepositoryManager() throws ProvisionException {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)Activator.getBundleContext(), (String)IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new ProvisionException(Messages.no_metadataRepo_manager);
        }
        return manager;
    }
}

