/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.analyzer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.tools.analyzer.IUAnalyzer;

public class HostCheckAnalyzer
extends IUAnalyzer {
    private IMetadataRepository repository;

    public void analyzeIU(IInstallableUnit iu) {
        if (iu instanceof IInstallableUnitFragment) {
            IInstallableUnitFragment fragment = (IInstallableUnitFragment)iu;
            IRequirement[] hosts = fragment.getHost();
            int i = 0;
            while (i < hosts.length) {
                VersionRange range;
                String name;
                IQueryResult results;
                IMatchExpression hostMatch = hosts[i].getMatches();
                String namespace = RequiredCapability.extractNamespace((IMatchExpression)hostMatch);
                if ("osgi.bundle".equals(namespace) && (results = this.repository.query((IQuery)new InstallableUnitQuery(name = RequiredCapability.extractName((IMatchExpression)hostMatch), range = RequiredCapability.extractRange((IMatchExpression)hostMatch)), (IProgressMonitor)new NullProgressMonitor())).isEmpty()) {
                    this.error(iu, "IU Fragment: " + iu.getId() + " cannot find host" + name + " : " + range);
                    return;
                }
                ++i;
            }
        }
    }

    public void preAnalysis(IMetadataRepository repository) {
        this.repository = repository;
    }
}

