/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.logging.LogLevelMapper;
import org.osgi.framework.Bundle;

public class CommandProviderLogFilter
implements LogFilter,
CommandProvider,
IExecutableExtension {
    private int threshold = 4;

    public CommandProviderLogFilter() {
        Activator.getDefault().getContext().registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public boolean isLoggable(Bundle b, String loggerName, int logLevel) {
        return logLevel <= this.threshold;
    }

    public void _logLevel(CommandInterpreter ci) throws Exception {
        String level = ci.nextArgument();
        if (level != null) {
            this.threshold = LogLevelMapper.getValue(level);
        }
        System.out.println("LogLevel: " + LogLevelMapper.getValue(this.threshold));
    }

    public String getHelp() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.println("---Controlling Riena logging---");
        writer.println("\tlogLevel [ <level> ] - specify log level, e.g. debug, info, warn, error or none, or retrieve current level");
        writer.close();
        return stringWriter.toString();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data == null) {
            return;
        }
        if (!(data instanceof String)) {
            return;
        }
        this.threshold = LogLevelMapper.getValue((String)data);
    }
}

