/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.osgi.ExtensionEventDispatcherJob;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.riena.core.exception.MurphysLawFailure;
import org.eclipse.riena.core.util.IOUtils;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.Trace;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class TestingTools {
    private final Map<Object, ServiceReference> services = new HashMap<Object, ServiceReference>();
    private BundleContext context;
    private final ExtensionRegistryChangeJobTracker jobTracker = new ExtensionRegistryChangeJobTracker();
    private final TestCaseWrapper testCase;
    private final boolean trace;

    TestingTools(TestCaseWrapper testCase) {
        this.testCase = testCase;
        this.trace = Trace.isOn(RienaTestCase.class, testCase.getTestClass(), "debug");
    }

    protected void ok() {
    }

    public void ok(String message) {
        this.ok();
    }

    void setUp() {
        this.services.clear();
    }

    void tearDown() {
        for (ServiceReference reference : this.services.values()) {
            this.getContext().ungetService(reference);
        }
        this.services.clear();
    }

    public BundleContext getContext() {
        if (this.context == null) {
            try {
                Bundle bundle = FrameworkUtil.getBundle(this.testCase.getTestClass());
                this.context = bundle.getBundleContext();
            }
            catch (Throwable throwable) {
                Nop.reason("We don\u00b4t care. Maybe it is not running as a plugin test.");
            }
        }
        return this.context;
    }

    public File getFile(String resource) {
        URL url = this.testCase.getTestClass().getResource(resource);
        try {
            File tempFile = File.createTempFile(resource.replace('.', '-'), ".tmp");
            tempFile.deleteOnExit();
            IOUtils.copy(url.openStream(), new FileOutputStream(tempFile));
            return tempFile;
        }
        catch (IOException e) {
            this.testCase.fail("IOException when trying to make a copy of " + resource + ": " + e);
            return null;
        }
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void printTestName() {
        if (!this.isTrace()) {
            return;
        }
        System.out.println(this.testCase.getName());
        int i = 0;
        while (i < this.testCase.getName().length()) {
            System.out.print('-');
            ++i;
        }
        System.out.println();
    }

    public void print(String string) {
        if (!this.isTrace()) {
            return;
        }
        System.out.print(string);
    }

    public void println(String string) {
        if (!this.isTrace()) {
            return;
        }
        System.out.println(string);
    }

    public void addPluginXml(String pluginResource) {
        this.addPluginXml(this.testCase.getTestClass(), pluginResource);
    }

    public void addPluginXml(Class<?> forLoad, String pluginResource) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        InputStream inputStream = forLoad.getResourceAsStream(pluginResource);
        IContributor contributor = ContributorFactoryOSGi.createContributor((Bundle)this.getContext().getBundle());
        this.startJobTracking();
        boolean success = registry.addContribution(inputStream, contributor, false, pluginResource, null, ((ExtensionRegistry)registry).getTemporaryUserToken());
        this.stopJobTracking();
        this.testCase.assertTrue(success);
        this.joinTrackedJobs();
    }

    private void startJobTracking() {
        this.jobTracker.start();
    }

    private void stopJobTracking() {
        this.jobTracker.stop();
    }

    private void joinTrackedJobs() {
        this.jobTracker.joinJobs();
    }

    public void removeExtension(String extensionId) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtension extension = registry.getExtension(extensionId);
        this.testCase.assertNotNull(extension);
        this.startJobTracking();
        boolean success = registry.removeExtension(extension, ((ExtensionRegistry)registry).getTemporaryUserToken());
        this.stopJobTracking();
        this.testCase.assertTrue(success);
        this.joinTrackedJobs();
    }

    public void removeExtensionPoint(String extensionPointId) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        this.testCase.assertNotNull(extensionPoint);
        this.startJobTracking();
        boolean success = registry.removeExtensionPoint(extensionPoint, ((ExtensionRegistry)registry).getTemporaryUserToken());
        this.stopJobTracking();
        this.testCase.assertTrue(success);
        this.joinTrackedJobs();
    }

    public <T> T getService(Class<T> serviceClass) {
        ServiceReference reference = this.getContext().getServiceReference(serviceClass.getName());
        if (reference == null) {
            return null;
        }
        Object service = this.getContext().getService(reference);
        if (service == null) {
            return null;
        }
        this.services.put(service, reference);
        return (T)service;
    }

    public void ungetService(Object service) {
        ServiceReference reference = this.services.get(service);
        if (reference == null) {
            return;
        }
        this.getContext().ungetService(reference);
    }

    public void startBundle(String bundleName) throws BundleException {
        this.startBundles(bundleName.replaceAll("\\.", "\\\\."), null);
    }

    public void startBundles(String includePattern, String excludePattern) throws BundleException {
        this.doWithBundles(includePattern, excludePattern, new IClosure(){

            @Override
            public void execute(Bundle bundle) throws BundleException {
                if (bundle.getState() == 4 || bundle.getState() == 8) {
                    bundle.start();
                } else if (bundle.getState() == 2) {
                    throw new RuntimeException("can't start required bundle because it is not RESOLVED but only INSTALLED : " + bundle.getSymbolicName());
                }
            }
        });
    }

    public void stopBundle(String bundleName) throws BundleException {
        this.stopBundles(bundleName.replaceAll("\\.", "\\\\."), null);
    }

    public void stopBundles(String includePattern, String excludePattern) throws BundleException {
        this.doWithBundles(includePattern, excludePattern, new IClosure(){

            @Override
            public void execute(Bundle bundle) throws BundleException {
                if (bundle.getState() == 32) {
                    bundle.stop();
                } else if (bundle.getState() != 1) {
                    Nop.reason("testcase tried to stop this bundle which did not run, but we can ignore this ==> bundle is stopped already");
                }
            }
        });
    }

    public void doWithBundles(String includePattern, String excludePattern, IClosure closure) throws BundleException {
        Bundle[] bundles;
        if (includePattern == null) {
            throw new UnsupportedOperationException("truePattern must be set");
        }
        if (excludePattern == null) {
            excludePattern = "";
        }
        Pattern include = Pattern.compile(includePattern);
        Pattern exclude = Pattern.compile(excludePattern);
        Bundle[] bundleArray = bundles = this.getContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (include.matcher(bundle.getSymbolicName()).matches() && !exclude.matcher(bundle.getSymbolicName()).matches()) {
                closure.execute(bundle);
            }
            ++n2;
        }
    }

    private class ExtensionRegistryChangeJobTracker
    extends JobChangeAdapter {
        private List<Job> jobs;

        private ExtensionRegistryChangeJobTracker() {
        }

        protected void start() {
            this.jobs = new ArrayList<Job>();
            Job.getJobManager().addJobChangeListener((IJobChangeListener)this);
        }

        protected void stop() {
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
        }

        protected void joinJobs() {
            for (Job job : this.jobs) {
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    throw new MurphysLawFailure("Joining jobs failed", e);
                }
            }
        }

        public void scheduled(IJobChangeEvent event) {
            if (event.getJob() instanceof ExtensionEventDispatcherJob) {
                this.jobs.add(event.getJob());
            }
        }
    }

    public static interface IClosure {
        public void execute(Bundle var1) throws BundleException;
    }

    static interface TestCaseWrapper {
        public String getName();

        public void fail(String var1);

        public void assertTrue(boolean var1);

        public void assertNotNull(Object var1);

        public Class<?> getTestClass();
    }
}

