/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class StatuslineSubModuleController
extends SubModuleController {
    private StatuslineModel model = new StatuslineModel();

    public StatuslineSubModuleController() {
        this(null);
    }

    public StatuslineSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    private ITextRidget getMessageText() {
        return (ITextRidget)this.getRidget(ITextRidget.class, "messageText");
    }

    private IComboRidget getSeverity() {
        return (IComboRidget)this.getRidget(IComboRidget.class, "severity");
    }

    private IActionRidget getShowMessage() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "showMessage");
    }

    private ITextRidget getNumberText() {
        return (ITextRidget)this.getRidget(ITextRidget.class, "numberText");
    }

    private IActionRidget getShowNumber() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "showNumber");
    }

    public void setModel(StatuslineModel model) {
        this.model = model;
    }

    public StatuslineModel getModel() {
        return this.model;
    }

    public void afterBind() {
        super.afterBind();
        this.bindModels();
    }

    private void bindModels() {
        this.getMessageText().bindToModel((Object)this.getModel(), "messageText");
        this.getMessageText().updateFromModel();
        this.getSeverity().bindToModel((Object)this.getModel(), "severities", Severity.class, null, (Object)this.getModel(), "severity");
        this.getSeverity().updateFromModel();
        this.getNumberText().bindToModel((Object)this.getModel(), "numberText");
        this.getNumberText().updateFromModel();
    }

    public void configureRidgets() {
        this.getShowMessage().addListener((IActionListener)new MessageListener());
        this.getShowNumber().addListener((IActionListener)new NumberListener());
    }

    private class MessageListener
    implements IActionListener {
        private MessageListener() {
        }

        public void callback() {
            StatuslineSubModuleController.this.getStatusline().clear();
            switch (StatuslineSubModuleController.this.getModel().getSeverity()) {
                case INFO: {
                    StatuslineSubModuleController.this.getStatusline().info(StatuslineSubModuleController.this.getMessageText().getText());
                    break;
                }
                case WARNING: {
                    StatuslineSubModuleController.this.getStatusline().warning(StatuslineSubModuleController.this.getMessageText().getText());
                    break;
                }
                case ERROR: {
                    StatuslineSubModuleController.this.getStatusline().error(StatuslineSubModuleController.this.getMessageText().getText());
                    break;
                }
                default: {
                    StatuslineSubModuleController.this.getStatusline().setMessage(StatuslineSubModuleController.this.getMessageText().getText());
                }
            }
        }
    }

    private class NumberListener
    implements IActionListener {
        private NumberListener() {
        }

        public void callback() {
            String text = StatuslineSubModuleController.this.getModel().getNumberText();
            try {
                int intValue = Integer.parseInt(text);
                StatuslineSubModuleController.this.getStatusline().getStatuslineNumberRidget().setNumber(Integer.valueOf(intValue));
            }
            catch (NumberFormatException numberFormatException) {
                StatuslineSubModuleController.this.getStatusline().getStatuslineNumberRidget().setNumberString(text);
            }
        }
    }

    public static enum Severity {
        TEXT("Text only"),
        INFO("Information"),
        WARNING("Warning"),
        ERROR("Error");

        private final String text;
        static final Severity[] SERVERITIES;

        static {
            SERVERITIES = new Severity[]{TEXT, INFO, WARNING, ERROR};
        }

        private Severity(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static class StatuslineModel {
        private String messageText = "Message";
        private String numberText = "4711";
        private Severity severity = Severity.TEXT;

        public void setMessageText(String messageText) {
            this.messageText = messageText;
        }

        public String getMessageText() {
            return this.messageText;
        }

        public void setSeverity(Severity severity) {
            this.severity = severity;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public List<Severity> getSeverities() {
            return Arrays.asList(Severity.SERVERITIES);
        }

        public void setNumberText(String numberText) {
            this.numberText = numberText;
        }

        public String getNumberText() {
            return this.numberText;
        }
    }
}

