/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.swt.RienaMessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class SystemPropertiesSubModuleController
extends SubModuleController {
    private final List<KeyValueBean> properties = new ArrayList<KeyValueBean>();
    private final KeyValueBean valueBean = new KeyValueBean();
    private final IActionListener doubleClickListener = new DoubleClickListener();
    private ITableRidget tableProperties;
    private ITextRidget textKey;
    private ITextRidget textValue;

    public SystemPropertiesSubModuleController() {
        this(null);
    }

    public SystemPropertiesSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void afterBind() {
        super.afterBind();
        this.bindModels();
    }

    private void bindModels() {
        this.tableProperties.bindToModel((IObservableList)new WritableList(this.properties, KeyValueBean.class), KeyValueBean.class, new String[]{"key", "value"}, new String[]{"Key", "Value"});
        this.tableProperties.updateFromModel();
        this.tableProperties.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.tableProperties.setComparator(0, (Comparator)new TypedComparator());
        this.tableProperties.setComparator(1, (Comparator)new TypedComparator());
        this.tableProperties.setMoveableColumns(true);
        if (!this.properties.isEmpty()) {
            this.tableProperties.setSelection(0);
        }
        this.textKey.bindToModel((Object)this.valueBean, "key");
        this.textKey.updateFromModel();
        this.textValue.bindToModel((Object)this.valueBean, "value");
        this.textValue.updateFromModel();
    }

    public void configureRidgets() {
        this.tableProperties = (ITableRidget)this.getRidget(ITableRidget.class, "tableProperties");
        this.textKey = (ITextRidget)this.getRidget(ITextRidget.class, "textKey");
        this.textValue = (ITextRidget)this.getRidget(ITextRidget.class, "textValue");
        IActionRidget buttonAdd = (IActionRidget)this.getRidget(IActionRidget.class, "buttonAdd");
        final IToggleButtonRidget toggleDoubleClick = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "toggleDoubleClick");
        IActionRidget buttonSave = (IActionRidget)this.getRidget(IActionRidget.class, "buttonSave");
        Set<Object> keys = System.getProperties().keySet();
        for (Object key : keys) {
            KeyValueBean bean = new KeyValueBean();
            bean.setKey((String)key);
            bean.setValue(System.getProperty((String)key));
            this.properties.add(bean);
        }
        this.tableProperties.addPropertyChangeListener("selection", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List selection = SystemPropertiesSubModuleController.this.tableProperties.getSelection();
                if (!selection.isEmpty()) {
                    SystemPropertiesSubModuleController.this.valueBean.setBean((KeyValueBean)((Object)selection.get(0)));
                    SystemPropertiesSubModuleController.this.textKey.updateFromModel();
                    SystemPropertiesSubModuleController.this.textValue.updateFromModel();
                }
            }
        });
        buttonAdd.setText("&Add");
        buttonAdd.addListener(new IActionListener(){
            private int count = 0;

            public void callback() {
                KeyValueBean bean = new KeyValueBean();
                bean.setKey("key" + ++this.count);
                bean.setValue("newValue");
                SystemPropertiesSubModuleController.this.properties.add(bean);
                SystemPropertiesSubModuleController.this.tableProperties.updateFromModel();
                SystemPropertiesSubModuleController.this.tableProperties.setSelection((Object)bean);
                ((Table)SystemPropertiesSubModuleController.this.tableProperties.getUIControl()).showSelection();
            }
        });
        toggleDoubleClick.setText("Handle &Double Click");
        toggleDoubleClick.addListener(new IActionListener(){

            public void callback() {
                if (toggleDoubleClick.isSelected()) {
                    SystemPropertiesSubModuleController.this.tableProperties.addDoubleClickListener(SystemPropertiesSubModuleController.this.doubleClickListener);
                } else {
                    SystemPropertiesSubModuleController.this.tableProperties.removeDoubleClickListener(SystemPropertiesSubModuleController.this.doubleClickListener);
                }
            }
        });
        buttonSave.setText("&Save");
        buttonSave.addListener(new IActionListener(){

            public void callback() {
                SystemPropertiesSubModuleController.this.valueBean.update();
                SystemPropertiesSubModuleController.this.tableProperties.updateFromModel();
            }
        });
    }

    private final class DoubleClickListener
    implements IActionListener {
        private DoubleClickListener() {
        }

        public void callback() {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            String message = "The key ''{0}'' is selected and has the value ''{1}''";
            message = NLS.bind((String)message, (Object)SystemPropertiesSubModuleController.this.valueBean.getKey(), (Object)SystemPropertiesSubModuleController.this.valueBean.getValue());
            RienaMessageDialog.openInformation((Shell)shell, (String)"Information", (String)message);
        }
    }

    public static final class KeyValueBean
    extends AbstractBean {
        private KeyValueBean bean;
        private String tempKey;
        private String tempValue;

        public String getKey() {
            return this.tempKey;
        }

        public void setKey(String key) {
            this.tempKey = key;
        }

        public String getValue() {
            return this.tempValue;
        }

        public void setValue(String value) {
            this.tempValue = value;
        }

        public void setBean(KeyValueBean bean) {
            this.bean = bean;
            this.setKey(bean.getKey());
            this.setValue(bean.getValue());
        }

        public void update() {
            this.bean.setKey(this.tempKey);
            this.bean.setValue(this.tempValue);
        }
    }
}

