/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.riena.internal.navigation.ui.swt.CoolbarUtils;
import org.eclipse.riena.navigation.ui.swt.component.IEntriesProvider;
import org.eclipse.riena.navigation.ui.swt.component.ToolBarMenuListener;
import org.eclipse.riena.ui.ridgets.swt.MenuManagerHelper;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindow;

public class MenuCoolBarComposite
extends Composite {
    static final String MENU_DATA_KEY = "Menu";
    private CoolItem menuCoolItem;
    private ToolBar menuToolBar;
    private CoolBar menuCoolBar;
    private final IEntriesProvider provider;

    @Deprecated
    public MenuCoolBarComposite(Composite parent, int style, final IWorkbenchWindow window) {
        this(parent, style, new IEntriesProvider(){

            @Override
            public IContributionItem[] getTopLevelEntries() {
                if (window instanceof WorkbenchWindow) {
                    MenuManager menuManager = ((WorkbenchWindow)window).getMenuManager();
                    return menuManager.getItems();
                }
                return new IContributionItem[0];
            }
        });
    }

    public MenuCoolBarComposite(Composite parent, int style, IEntriesProvider provider) {
        super(parent, style);
        this.provider = provider;
        this.setLayout((Layout)new FillLayout());
        this.create();
    }

    public List<ToolItem> getTopLevelItems() {
        ToolItem[] toolItems = this.menuToolBar.getItems();
        return Arrays.asList(toolItems);
    }

    public List<ToolItem> updateMenuItems() {
        if (this.menuCoolBar != null) {
            this.menuCoolBar.dispose();
        }
        this.create();
        this.layout();
        return Collections.emptyList();
    }

    private void calcSize(CoolItem item) {
        Control control = item.getControl();
        Point pt = control.computeSize(-1, -1);
        pt = item.computeSize(pt.x, pt.y);
        item.setSize(pt);
    }

    private ToolItem createAndAddMenu(MenuManager menuManager, ToolBarMenuListener listener) {
        if (menuManager.isVisible()) {
            ToolItem toolItem = new ToolItem(this.menuToolBar, 32);
            toolItem.setText(menuManager.getMenuText());
            MenuManagerHelper helper = new MenuManagerHelper();
            Menu menu = helper.createMenu((Composite)this.menuToolBar, toolItem, menuManager);
            toolItem.setData(MENU_DATA_KEY, (Object)menu);
            this.calcSize(this.menuCoolItem);
            toolItem.addSelectionListener((SelectionListener)listener);
            return toolItem;
        }
        return null;
    }

    private void create() {
        this.menuCoolBar = new CoolBar((Composite)this, 0x800000);
        this.menuCoolItem = CoolbarUtils.initCoolBar(this.menuCoolBar, this.getMenuBarFont());
        this.menuToolBar = (ToolBar)this.menuCoolItem.getControl();
        ToolBarMenuListener listener = new ToolBarMenuListener();
        this.menuToolBar.addMouseListener((MouseListener)listener);
        SWTFacade.getDefault().addMouseTrackListener((Control)this.menuToolBar, (MouseTrackListener)listener);
        this.menuToolBar.addTraverseListener((TraverseListener)listener);
        this.fillMenuBar(listener);
    }

    private void fillMenuBar(ToolBarMenuListener listener) {
        IContributionItem[] iContributionItemArray = this.provider.getTopLevelEntries();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contribItem = iContributionItemArray[n2];
            if (contribItem instanceof MenuManager) {
                this.createAndAddMenu((MenuManager)contribItem, listener);
            }
            ++n2;
        }
    }

    private Font getMenuBarFont() {
        return LnfManager.getLnf().getFont("Menubar.font");
    }
}

