/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.navigation.ui.swt.CoolbarUtils;
import org.eclipse.riena.internal.navigation.ui.swt.IAdvisorHelper;
import org.eclipse.riena.internal.navigation.ui.swt.RestoreFocusOnEscListener;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.IApplicationNodeListener;
import org.eclipse.riena.navigation.listener.IModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.ISubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.navigation.ui.swt.component.TitleComposite;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.EmbeddedBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ShellRenderer;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.presentation.stack.TitlelessStackPresentation;
import org.eclipse.riena.navigation.ui.swt.statusline.IStatuslineContentFactoryExtension;
import org.eclipse.riena.navigation.ui.swt.views.DefaultWindowNavigator;
import org.eclipse.riena.navigation.ui.swt.views.IWindowNavigator;
import org.eclipse.riena.navigation.ui.swt.views.IWindowNavigatorExtension;
import org.eclipse.riena.navigation.ui.swt.views.NavigationViewPart;
import org.eclipse.riena.navigation.ui.swt.views.ShellPaintListener;
import org.eclipse.riena.navigation.ui.swt.views.UIViewFailure;
import org.eclipse.riena.ui.filter.IUIFilter;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.swt.DefaultStatuslineContentFactory;
import org.eclipse.riena.ui.swt.GrabCorner;
import org.eclipse.riena.ui.swt.IStatusLineContentFactory;
import org.eclipse.riena.ui.swt.InfoFlyout;
import org.eclipse.riena.ui.swt.Statusline;
import org.eclipse.riena.ui.swt.StatuslineSpacer;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.separator.Separator;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.ShellHelper;
import org.eclipse.riena.ui.swt.utils.TestingSupport;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.riena.ui.swt.utils.WidgetIdentificationSupport;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationViewAdvisor
extends WorkbenchWindowAdvisor {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ApplicationViewAdvisor.class);
    private static final String INFO_FLYOUT_BINDING_ID = "infoFlyout";
    private static final String PROPERTY_RIENA_APPLICATION_WIDTH = "riena.application.width";
    private static final String PROPERTY_RIENA_APPLICATION_HEIGHT = "riena.application.height";
    private static final String PROPERTY_RIENA_APPLICATION_MINIMUM_WIDTH = "riena.application.minimum.width";
    private static final String PROPERTY_RIENA_APPLICATION_MINIMUM_HEIGHT = "riena.application.minimum.height";
    private static final int DEFAULT_COOLBAR_TOP_MARGIN = 2;
    public static final String SHELL_RIDGET_PROPERTY = "applicationWindow";
    private final ApplicationController controller;
    private final AbstractViewBindingDelegate binding;
    private final IAdvisorHelper advisorHelper;
    private TitleComposite titleComposite;
    private IStatusLineContentFactory statuslineContentFactory;
    private IWindowNavigator windowNavigator;
    private Point applicationSizeMinimum;

    public ApplicationViewAdvisor(IWorkbenchWindowConfigurer configurer, ApplicationController pController, IAdvisorHelper helper) {
        super(configurer);
        this.controller = pController;
        this.binding = this.createBinding();
        this.advisorHelper = helper;
        this.initializeListener();
    }

    public void addUIControl(Composite control, String propertyName) {
        this.binding.addUIControl((Object)control, propertyName);
    }

    @InjectExtension(min=0, max=1)
    public void updateStatuslineContentFactory(IStatuslineContentFactoryExtension statuslineContentFactoryExtension) {
        this.statuslineContentFactory = statuslineContentFactoryExtension == null ? new DefaultStatuslineContentFactory() : statuslineContentFactoryExtension.createFactory();
    }

    public IStatusLineContentFactory getStatuslineContentFactory() {
        return this.statuslineContentFactory;
    }

    @InjectExtension(min=0, max=1)
    public void updateWindowNavigator(IWindowNavigatorExtension windowNavigatorExtension) {
        this.windowNavigator = windowNavigatorExtension == null ? new DefaultWindowNavigator() : windowNavigatorExtension.createWindowNavigator();
    }

    private IWindowNavigator getWindowNavigator() {
        return this.windowNavigator;
    }

    public final ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return this.advisorHelper.createActionBarAdvisor(configurer);
    }

    public void createWindowContents(Shell shell) {
        this.initShell(shell);
        shell.setLayout((Layout)new FormLayout());
        GrabCorner grabCorner = this.createGrabCorner(shell);
        this.createStatusLine((Composite)shell, (Composite)grabCorner);
        this.titleComposite = this.createTitleComposite(shell);
        Composite menuBarComposite = this.createMenuBarComposite((Composite)shell, this.titleComposite);
        Composite coolBarComposite = this.createCoolBarComposite((Composite)shell, menuBarComposite);
        Composite mainComposite = this.createMainComposite((Composite)shell, coolBarComposite);
        this.createInfoFlyout(mainComposite);
        RestoreFocusOnEscListener focusListener = new RestoreFocusOnEscListener(shell);
        focusListener.addControl(RestoreFocusOnEscListener.findCoolBar(menuBarComposite));
        focusListener.addControl(RestoreFocusOnEscListener.findCoolBar(coolBarComposite));
    }

    private void createInfoFlyout(Composite mainComposite) {
        InfoFlyout flyout = UIControlsFactory.createInfoFlyout((Composite)mainComposite);
        this.binding.addUIControl((Object)flyout, INFO_FLYOUT_BINDING_ID);
    }

    public void dispose() {
        super.dispose();
        if (this.titleComposite != null) {
            this.titleComposite.dispose();
            this.titleComposite = null;
        }
    }

    public void preWindowOpen() {
        this.configureWindow();
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        Shell shell = this.getWindowConfigurer().getWindow().getShell();
        if (SWTFacade.isRAP()) {
            shell.setMaximized(true);
        } else {
            this.getWindowNavigator().beforeOpen(shell);
        }
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        this.doInitialBinding();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        this.updateApplicationSize(configurer);
        if (this.titleComposite != null) {
            this.titleComposite.setRedraw(false);
            this.titleComposite.setRedraw(true);
        }
    }

    public boolean preWindowShellClose() {
        this.getWindowNavigator().beforeClose(this.getWindowConfigurer().getWindow().getShell());
        return super.preWindowShellClose();
    }

    private void updateApplicationSize(IWorkbenchWindowConfigurer configurer) {
        Shell shell = configurer.getWindow().getShell();
        Rectangle maxBounds = ShellHelper.calcMaxBounds((Shell)shell);
        boolean update = false;
        int x = shell.getLocation().x;
        int width = shell.getBounds().width;
        if (width > maxBounds.width) {
            x = maxBounds.x;
            width = maxBounds.width;
            LOGGER.log(2, "The width of the application is greater than the maximum width which is " + width);
            update = true;
        }
        int y = shell.getLocation().y;
        int height = shell.getBounds().height;
        if (height > maxBounds.height) {
            y = maxBounds.y;
            height = maxBounds.height;
            LOGGER.log(2, "The height of the application is greater than the maximum height which is " + height);
            update = true;
        }
        Point minSize = shell.getMinimumSize();
        if (minSize.x > maxBounds.width) {
            minSize.x = maxBounds.width;
            update = true;
        }
        if (minSize.y > maxBounds.height) {
            minSize.y = maxBounds.height;
            update = true;
        }
        if (update) {
            shell.setLocation(x, y);
            shell.setMinimumSize(minSize);
            shell.setSize(width, height);
        }
    }

    protected AbstractViewBindingDelegate createBinding() {
        return new InjectSwtViewBindingDelegate();
    }

    private void initializeListener() {
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((IApplicationNodeListener)new MyApplicationNodeListener());
        navigationTreeObserver.addListener((ISubApplicationNodeListener)new MySubApplicationNodeListener());
        navigationTreeObserver.addListener((IModuleGroupNodeListener)new MyModuleGroupNodeListener());
        navigationTreeObserver.addListener((IModuleNodeListener)new MyModuleNodeListener());
        navigationTreeObserver.addListener((ISubModuleNodeListener)new MySubModuleNodeListener());
        navigationTreeObserver.addListenerTo((IApplicationNode)this.controller.getNavigationNode());
    }

    private void configureWindow() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        String label = ((IApplicationNode)this.controller.getNavigationNode()).getLabel();
        if (label != null) {
            configurer.setTitle(label);
        }
        this.initApplicationSize(configurer);
        if (LnfManager.getLnf().getBooleanSetting("Shell.hideOsBorder").booleanValue() && !TestingSupport.isTestingEnabled()) {
            configurer.setShellStyle(0x20000008);
        }
    }

    private void initApplicationSize(IWorkbenchWindowConfigurer configurer) {
        int height;
        int width = Integer.getInteger(PROPERTY_RIENA_APPLICATION_WIDTH, this.getApplicationSizeMinimum().x);
        if (width < this.getApplicationSizeMinimum().x) {
            width = this.getApplicationSizeMinimum().x;
            LOGGER.log(2, "The initial width of the application is less than the minimum width which is " + this.getApplicationSizeMinimum().x);
        }
        if ((height = Integer.getInteger(PROPERTY_RIENA_APPLICATION_HEIGHT, this.getApplicationSizeMinimum().y).intValue()) < this.getApplicationSizeMinimum().y) {
            height = this.getApplicationSizeMinimum().y;
            LOGGER.log(2, "The initial height of the application is less than the minimum height which is " + this.getApplicationSizeMinimum().y);
        }
        configurer.setInitialSize(new Point(width, height));
    }

    private void initApplicationSizeMinimum() {
        int widthMinimum = Integer.getInteger(PROPERTY_RIENA_APPLICATION_MINIMUM_WIDTH, this.getApplicationDefaultSizeMinimum().x);
        int heightMinimum = Integer.getInteger(PROPERTY_RIENA_APPLICATION_MINIMUM_HEIGHT, this.getApplicationDefaultSizeMinimum().y);
        this.applicationSizeMinimum = new Point(widthMinimum, heightMinimum);
    }

    private Point getApplicationSizeMinimum() {
        if (this.applicationSizeMinimum == null) {
            this.initApplicationSizeMinimum();
        }
        return this.applicationSizeMinimum;
    }

    private Point getApplicationDefaultSizeMinimum() {
        return (Point)LnfManager.getLnf().getSetting("riena.application.size.minimum");
    }

    private void doInitialBinding() {
        this.binding.injectAndBind((IController)this.controller);
        this.controller.afterBind();
    }

    private void createStatusLine(Composite shell, Composite grabCorner) {
        IStatusLineContentFactory statusLineFactory = this.getStatuslineContentFactory();
        Statusline statusLine = new Statusline(shell, 0, StatuslineSpacer.class, statusLineFactory);
        FormData fd = new FormData();
        fd.height = LnfManager.getLnf().getIntegerSetting("statusline.height");
        Rectangle navigationBounds = TitlelessStackPresentation.calcNavigationBounds(shell);
        fd.left = new FormAttachment(0, navigationBounds.x);
        if (grabCorner != null) {
            fd.right = new FormAttachment((Control)grabCorner, 0);
        } else {
            int padding = this.getShellPadding();
            fd.right = new FormAttachment(100, -padding);
        }
        fd.bottom = new FormAttachment(100, -5);
        statusLine.setLayoutData((Object)fd);
        this.addUIControl((Composite)statusLine, "statusline");
        LnFUpdater.getInstance().updateUIControls((Composite)statusLine, true);
    }

    private void initShell(Shell shell) {
        shell.setBackground(LnfManager.getLnf().getColor("TitlelessShell.background"));
        shell.addPaintListener((PaintListener)new ShellPaintListener());
        String iconName = ((IApplicationNode)this.controller.getNavigationNode()).getIcon();
        shell.setImage(ImageStore.getInstance().getImage(iconName));
        shell.setMinimumSize(this.getApplicationSizeMinimum());
        this.addUIControl((Composite)shell, SHELL_RIDGET_PROPERTY);
        if (this.getShellRenderer() != null) {
            this.getShellRenderer().setShell(shell);
        }
        WidgetIdentificationSupport.setIdentification((Shell)shell);
    }

    private TitleComposite createTitleComposite(Shell parentShell) {
        ApplicationNode node = (ApplicationNode)this.controller.getNavigationNode();
        return new TitleComposite((Composite)parentShell, node);
    }

    private GrabCorner createGrabCorner(Shell shell) {
        if (GrabCorner.isResizeable() && LnfManager.getLnf().getBooleanSetting("Shell.hideOsBorder").booleanValue()) {
            return new GrabCorner((Composite)shell, 0x20000000);
        }
        return null;
    }

    private Composite createMenuBarComposite(Composite parent, Composite previous) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = this.getShellPadding();
        IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        MenuCoolBarComposite composite = new MenuCoolBarComposite(parent, 0, window);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)previous, this.getMenuBarTopMargin());
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        composite.setLayoutData(formData);
        return composite;
    }

    private Composite createCoolBarComposite(Composite parent, Composite previous) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        Separator separator = UIControlsFactory.createSeparator((Composite)parent, (int)256);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)previous);
        formData.left = new FormAttachment(0, 2);
        formData.right = new FormAttachment(100, -2);
        formData.height = 2;
        separator.setLayoutData((Object)formData);
        previous = separator;
        int padding = this.getShellPadding();
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new FillLayout());
        formData = new FormData();
        formData.top = new FormAttachment((Control)previous, this.getToolBarTopMargin());
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        result.setLayoutData((Object)formData);
        Control control = this.getWindowConfigurer().createCoolBarControl(result);
        if (control instanceof CoolBar) {
            CoolBar coolbar = (CoolBar)control;
            CoolbarUtils.initCoolBar(coolbar, ApplicationViewAdvisor.getToolbarFont());
        }
        return result;
    }

    private static Font getToolbarFont() {
        return LnfManager.getLnf().getFont("Toolbar.font");
    }

    private int getCoolBarSeparatorPadding() {
        ModuleGroupRenderer mgRenderer = (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
        if (mgRenderer == null) {
            mgRenderer = new ModuleGroupRenderer();
        }
        int padding = mgRenderer.getModuleGroupPadding();
        EmbeddedBorderRenderer borderRenderer = (EmbeddedBorderRenderer)LnfManager.getLnf().getRenderer("SubModuleView.borderRenderer");
        if (borderRenderer == null) {
            borderRenderer = new EmbeddedBorderRenderer();
        }
        padding += borderRenderer.getBorderWidth();
        return padding += this.getShellPadding();
    }

    private Composite createMainComposite(Composite parent, Composite previous) {
        Assert.isTrue((boolean)(parent.getLayout() instanceof FormLayout));
        int padding = this.getShellPadding();
        Composite composite = new Composite(parent, 0x20000000);
        composite.setLayout((Layout)new FillLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)previous, LnfManager.getLnf().getIntegerSetting("toolbar.workarea.vertical.gap").intValue(), 0);
        formData.bottom = new FormAttachment(100, -padding);
        formData.left = new FormAttachment(0, padding);
        formData.right = new FormAttachment(100, -padding);
        composite.setLayoutData((Object)formData);
        this.getWindowConfigurer().createPageComposite(composite);
        return composite;
    }

    private int getShellPadding() {
        ShellBorderRenderer borderRenderer = (ShellBorderRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.borderRenderer");
        return borderRenderer.getCompleteBorderWidth();
    }

    private ShellRenderer getShellRenderer() {
        ShellRenderer shellRenderer = (ShellRenderer)LnfManager.getLnf().getRenderer("TitlelessShell.renderer");
        return shellRenderer;
    }

    private int getMenuBarTopMargin() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        return lnf.getIntegerSetting("Menubar.topMargin", Integer.valueOf(2));
    }

    private int getToolBarTopMargin() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        return lnf.getIntegerSetting("Toolbar.topMargin", Integer.valueOf(2));
    }

    private void prepare(INavigationNode<?> node) {
        if (node == null || node.getParent() == null) {
            return;
        }
        if (node instanceof ISubModuleNode) {
            ISubModuleNode subModuleNode = (ISubModuleNode)node;
            IWorkareaDefinition definition = WorkareaManager.getInstance().getDefinition((Object)subModuleNode);
            if (definition != null && definition.isRequiredPreparation() && subModuleNode.isCreated()) {
                subModuleNode.prepare();
            }
        }
        ArrayList children = new ArrayList(node.getChildren());
        for (INavigationNode child : children) {
            this.prepare(child);
        }
    }

    static enum BtnState {
        NONE,
        HOVER,
        HOVER_SELECTED;

    }

    private class MyApplicationNodeListener
    extends ApplicationNodeListener {
        private MyApplicationNodeListener() {
        }

        public void filterAdded(IApplicationNode source, IUIFilter filter) {
            this.show();
        }

        public void filterRemoved(IApplicationNode source, IUIFilter filter) {
            this.show();
        }

        private void show() {
            if (ApplicationViewAdvisor.this.controller == null || ApplicationViewAdvisor.this.controller.getNavigationNode() == null || ((IApplicationNode)ApplicationViewAdvisor.this.controller.getNavigationNode()).isDisposed()) {
                return;
            }
            try {
                IViewPart vp = this.getNavigationViewPart();
                if (vp == null) {
                    NavigationViewPart navi = (NavigationViewPart)this.getActivePage().showView("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart");
                    navi.updateNavigationSize();
                }
            }
            catch (PartInitException e) {
                throw new UIViewFailure(e.getMessage(), e);
            }
        }

        private IWorkbenchPage getActivePage() {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }

        private IViewPart getNavigationViewPart() {
            IViewReference[] references;
            IViewReference[] iViewReferenceArray = references = this.getActivePage().getViewReferences();
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewReference = iViewReferenceArray[n2];
                if (viewReference.getId().equals("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart")) {
                    return viewReference.getView(true);
                }
                ++n2;
            }
            return null;
        }
    }

    private class MyModuleGroupNodeListener
    extends ModuleGroupNodeListener {
        private MyModuleGroupNodeListener() {
        }

        public void activated(IModuleGroupNode source) {
            ApplicationViewAdvisor.this.prepare((INavigationNode)source);
            super.activated((INavigationNode)source);
        }

        public void parentChanged(IModuleGroupNode source) {
            super.parentChanged((INavigationNode)source);
            ApplicationViewAdvisor.this.prepare((INavigationNode)source);
        }
    }

    private class MyModuleNodeListener
    extends ModuleNodeListener {
        private MyModuleNodeListener() {
        }

        public void activated(IModuleNode source) {
            ApplicationViewAdvisor.this.prepare((INavigationNode)source);
            super.activated((INavigationNode)source);
        }

        public void parentChanged(IModuleNode source) {
            super.parentChanged((INavigationNode)source);
            ApplicationViewAdvisor.this.prepare((INavigationNode)source);
        }
    }

    private class MySubApplicationNodeListener
    extends SubApplicationNodeListener {
        private MySubApplicationNodeListener() {
        }

        public void activated(ISubApplicationNode source) {
            if (source != null) {
                this.showPerspective(source);
                if (ApplicationViewAdvisor.this.titleComposite != null) {
                    ApplicationViewAdvisor.this.titleComposite.setRedraw(false);
                    ApplicationViewAdvisor.this.titleComposite.setRedraw(true);
                }
                ApplicationViewAdvisor.this.prepare((INavigationNode)source);
            }
            super.activated((INavigationNode)source);
        }

        private void showPerspective(ISubApplicationNode source) {
            try {
                PlatformUI.getWorkbench().showPerspective(SwtViewProvider.getInstance().getSwtViewId((INavigationNode<?>)source).getId(), PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            catch (WorkbenchException e) {
                throw new UIViewFailure(e.getMessage(), e);
            }
        }

        public void disposed(ISubApplicationNode source) {
            SwtViewProvider viewProvider = SwtViewProvider.getInstance();
            String id = viewProvider.getSwtViewId((INavigationNode<?>)source).getId();
            IWorkbench workbench = PlatformUI.getWorkbench();
            IPerspectiveRegistry registry = workbench.getPerspectiveRegistry();
            IPerspectiveDescriptor perspDesc = registry.findPerspectiveWithId(id);
            workbench.getActiveWorkbenchWindow().getActivePage().closePerspective(perspDesc, false, false);
            viewProvider.unregisterSwtViewId((INavigationNode<?>)source);
        }
    }

    private class MySubModuleNodeListener
    extends SubModuleNodeListener {
        private MySubModuleNodeListener() {
        }

        public void activated(ISubModuleNode source) {
            ApplicationViewAdvisor.this.prepare((INavigationNode)source);
            super.activated((INavigationNode)source);
        }

        public void parentChanged(ISubModuleNode source) {
            super.parentChanged((INavigationNode)source);
            ApplicationViewAdvisor.this.prepare((INavigationNode)source);
        }
    }
}

