/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import org.eclipse.riena.core.util.StringUtils;

public class NavigationNodeId {
    private final String instanceId;
    private final String typeId;
    private int hash = 0;

    public NavigationNodeId(String typeId, String instanceId) {
        if (!this.checkId(typeId)) {
            throw new IllegalArgumentException("ID with illegal characters: " + typeId);
        }
        this.typeId = typeId;
        this.instanceId = instanceId;
    }

    public NavigationNodeId(String typeId) {
        this(typeId, null);
    }

    public String getTypeId() {
        return this.typeId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        NavigationNodeId otherId = (NavigationNodeId)other;
        return StringUtils.equals((CharSequence)this.typeId, (CharSequence)otherId.typeId) && StringUtils.equals((CharSequence)this.instanceId, (CharSequence)otherId.instanceId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NavigationNodeId [typeId=").append(this.typeId).append(", instanceId=").append(this.instanceId).append("]");
        return builder.toString();
    }

    public int hashCode() {
        if (this.hash == 0) {
            if (this.typeId != null) {
                this.hash += this.typeId.hashCode();
            }
            if (this.instanceId != null) {
                this.hash += this.instanceId.hashCode();
            }
        }
        return this.hash;
    }

    private boolean checkId(String id) {
        if (id == null) {
            return true;
        }
        if (id.indexOf(42) != -1) {
            return false;
        }
        if (id.indexOf(63) != -1) {
            return false;
        }
        return id.indexOf(47) == -1;
    }
}

