/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.beans.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractBean {
    protected Set<PropertyChangeListener> propertyChangeListeners = new HashSet<PropertyChangeListener>();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    protected void removeAllPropertyChangeListeners() {
        this.propertyChangeListeners.clear();
    }

    protected void firePropertyChanged(String aProperty, Object oldValue, Object newValue) {
        this.firePropertyChanged(new PropertyChangeEvent(this, aProperty, oldValue, newValue));
    }

    protected void firePropertyChanged(PropertyChangeEvent event) {
        ArrayList<PropertyChangeListener> tmpListeners = new ArrayList<PropertyChangeListener>(this.propertyChangeListeners);
        for (PropertyChangeListener listener : tmpListeners) {
            listener.propertyChange(event);
        }
    }

    protected boolean hasListener() {
        return this.propertyChangeListeners.size() > 0;
    }
}

