/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.beans.common;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.riena.beans.common.PropertyAccessFailure;

public final class BeanPropertyAccessor {
    private BeanPropertyAccessor() {
    }

    public static Object getPropertyValue(Object bean, PropertyDescriptor descriptor) {
        if (descriptor == null) {
            throw new AssertionFailedException("descriptor cannot be null");
        }
        Method readMethod = descriptor.getReadMethod();
        if (readMethod == null) {
            throw new UnsupportedOperationException("Property '" + descriptor.getName() + "' has no getter method");
        }
        if (!readMethod.isAccessible()) {
            readMethod.setAccessible(true);
        }
        try {
            return readMethod.invoke(bean, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessFailure("unexpected error getting the property", e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessFailure("unexpected error getting the property", e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessFailure("unexpected error getting the property", e);
        }
    }

    public static void setPropertyValue(Object bean, PropertyDescriptor descriptor, Object value) {
        Method writeMethod = descriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new UnsupportedOperationException("Property '" + descriptor.getName() + "' has no setter method");
        }
        if (!writeMethod.isAccessible()) {
            writeMethod.setAccessible(true);
        }
        Object[] values = new Object[]{value};
        try {
            writeMethod.invoke(bean, values);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessFailure("unexpected error setting the property", e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessFailure("unexpected error setting the property", e);
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessFailure("unexpected error setting the property", e);
        }
    }
}

