/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.hooks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.Cookie;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.hooks.IServiceMessageContext;

public class ServiceContext {
    private RemoteServiceDescription rsd;
    private String method;
    private HashMap<String, Object> properties;
    private IServiceMessageContext messageContext;

    public ServiceContext(RemoteServiceDescription rsd, String method, IServiceMessageContext messageContext) {
        this.rsd = rsd;
        this.method = method;
        this.messageContext = messageContext;
    }

    public String getInterfaceName() {
        return this.rsd.getServiceInterfaceClassName();
    }

    public String getMethodName() {
        return this.method;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public IServiceMessageContext getMessageContext() {
        return this.messageContext;
    }

    public Cookie[] getCookies() {
        List<String> cookieValues = this.messageContext.getRequestHeaderValue("Cookie");
        if (cookieValues == null || cookieValues.size() == 0) {
            return null;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (String temp : cookieValues) {
            cookies.add(new Cookie(temp.substring(0, temp.indexOf("=")), temp.substring(temp.indexOf("=") + 1)));
        }
        return cookies.toArray(new Cookie[cookies.size()]);
    }

    public void addCookie(Cookie cookie) {
        this.messageContext.addResponseHeader("Set-Cookie", String.valueOf(cookie.getName()) + "=" + cookie.getValue());
    }
}

