/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.core;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.riena.communication.core.IRemoteServiceRegistry;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitorRegistry;
import org.eclipse.riena.communication.core.progressmonitor.ProgressMonitorRegistryImpl;
import org.eclipse.riena.communication.core.ssl.SSLConfiguration;
import org.eclipse.riena.core.RienaActivator;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.core.extension.ExtensionInjector;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.communication.core.registry.RemoteServiceRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends RienaActivator {
    public static final String PLUGIN_ID = "org.eclipse.riena.communication.core";
    private RemoteServiceRegistry serviceRegistry;
    private ServiceRegistration regServiceRegistry;
    private ServiceReference sslConfigServiceReference;
    private ExtensionInjector sslInjector;
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.serviceRegistry = new RemoteServiceRegistry();
        this.serviceRegistry.start();
        Hashtable properties = RienaConstants.newDefaultServiceProperties();
        this.regServiceRegistry = context.registerService(IRemoteServiceRegistry.class.getName(), (Object)this.serviceRegistry, (Dictionary)properties);
        context.registerService(SSLConfiguration.class.getName(), (Object)new SSLConfiguration(), (Dictionary)RienaConstants.newDefaultServiceProperties());
        this.sslConfigServiceReference = context.getServiceReference(SSLConfiguration.class.getName());
        SSLConfiguration config = (SSLConfiguration)context.getService(this.sslConfigServiceReference);
        if (config != null) {
            this.sslInjector = Inject.extension((String)"org.eclipse.riena.communication.core.ssl").expectingMinMax(0, 1).into((Object)config).update("configure");
            this.sslInjector.andStart(context);
        }
        context.registerService(IRemoteProgressMonitorRegistry.class.getName(), (Object)new ProgressMonitorRegistryImpl(), null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.sslInjector != null) {
            this.sslInjector.stop();
        }
        if (this.sslConfigServiceReference != null) {
            context.ungetService(this.sslConfigServiceReference);
        }
        this.regServiceRegistry.unregister();
        this.regServiceRegistry = null;
        this.serviceRegistry.stop();
        this.serviceRegistry = null;
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

