/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.publisher.hessian;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.publisher.IServicePublisher;
import org.eclipse.riena.core.RienaActivator;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.internal.communication.publisher.hessian.HessianRemoteServicePublisher;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends RienaActivator {
    private ServiceRegistration publisherReg;
    private HessianRemoteServicePublisher publisher;
    private Logger logger;
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.logger = this.getLogger(Activator.class);
        this.logger.log(3, "start hessian support on server");
        this.publisher = new HessianRemoteServicePublisher();
        Hashtable properties = RienaConstants.newDefaultServiceProperties();
        properties.put("riena.protocol", this.publisher.getProtocol());
        this.publisherReg = context.registerService(IServicePublisher.class.getName(), (Object)this.publisher, (Dictionary)properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.publisherReg.unregister();
        this.publisherReg = null;
        this.publisher = null;
        this.logger.log(3, "stop hessian support on server");
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public HessianRemoteServicePublisher getPublisher() {
        return this.publisher;
    }
}

