/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.riena.core.util.StringUtils;
import org.osgi.framework.Bundle;

public final class RienaLocations {
    public static final String RIENA_NAME = "riena";

    private RienaLocations() {
    }

    public static File getDataArea() {
        Location installLocation = Platform.getInstallLocation();
        Assert.isLegal((installLocation != null ? 1 : 0) != 0, (String)"Platform.getInstallLocation() should not be null.");
        File dataArea = new File(installLocation.getURL().getFile(), RIENA_NAME);
        if (dataArea.isDirectory()) {
            return dataArea;
        }
        boolean created = dataArea.mkdirs();
        Assert.isLegal((boolean)created, (String)"data area is not a directory or does not exist.");
        return dataArea;
    }

    public static File getDataArea(Bundle bundle) {
        Assert.isLegal((bundle != null ? 1 : 0) != 0, (String)"bundle must not be null.");
        String symbolicName = bundle.getSymbolicName();
        Assert.isLegal((boolean)StringUtils.isGiven(symbolicName), (String)"no symbolic name for bundle.");
        File dataArea = new File(RienaLocations.getDataArea(), symbolicName);
        if (dataArea.isDirectory()) {
            return dataArea;
        }
        boolean created = dataArea.mkdirs();
        Assert.isLegal((boolean)created, (String)"data area is not a directory or does not exist.");
        return dataArea;
    }
}

