/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.exception;

import java.text.MessageFormat;
import java.util.Date;

public abstract class Failure
extends RuntimeException {
    private static final long serialVersionUID = -4261070069626717501L;
    private static final String UNKNOWN = "<unknown>";
    private static final String NONE = "<none>";
    private static final String NO_DETAILS = "No details.";
    public static final String VERSION_ID = "$Id: Failure.java,v 1.8 2009/01/07 14:47:07 sliebig Exp $";
    private String javaVersion = "<unknown>";
    private String callerClassName = "<unknown>";
    private String callerClassVersion = "<unknown>";
    private String callerMethodName = "<unknown>";
    private String id = "";
    private Date timestamp;
    private String clientMsg = "";
    private String serverMsg = "";
    private String nativeErrorCode = "<none>";
    private static final int HEX_BASE = 16;
    static final String[] MESSAGE_PART_NAMES = new String[]{"serverMsg", "cause", "id", "timestamp", "callerClassName", "callerClassVersion", "callerMethodName", "nativeErrorCode", "clientMsg", "javaVersion", "stacktrace"};

    public Failure(String msg, Object[] args, Throwable cause) {
        super(msg, cause);
        this.setDetails(msg, args);
    }

    public Failure(String msg) {
        super(msg);
        this.setDetails(msg, null);
    }

    public Failure(String msg, Throwable cause) {
        this(msg, null, cause);
    }

    public Failure(String msg, Object arg1, Throwable cause) {
        this(msg, new Object[]{arg1}, cause);
    }

    public Failure(String msg, Object arg1, Object arg2, Throwable cause) {
        this(msg, new Object[]{arg1, arg2}, cause);
    }

    private void setDetails(String msg, Object[] args) {
        this.setTimestamp(new Date());
    }

    private String getFormattedMsgText(String msg, Object[] args) {
        if (msg == null || args == null) {
            return msg;
        }
        return new MessageFormat(msg).format(args);
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    private void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    private void setCallerClassName(String callerClassName) {
        this.callerClassName = callerClassName;
    }

    public String getCallerClassName() {
        return this.callerClassName;
    }

    private void setCallerClassVersion(String callerClassVersion) {
        this.callerClassVersion = callerClassVersion;
    }

    public String getCallerClassVersion() {
        return this.callerClassVersion;
    }

    private void setCallerMethodName(String callerMethodName) {
        this.callerMethodName = callerMethodName;
    }

    public String getCallerMethodName() {
        return this.callerMethodName;
    }

    private void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    private void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp.getTime());
    }

    public void setClientMsg(String clientMsg) {
        this.clientMsg = clientMsg;
    }

    public String getClientMsg() {
        return this.clientMsg;
    }

    public void setServerMsg(String serverMsg) {
        this.serverMsg = serverMsg;
    }

    public String getServerMsg() {
        if (this.serverMsg == null) {
            return "";
        }
        return this.serverMsg;
    }

    public void setNativeErrorCode(String nativeErrorCode) {
        this.nativeErrorCode = nativeErrorCode;
    }

    public String getNativeErrorCode() {
        return this.nativeErrorCode;
    }

    public static String[] getMessagePartNames() {
        String[] copy = new String[MESSAGE_PART_NAMES.length];
        System.arraycopy(MESSAGE_PART_NAMES, 0, copy, 0, MESSAGE_PART_NAMES.length);
        return copy;
    }

    private String getCauseClassName() {
        if (this.getCause() != null) {
            return this.getCause().getClass().getName();
        }
        return null;
    }

    public void clearDetails() {
        this.callerClassName = UNKNOWN;
        this.callerClassVersion = UNKNOWN;
        this.callerMethodName = UNKNOWN;
        this.nativeErrorCode = UNKNOWN;
        this.clientMsg = NO_DETAILS;
        this.javaVersion = UNKNOWN;
    }

    private static Object nullify(Object[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        return args[0];
    }
}

