/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.extension;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.osgi.framework.Bundle;

final class LazyExecutableExtension
implements InvocationHandler {
    private final IConfigurationElement configurationElement;
    private final String name;
    private volatile Object delegate;

    static Object newInstance(IConfigurationElement configurationElement, String name) {
        String className = configurationElement.getAttribute(name);
        if (className == null) {
            return null;
        }
        Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)configurationElement.getContributor());
        if (bundle == null) {
            throw new IllegalStateException("Could not resolve bundle for configuration element " + configurationElement.getName());
        }
        try {
            Class clazz = bundle.loadClass(className);
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length == 0) {
                throw new IllegalStateException("Executable extension " + className + " within configuration element " + configurationElement.getName() + " does not have any interfaces, but they are required.");
            }
            return Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, (InvocationHandler)new LazyExecutableExtension(configurationElement, name));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load class " + className + " from bundle " + bundle.getSymbolicName(), e);
        }
    }

    private LazyExecutableExtension(IConfigurationElement configurationElement, String name) {
        this.configurationElement = configurationElement;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        LazyExecutableExtension lazyExecutableExtension = this;
        synchronized (lazyExecutableExtension) {
            if (this.delegate == null) {
                this.delegate = this.configurationElement.createExecutableExtension(this.name);
            }
        }
        return method.invoke(this.delegate, args);
    }
}

