/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.logging;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.logging.DeferringLoggerFactory;
import org.eclipse.riena.internal.core.logging.LoggerMill;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerProvider {
    private static ServiceTracker loggerMillTracker = null;
    private static int openCount = 0;

    public synchronized void start() throws Exception {
        if (openCount++ == 0) {
            if (loggerMillTracker == null) {
                loggerMillTracker = new ServiceTracker(Activator.getDefault().getContext(), LoggerMill.class.getName(), null);
            }
            loggerMillTracker.open();
        }
    }

    public synchronized void stop() throws Exception {
        if (--openCount == 0) {
            loggerMillTracker.close();
        }
    }

    public Logger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String name) {
        LoggerMill loggerMill = this.getReadyLoggerMill();
        if (loggerMill != null) {
            return loggerMill.getLogger(name);
        }
        return DeferringLoggerFactory.createLogger(name, this);
    }

    public Logger getRealLogger(String name) {
        LoggerMill loggerMill = this.getReadyLoggerMill();
        if (loggerMill == null) {
            return null;
        }
        return loggerMill.getLogger(name);
    }

    public boolean hasReadyLoggerMill() {
        return this.getReadyLoggerMill() != null;
    }

    private synchronized LoggerMill getReadyLoggerMill() {
        LoggerMill loggerMill = (LoggerMill)loggerMillTracker.getService();
        if (loggerMill != null && loggerMill.isReady()) {
            return loggerMill;
        }
        return null;
    }
}

