/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.service;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.service.FilterInjector;
import org.eclipse.riena.core.service.RankingInjector;
import org.eclipse.riena.core.service.ServiceInjector;

public class ServiceDescriptor {
    private String clazz;
    private boolean ranking;
    private String filter;

    public ServiceDescriptor(String clazz) {
        Assert.isNotNull((Object)clazz, (String)"Service clazz must not be null.");
        this.clazz = clazz;
    }

    public ServiceDescriptor useFilter(String filter) {
        Assert.isTrue((this.filter == null ? 1 : 0) != 0, (String)"Filter has already been set!");
        Assert.isNotNull((Object)filter, (String)"Filter must not be null.");
        this.filter = filter;
        return this;
    }

    public ServiceDescriptor useRanking() {
        Assert.isTrue((!this.ranking ? 1 : 0) != 0, (String)"Ranking has already been set!");
        this.ranking = true;
        return this;
    }

    public ServiceInjector into(Object target) {
        Assert.isNotNull((Object)target, (String)"Target must not be null.");
        return this.ranking ? new RankingInjector(this, target) : new FilterInjector(this, target);
    }

    String getServiceClazz() {
        return this.clazz;
    }

    String getFilter() {
        return this.filter;
    }
}

