/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import org.eclipse.riena.internal.core.Activator;
import org.osgi.framework.Bundle;

public final class ContainerModel {
    public static final String RIENA_CONTAINER_TYPE = "riena.container.type";
    public static final String ORG_ECLIPSE_EQUINOX_HTTP = "org.eclipse.equinox.http";
    private static Type containerType;

    static {
        ContainerModel.initialize();
    }

    private ContainerModel() {
    }

    public static boolean isClient() {
        return containerType == Type.CLIENT;
    }

    public static boolean isServer() {
        return containerType == Type.SERVER;
    }

    private static void initialize() {
        String s = System.getProperty(RIENA_CONTAINER_TYPE);
        containerType = Type.CLIENT;
        if (s != null) {
            if (s.equals("server")) {
                containerType = Type.SERVER;
            }
        } else {
            Bundle[] bundles;
            Bundle[] bundleArray = bundles = Activator.getDefault().getContext().getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle.getSymbolicName().startsWith(ORG_ECLIPSE_EQUINOX_HTTP)) {
                    containerType = Type.SERVER;
                    break;
                }
                ++n2;
            }
        }
        Activator.getDefault().getLogger(ContainerModel.class).log(3, "!!! Riena is running in " + (Object)((Object)containerType) + " mode !!!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        CLIENT,
        SERVER;

    }
}

