/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Iter {
    private Iter() {
    }

    public static <T> Iterable<T> able(Iterator<T> iterator) {
        if (iterator == null) {
            return Collections.emptyList();
        }
        return new IteratorIterable(iterator);
    }

    public static <T> Iterable<T> able(Enumeration<T> enumeration) {
        if (enumeration == null) {
            return Collections.emptyList();
        }
        return new IteratorIterable(new EnumerationIterator(enumeration));
    }

    public static <T> Iterable<T> able(T ... array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(array);
    }

    public static <T> Iterable<T> able(Iterator iterator, Class<T> t) {
        return Iter.able(iterator);
    }

    public static <T> Iterable<T> able(Enumeration enumeration, Class<T> t) {
        return Iter.able(enumeration);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumerationIterator<T>
    implements Iterator<T> {
        private Enumeration<T> enumeration;

        private EnumerationIterator(Enumeration<T> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public T next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new NoSuchMethodError("No remove() on an wrapped Enumeration!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IteratorIterable<T>
    implements Iterable<T> {
        private Iterator<T> iterator;

        private IteratorIterable(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<T> iterator() {
            return this.iterator;
        }
    }
}

