/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesUtils {
    private static final String PAIR_DELIM = ";";
    private static final char LIST_DELIM = ',';
    private static final char ESCAPE_CHAR = '\\';
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final int CHAR = 0;
    private static final int BACK_SLASH = 1;

    private PropertiesUtils() {
    }

    public static String accessProperty(Object propValue, String returnIfNoString) {
        if (propValue instanceof String) {
            return (String)propValue;
        }
        if (propValue instanceof String[]) {
            return ((String[])propValue)[0];
        }
        return returnIfNoString;
    }

    public static Map<String, String> asMap(Object data, String ... expectedKeys) {
        return PropertiesUtils.asMap(data, null, expectedKeys);
    }

    public static Map<String, String> asMap(Object data, Map<String, String> defaults, String ... expectedKeys) {
        Map<String, String> result = null;
        if (data == null) {
            result = new HashMap();
        } else if (data instanceof Hashtable) {
            result = (Hashtable)data;
        } else if (data instanceof String) {
            String stringified = (String)data;
            result = new HashMap();
            if (StringUtils.isEmpty(stringified)) {
                Assert.isLegal((expectedKeys.length == 0 ? 1 : 0) != 0, (String)("Excpeted keys " + Arrays.toString(expectedKeys) + " not found in empty string."));
                return new HashMap<String, String>();
            }
            StringTokenizer parts = new StringTokenizer(stringified, PAIR_DELIM);
            while (parts.hasMoreTokens()) {
                String part = parts.nextToken();
                int equal = part.indexOf(61);
                Assert.isLegal((equal > 0 ? 1 : 0) != 0, (String)"Error within definition. Expecting a string of the form:  [ <key> \"=\" <value> ] { [ \";\" <key> \"=\" <value> ] }");
                result.put(part.substring(0, equal).trim(), part.substring(equal + 1).trim());
            }
        } else {
            Assert.isLegal((boolean)false, (String)("Can not deal with data type: " + data.getClass().getName()));
        }
        if (defaults != null) {
            for (Map.Entry<String, String> entry : defaults.entrySet()) {
                if (result.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        String[] stringArray = expectedKeys;
        int n = expectedKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedKey = stringArray[n2];
            Assert.isLegal((boolean)result.containsKey(expectedKey), (String)("data " + data + "does not contain expected key " + expectedKey + "."));
            ++n2;
        }
        return Collections.unmodifiableMap(result);
    }

    public static String[] asArray(Object data) {
        if (data == null) {
            return EMPTY_STRING_ARRAY;
        }
        Assert.isLegal((boolean)(data instanceof String), (String)"data must be of type String.");
        String stringified = (String)data;
        if (StringUtils.isEmpty(stringified)) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder value = new StringBuilder();
        char ch = '\u0000';
        int state = 0;
        int i = 0;
        while (i < stringified.length()) {
            ch = stringified.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '\\') {
                        state = 1;
                        break;
                    }
                    if (ch == ',') {
                        result.add(value.toString());
                        value.setLength(0);
                        break;
                    }
                    value.append(ch);
                    break;
                }
                case 1: {
                    if (ch == '\\' || ch == ',') {
                        value.append(ch);
                    } else {
                        Assert.isLegal((boolean)false, (String)("Unknown escaped character: " + ch + "."));
                    }
                    state = 0;
                    break;
                }
            }
            ++i;
        }
        if (value.length() != 0 || ch == ',') {
            result.add(value.toString());
        }
        return result.toArray(new String[result.size()]);
    }
}

