/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.exceptionmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.riena.internal.core.exceptionmanager.TopologicalNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopologicalSort {
    private TopologicalSort() {
    }

    public static <T> List<T> sort(List<TopologicalNode<T>> nodes) {
        HashMap<String, TopologicalNode<T>> topSort = new HashMap<String, TopologicalNode<T>>(nodes.size());
        for (TopologicalNode<T> node : nodes) {
            topSort.put(node.getName(), node);
        }
        for (TopologicalNode<T> node : nodes) {
            TopologicalNode beforeNode;
            if (node.getBefore() == null || (beforeNode = (TopologicalNode)topSort.get(node.getBefore())) == null) continue;
            beforeNode.increase();
        }
        ArrayList<TopologicalNode<T>> workNodes = new ArrayList<TopologicalNode<T>>(nodes);
        ArrayList result = new ArrayList(nodes.size());
        while (!workNodes.isEmpty()) {
            boolean foundNode = false;
            Iterator itr = workNodes.iterator();
            while (itr.hasNext()) {
                TopologicalNode topologicalNode = (TopologicalNode)itr.next();
                if (topologicalNode.getPointToMe() != 0) continue;
                TopologicalNode beforeNode = (TopologicalNode)topSort.get(topologicalNode.getBefore());
                if (beforeNode != null) {
                    beforeNode.decrease();
                    foundNode = true;
                }
                itr.remove();
                result.add(topologicalNode.getElement());
            }
            if (foundNode) continue;
            for (TopologicalNode topologicalNode : workNodes) {
                result.add(topologicalNode.getElement());
            }
        }
        return result;
    }
}

