/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.client.customer.controllers;

import java.util.ArrayList;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.demo.client.customer.model.SearchResultContainer;
import org.eclipse.riena.demo.customer.common.CustomerRecordOverview;
import org.eclipse.riena.demo.customer.common.CustomerSearchBean;
import org.eclipse.riena.demo.customer.common.CustomerSearchResult;
import org.eclipse.riena.demo.customer.common.ICustomerDemoService;
import org.eclipse.riena.internal.demo.customer.client.Activator;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class CustomerSearchController
extends SubModuleController {
    private CustomerSearchBean customerSearchBean = new CustomerSearchBean();
    private CustomerSearchResult ergebnis;
    private ICustomerDemoService customerDemoService;

    public void bind(ICustomerDemoService customerDemoService) {
        this.customerDemoService = customerDemoService;
    }

    public void unbind(ICustomerDemoService customerDemoService) {
        this.customerDemoService = null;
    }

    public void configureRidgets() {
        Inject.service(ICustomerDemoService.class).into((Object)this).andStart(Activator.getDefault().getBundle().getBundleContext());
        ITextRidget suchName = (ITextRidget)this.getRidget("suchName");
        suchName.bindToModel((Object)this.customerSearchBean, "lastName");
        suchName.setMandatory(true);
        ((ITextRidget)this.getRidget("suchVorname")).bindToModel((Object)this.customerSearchBean, "firstName");
        ((ITextRidget)this.getRidget("suchPlz")).bindToModel((Object)this.customerSearchBean, "zipcode");
        ((ITextRidget)this.getRidget("suchOrt")).bindToModel((Object)this.customerSearchBean, "city");
        ((ITextRidget)this.getRidget("suchStrasse")).bindToModel((Object)this.customerSearchBean, "street");
        final ITableRidget kunden = (ITableRidget)this.getRidget("ergebnis");
        String[] columnNames = new String[]{"lastname", "firstname", "custno.", "birthdate", "street", "zip", "city", "status", "salesrep", "phone"};
        String[] propertyNames = new String[]{"lastName", "firstName", "customerNumber", "birthdate", "street", "zipcode", "city", "status", "salesrepno", "telefoneNumber"};
        final SearchResultContainer searchResultContainer = new SearchResultContainer();
        kunden.bindToModel((Object)searchResultContainer, "customerList", CustomerRecordOverview.class, propertyNames, columnNames);
        ((IActionRidget)this.getRidget("openCustomer")).addListener(new IActionListener(){

            public void callback() {
                int selectionIndex = kunden.getSelectionIndex();
                if (selectionIndex >= 0) {
                    ((ISubModuleNode)CustomerSearchController.this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.demo.client.module.CustomerRecord", Integer.valueOf(selectionIndex).toString()), new NavigationArgument((Object)searchResultContainer.getCustomerList().get(selectionIndex)));
                }
            }
        });
        ((IActionRidget)this.getRidget("reset")).addListener(new IActionListener(){

            public void callback() {
                searchResultContainer.setCustomerList(null);
                CustomerSearchController.this.getRidget("ergebnis").updateFromModel();
            }
        });
        ((IActionRidget)this.getRidget("search")).addListener(new IActionListener(){

            public void callback() {
                searchResultContainer.setCustomerList(null);
                CustomerSearchController.this.getRidget("ergebnis").updateFromModel();
                CustomerSearchController.this.ergebnis = CustomerSearchController.this.customerDemoService.suche(CustomerSearchController.this.getSuchPerson());
                if (CustomerSearchController.this.ergebnis == null || CustomerSearchController.this.ergebnis.getFehler()) {
                    ((ILabelRidget)CustomerSearchController.this.getRidget("treffer")).setText("Keine Treffer");
                    CustomerSearchController.this.getRidget("treffer").updateFromModel();
                    return;
                }
                ((ILabelRidget)CustomerSearchController.this.getRidget("treffer")).setText(String.valueOf(CustomerSearchController.this.ergebnis.getErgebnismenge()) + " Treffer");
                CustomerSearchController.this.getRidget("treffer").updateFromModel();
                ArrayList<CustomerRecordOverview> result = new ArrayList<CustomerRecordOverview>();
                CustomerRecordOverview[] customerRecordOverviewArray = CustomerSearchController.this.ergebnis.getErgebnis();
                int n = customerRecordOverviewArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CustomerRecordOverview cust = customerRecordOverviewArray[n2];
                    result.add(cust);
                    ++n2;
                }
                searchResultContainer.setCustomerList(result);
                CustomerSearchController.this.getRidget("ergebnis").updateFromModel();
            }
        });
    }

    public CustomerSearchBean getSuchPerson() {
        return this.customerSearchBean;
    }

    public void afterBind() {
        super.afterBind();
        ITableRidget kunden = (ITableRidget)this.getRidget("ergebnis");
        kunden.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        int i = 0;
        while (i < 9) {
            kunden.setColumnSortable(i, true);
            ++i;
        }
    }
}

