/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.communication;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.riena.communication.core.progressmonitor.AbstractRemoteProgressMonitor;
import org.eclipse.riena.communication.core.progressmonitor.RemoteProgressMonitorEvent;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.model.ApplicationNode;
import org.eclipse.riena.navigation.ui.application.VisualizerFactory;
import org.eclipse.riena.ui.core.uiprocess.IUIMonitor;
import org.eclipse.riena.ui.core.uiprocess.ProcessInfo;
import org.eclipse.riena.ui.core.uiprocess.UICallbackDispatcher;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;

public class ServiceProgressVisualizer
extends AbstractRemoteProgressMonitor {
    private static final double NORMALIZED_TOTAL_WORK = 10000.0;
    private IProgressMonitor progressMonitor;
    private String taskName;
    private Map<CommunicationDirection, CommunicationChannel> channels = new HashMap<CommunicationDirection, CommunicationChannel>();

    public ServiceProgressVisualizer(String taskname, IProgressMonitor progressMonitor) {
        this.init(taskname, progressMonitor);
    }

    public ServiceProgressVisualizer(String taskname) {
        UICallbackDispatcher callBackDispatcher = new UICallbackDispatcher(UIProcess.getSynchronizerFromExtensionPoint());
        ISubApplicationNode subApplicationNode = this.locateActiveSubApplicationNode();
        callBackDispatcher.addUIMonitor((IUIMonitor)new VisualizerFactory().getProgressVisualizer((Object)subApplicationNode));
        this.progressMonitor = callBackDispatcher.createThreadSwitcher();
        this.init(taskname, this.progressMonitor);
        this.configureProcessInfo(callBackDispatcher, subApplicationNode);
    }

    private void init(String taskname, IProgressMonitor progressMonitor) {
        this.initChannels();
        this.taskName = taskname;
        this.progressMonitor = progressMonitor;
    }

    private void initChannels() {
        this.channels.put(CommunicationDirection.REQUEST, new CommunicationChannel());
        this.channels.put(CommunicationDirection.RESPONSE, new CommunicationChannel());
    }

    private void configureProcessInfo(UICallbackDispatcher callBackDispatcher, ISubApplicationNode applicationNode) {
        ProcessInfo processInfo = callBackDispatcher.getProcessInfo();
        processInfo.setNote(this.taskName);
        processInfo.setTitle(this.taskName);
        processInfo.setDialogVisible(true);
        processInfo.setContext((Object)applicationNode);
        processInfo.addPropertyChangeListener((PropertyChangeListener)new RemoteServiceCancelListener());
    }

    protected ISubApplicationNode locateActiveSubApplicationNode() {
        ApplicationNode applicationNode = (ApplicationNode)ApplicationNodeManager.getApplicationNode();
        for (ISubApplicationNode child : applicationNode.getChildren()) {
            if (!child.isActivated()) continue;
            return child;
        }
        return null;
    }

    public void start() {
        super.start();
        this.progressMonitor.beginTask(this.taskName, 10000);
    }

    CommunicationChannel getChannel(CommunicationDirection communicationDrection) {
        return this.channels.get((Object)communicationDrection);
    }

    public void request(int bytes, int totalBytes) {
        this.workUntisCompleted(bytes, totalBytes, this.getChannel(CommunicationDirection.REQUEST));
    }

    public void request(RemoteProgressMonitorEvent event) {
        this.request(event.getBytesProcessed(), event.getTotalBytes());
    }

    public void response(int bytes, int totalBytes) {
        this.workUntisCompleted(bytes, totalBytes, this.getChannel(CommunicationDirection.RESPONSE));
    }

    public void response(RemoteProgressMonitorEvent event) {
        this.response(event.getBytesProcessed(), event.getTotalBytes());
    }

    private void workUntisCompleted(int bytes, int totalBytes, CommunicationChannel communicationChannel) {
        communicationChannel.actualTotalWork = totalBytes;
        this.updateWorked(bytes, communicationChannel);
        if (this.transferComplete()) {
            this.progressMonitor.done();
            return;
        }
        this.progressMonitor.worked(this.calculateTotalNormalizedProgress());
    }

    private boolean transferComplete() {
        return (double)this.calculateTotalNormalizedProgress() >= 10000.0;
    }

    private int calculateTotalNormalizedProgress() {
        int sum = 0;
        for (CommunicationChannel channel : this.channels.values()) {
            sum += channel.normalizeActualWorkedUnits();
        }
        return sum;
    }

    private void updateWorked(int bytes, CommunicationChannel communicationChannel) {
        communicationChannel.workUnitsDone(bytes);
    }

    private static class CommunicationChannel {
        private int actualTotalWork = 0;
        private int actualWorkedUnits = 0;

        private CommunicationChannel() {
        }

        int getActualTotalWork() {
            return this.actualTotalWork;
        }

        void setActualTotalWork(int actualTotalWork) {
            this.actualTotalWork = actualTotalWork;
        }

        int getActualWorkedUnits() {
            return this.actualWorkedUnits;
        }

        void setActualWorkedUnits(int actualWorkedUnits) {
            this.actualWorkedUnits = actualWorkedUnits;
        }

        void workUnitsDone(int bytes) {
            this.setActualWorkedUnits(this.getActualWorkedUnits() + bytes);
        }

        int normalizeActualWorkedUnits() {
            if (this.actualWorkedUnits == 0) {
                return 0;
            }
            double workMultiplier = Double.valueOf(this.actualWorkedUnits) / Double.valueOf(this.actualTotalWork);
            return (int)(5000.0 * workMultiplier);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CommunicationDirection {
        REQUEST,
        RESPONSE;

    }

    private static class RemoteServiceCancelListener
    implements PropertyChangeListener {
        private RemoteServiceCancelListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            "cancel".equals(evt.getPropertyName());
        }
    }
}

