/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.beans.common.StringManager;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.example.client.Activator;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class LogCollectorSubModuleController
extends SubModuleController {
    private final StringManager logLevels;
    private final StringManager customLevels;
    private final StringBean logMessageBean = new StringBean("Log text");
    private final StringBean customMessageBean = new StringBean("Custom text");
    private final StringBean exceptionBean = new StringBean(NullPointerException.class.getName());
    private IComboRidget logLevelCombo;
    private IComboRidget customLevelCombo;
    private ITextRidget logMessage;
    private ITextRidget customMessage;
    private ITextRidget logException;
    private static final Logger LOGGER = Activator.getDefault().getLogger(LogCollectorSubModuleController.class);

    public LogCollectorSubModuleController() {
        this(null);
    }

    public LogCollectorSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        this.logLevels = new StringManager(new String[]{"DEBUG", "INFO", "WARN", "ERROR"});
        this.logLevels.setSelectedItem("DEBUG");
        this.customLevels = new StringManager(new String[]{"USAGE", "STATS", "SEND"});
        this.customLevels.setSelectedItem("USAGE");
    }

    public void afterBind() {
        super.afterBind();
        this.bindModels();
    }

    private void bindModels() {
        this.logLevelCombo.bindToModel((Object)this.logLevels, "items", String.class, null, (Object)this.logLevels, "selectedItem");
        this.logLevelCombo.updateFromModel();
        this.logMessage.bindToModel((Object)this.logMessageBean, "value");
        this.logMessage.updateFromModel();
        this.logException.bindToModel((Object)this.exceptionBean, "value");
        this.logException.updateFromModel();
        this.customLevelCombo.bindToModel((Object)this.customLevels, "items", String.class, null, (Object)this.customLevels, "selectedItem");
        this.customLevelCombo.updateFromModel();
        this.customMessage.bindToModel((Object)this.customMessageBean, "value");
        this.customMessage.updateFromModel();
    }

    public void configureRidgets() {
        this.logLevelCombo = (IComboRidget)this.getRidget("logLevelCombo");
        this.logMessage = (ITextRidget)this.getRidget("logMessage");
        this.logException = (ITextRidget)this.getRidget("logException");
        IActionRidget logButtonSave = (IActionRidget)this.getRidget("logButton");
        logButtonSave.setText("&Log");
        logButtonSave.addListener(new IActionListener(){

            public void callback() {
                Throwable throwable = null;
                try {
                    if (!StringUtils.isDeepEmpty((String)LogCollectorSubModuleController.this.logException.getText())) {
                        throwable = (Throwable)Class.forName(LogCollectorSubModuleController.this.logException.getText()).newInstance();
                    }
                }
                catch (Exception e) {
                    throwable = new IllegalArgumentException("Can not instantiate logException: " + LogCollectorSubModuleController.this.logException.getText(), e);
                }
                LOGGER.log(4 - LogCollectorSubModuleController.this.logLevelCombo.getSelectionIndex(), LogCollectorSubModuleController.this.logMessage.getText(), throwable);
            }
        });
        this.customLevelCombo = (IComboRidget)this.getRidget("customLevelCombo");
        this.customMessage = (ITextRidget)this.getRidget("customMessage");
        IActionRidget customButtonSave = (IActionRidget)this.getRidget("customButton");
        customButtonSave.setText("&CustomLog");
        customButtonSave.addListener(new IActionListener(){

            public void callback() {
                LOGGER.log(-LogCollectorSubModuleController.this.customLevelCombo.getSelectionIndex(), LogCollectorSubModuleController.this.customMessage.getText());
            }
        });
    }
}

